package com.bxm.localnews.activity.task;

import com.bxm.localnews.activity.service.SignFacadeService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class SyncSignRankingTask extends AbstractCronTask<String> {

    @Resource
    private SignFacadeService signFacadeService;

    @Override
    protected ReturnT<String> service(String param) {
        signFacadeService.syncSignRanking();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncSignRankingTask";
    }

    @Override
    public String cron() {
        return "0 5 0 * * ?";
    }

    @Override
    public String description() {
        return "核对签到排行榜人数并选择是否开通";
    }

}
