package com.bxm.localnews.activity.vote.strategy.impl;

import com.bxm.localnews.activity.dto.VoteDetailDTO;
import com.bxm.localnews.activity.param.VotePinParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

import static com.bxm.localnews.common.constant.RedisConfig.USER_VOTE_KEY;

/**
 * 设定上限投票次数的投票策略
 */
@Component
@Slf4j
public class MaxVoteStrategy extends AbstractVoteStrategy {

    @Override
    KeyGenerator buildKey(Long userId, Long voteId) {
        return USER_VOTE_KEY.copy().appendKey(voteId).appendKey(userId);
    }

    @Override
    void expired(KeyGenerator key, Date endTime) {
        long diffSeconrd = DateUtils.getDiffSeconed(new Date(), endTime, true);
        redisHashMapAdapter.expire(key, diffSeconrd);
    }

    @Override
    public void deal(VoteDetailDTO detail, VotePinParam param) {
        KeyGenerator key = buildKey(param.getUserId(), param.getVoteId());
        Map<String, Long> userVoteMap = redisHashMapAdapter.entries(key, Long.class);
        Long voteTotal = userVoteMap.get(VOTE_TOTAL);
        voteTotal = null == voteTotal ? 0L : voteTotal;
        Long times = userVoteMap.get(TIMES);

        //初始有一票
        long max = detail.getMax() + 1;

        //投票活动已过期
        if (detail.getExpired()) {
            setExpired(detail);
        } else if (times == null || times > 0) {
            //有投票次数，可进行投票
            setVote(detail);
        } else if (max > voteTotal) {
            //今日还可通过分享获得投票机会
            long haveTimes = max - voteTotal;
            detail.setStatus(ButtonStatus.ENABLE.name());
            detail.setStatusLabel("你已投票，点击分享可再投一次哦");
            detail.setSubTitle("还可再投" + haveTimes + "次");
            detail.setAction(Action.SHARE.name());
        } else if (voteTotal >= max) {
            detail.setStatus(ButtonStatus.DISABLE.name());
            detail.setStatusLabel("你已投票");
            detail.setSubTitle(null);
            detail.setAction(Action.SHARE.name());
        }
    }

    @Override
    public String name() {
        return "MAX";
    }
}
