/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.command;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.activity.command.TaskCommand;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.vo.BaseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferPushMsgCommand
extends BaseBean
implements TaskCommand {
    private static final Logger logger = LoggerFactory.getLogger(TransferPushMsgCommand.class);
    private static final long serialVersionUID = -8834649902300563530L;
    private TaskContext context;
    private UserAccountIntegrationService userAccountIntegrationService;
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    public TransferPushMsgCommand(TaskContext context, UserAccountIntegrationService userAccountIntegrationService, PushMsgSupplyFeignService pushMsgSupplyFeignService) {
        this.context = context;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.pushMsgSupplyFeignService = pushMsgSupplyFeignService;
    }

    @Override
    public void execute() {
        Long userId = this.context.getUserId();
        DailyTask dailyTask = this.context.getDailyTask();
        String title = "\u4efb\u52a1\u5b8c\u6210";
        Integer goldBalance = this.userAccountIntegrationService.getUserUsableGold(userId);
        String content = "\u606d\u559c\u4f60\u6210\u529f\u5b8c\u6210\u4e86\u3010" + dailyTask.getName() + "\u3011,\u83b7\u5f97" + dailyTask.getReward().longValue() + "\u6735\u82b1,\u76ee\u524d\u5171\u6709" + goldBalance + "\u6735\u82b1";
        PushMessage pushMessage = PushMessage.build().setTitle(title).setContent(content).setPersistence(this.context.getPersistenceMsg().booleanValue()).setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId)).setPayloadInfo(PushPayloadInfo.build((PushMessageEnum)TaskEnum.getPushMessageEnumByDesc((String)dailyTask.getName())).addExtend("activityName", (Object)dailyTask.getName()).addExtend("activityReward", (Object)(dailyTask.getReward().longValue() + "")).addExtend("totalGold", (Object)(goldBalance + "")));
        logger.info("\u3010\u4efb\u52a1\u5b8c\u6210\u540e\u3011\u63a8\u9001\u5b8c\u6210\u4efb\u52a1\u6d88\u606f[{}]", (Object)JSONObject.toJSONString((Object)pushMessage));
        if (this.context.getPushMsg().booleanValue()) {
            this.pushMsgSupplyFeignService.pushMsg(pushMessage);
        } else if (this.context.getPersistenceMsg().booleanValue()) {
            this.pushMsgSupplyFeignService.addMsg(pushMessage, userId);
        }
    }
}

