/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.command;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.activity.command.TaskCommand;
import com.bxm.localnews.activity.command.TransferPushMsgCommand;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.newidea.component.vo.BaseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferUserEventCommand
extends BaseBean
implements TaskCommand {
    private static final Logger logger = LoggerFactory.getLogger(TransferPushMsgCommand.class);
    private static final long serialVersionUID = -8834649902300563531L;
    private TaskContext context;
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;
    private UserAccountIntegrationService userAccountIntegrationService;

    public TransferUserEventCommand(TaskContext context, UserAccountIntegrationService userAccountIntegrationService, PushMsgSupplyFeignService pushMsgSupplyFeignService) {
        this.context = context;
        this.pushMsgSupplyFeignService = pushMsgSupplyFeignService;
        this.userAccountIntegrationService = userAccountIntegrationService;
    }

    @Override
    public void execute() {
        Long userId = this.context.getUserId();
        DailyTask dailyTask = this.context.getDailyTask();
        Integer goldBalance = this.userAccountIntegrationService.getUserUsableGold(userId);
        PushPayloadInfo pushPayloadInfo = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.TASK_COMPLETE_EVENT).addExtend("userId", (Object)userId).addExtend("activityName", (Object)dailyTask.getName()).addExtend("activityReward", (Object)dailyTask.getReward().longValue()).addExtend("totalGold", (Object)((long)goldBalance.intValue() + dailyTask.getReward().longValue()));
        logger.info("\u3010\u4efb\u52a1\u5b8c\u6210\u540e\u3011\u53d1\u9001\u7528\u6237\u81ea\u5b9a\u4e49\u4e8b\u4ef6:[{}]", (Object)JSONObject.toJSONString((Object)pushPayloadInfo));
        this.pushMsgSupplyFeignService.addUserEvent(pushPayloadInfo);
    }
}

