/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.rank.impl;

import com.bxm.localnews.activity.common.config.ActivityProperties;
import com.bxm.localnews.activity.common.constant.RankEnum;
import com.bxm.localnews.activity.dto.BaseRankTopUserDTO;
import com.bxm.localnews.activity.dto.CurrentUserRankDTO;
import com.bxm.localnews.activity.dto.ForumPostDTO;
import com.bxm.localnews.activity.dto.ForumRankUserDTO;
import com.bxm.localnews.activity.dto.InteractRankUserDTO;
import com.bxm.localnews.activity.dto.InviteRankUserDTO;
import com.bxm.localnews.activity.dto.RankBriefDTO;
import com.bxm.localnews.activity.dto.RankBriefMocDto;
import com.bxm.localnews.activity.dto.RankDetailDTO;
import com.bxm.localnews.activity.dto.RankUserCompositeDTO;
import com.bxm.localnews.activity.param.RankParam;
import com.bxm.localnews.activity.rank.RankSelfService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.UserInviteOrderVO;
import com.bxm.localnews.integration.ForumPostIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.vo.ForumPostRankForUserVo;
import com.bxm.localnews.vo.ForumRankVo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RankSelfServiceImpl
implements RankSelfService {
    private static final Logger log = LogManager.getLogger(RankSelfServiceImpl.class);
    @Autowired
    UserIntegrationService userIntegrationService;
    @Autowired
    ForumPostIntegrationService forumPostIntegrationService;
    @Autowired
    RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private ActivityProperties activityProperties;
    private static Integer RANK_TOP_MSG_LENGHT = 3;

    @Override
    public RankDetailDTO rankForumList(RankParam param) {
        RankDetailDTO rankDetailDTO = new RankDetailDTO();
        rankDetailDTO.setRankTitle(RankEnum.FORUM.getDesc());
        rankDetailDTO.setRankCode(RankEnum.FORUM.name());
        List<ForumRankVo> forumRankVoList = this.loadForum(param.getAreaCode());
        List<RankUserCompositeDTO> rankUsers = forumRankVoList.stream().map(this::convertToForum).collect(Collectors.toList());
        if (rankUsers.size() > 0) {
            rankUsers.forEach(s -> s.getForumRankUser().setFollow(Boolean.valueOf(this.userIntegrationService.isFollow(Long.valueOf(param.getUserId().longValue()), s.getForumRankUser().getRankUserId()))));
        }
        rankDetailDTO.setRankUsers(rankUsers);
        return rankDetailDTO;
    }

    @Override
    public RankDetailDTO rankInteractList(RankParam param) {
        RankDetailDTO rankDetailDTO = new RankDetailDTO();
        rankDetailDTO.setRankTitle(RankEnum.INTERACT.getDesc());
        rankDetailDTO.setRankCode(RankEnum.INTERACT.name());
        List<InteractRankInfo> interactRankInfos = this.loadInteract(param.getAreaCode());
        List<RankUserCompositeDTO> rankUsers = interactRankInfos.stream().map(this::convertToInteract).collect(Collectors.toList());
        if (rankUsers.size() > 0) {
            rankUsers.forEach(s -> s.getInteractRankUser().setFollow(Boolean.valueOf(this.userIntegrationService.isFollow(Long.valueOf(param.getUserId().longValue()), s.getInteractRankUser().getRankUserId()))));
        }
        rankDetailDTO.setRankUsers(rankUsers);
        return rankDetailDTO;
    }

    @Override
    public RankDetailDTO rankInviteList(RankParam param) {
        RankDetailDTO rankDetailDTO = new RankDetailDTO();
        rankDetailDTO.setRankTitle(RankEnum.INVITE.getDesc());
        rankDetailDTO.setRankCode(RankEnum.INVITE.name());
        List<UserInviteOrderVO> inviteRankInfos = this.loadInvite(param.getAreaCode());
        List<RankUserCompositeDTO> rankUsers = inviteRankInfos.stream().map(this::convertToInvite).collect(Collectors.toList());
        if (rankUsers.size() > 0) {
            rankUsers.forEach(s -> s.getInviteRankUser().setFollow(Boolean.valueOf(this.userIntegrationService.isFollow(Long.valueOf(param.getUserId().longValue()), s.getInviteRankUser().getRankUserId()))));
        }
        rankDetailDTO.setRankUsers(rankUsers);
        return rankDetailDTO;
    }

    @Override
    public RankBriefMocDto buildTopUserInfo(RankParam param) {
        List topUser;
        String areaCode = param.getAreaCode();
        RankBriefMocDto result = new RankBriefMocDto();
        ArrayList<RankBriefDTO> rankBrief = new ArrayList<RankBriefDTO>();
        HashMap<String, Integer> rankForUser = new HashMap<String, Integer>();
        if (((Boolean)this.activityProperties.getRankType().get(RankEnum.FORUM.name().toLowerCase())).booleanValue()) {
            RankBriefDTO forumBrief = new RankBriefDTO();
            forumBrief.setRankTitle(RankEnum.FORUM.getDesc());
            forumBrief.setRankCode(RankEnum.FORUM.name());
            List<ForumRankVo> forumByRdList = this.loadForum(areaCode);
            for (int i = 0; i < forumByRdList.size(); ++i) {
                if (!forumByRdList.get(i).getUserId().toString().equals(param.getUserId().toString())) continue;
                rankForUser.put(RankEnum.FORUM.name(), i + 1);
                break;
            }
            forumByRdList = forumByRdList.subList(0, forumByRdList.size() >= RANK_TOP_MSG_LENGHT ? RANK_TOP_MSG_LENGHT.intValue() : forumByRdList.size());
            topUser = forumByRdList.stream().map(item -> {
                BaseRankTopUserDTO baseRankTopUserDTO = new BaseRankTopUserDTO();
                baseRankTopUserDTO.setRankUserId(item.getUserId());
                baseRankTopUserDTO.setRankHeadImg(item.getUserImg());
                baseRankTopUserDTO.setRankNickName(item.getUserName());
                return baseRankTopUserDTO;
            }).collect(Collectors.toList());
            forumBrief.setTopUsers(topUser);
            rankBrief.add(forumBrief);
        }
        if (((Boolean)this.activityProperties.getRankType().get(RankEnum.INTERACT.name().toLowerCase())).booleanValue()) {
            RankBriefDTO interactBrief = new RankBriefDTO();
            interactBrief.setRankTitle(RankEnum.INTERACT.getDesc());
            interactBrief.setRankCode(RankEnum.INTERACT.name());
            List<InteractRankInfo> interactByRdList = this.loadInteract(areaCode);
            for (int i = 0; i < interactByRdList.size(); ++i) {
                if (!interactByRdList.get(i).getId().toString().equals(param.getUserId().toString())) continue;
                rankForUser.put(RankEnum.INTERACT.name(), i + 1);
                break;
            }
            interactByRdList = interactByRdList.subList(0, interactByRdList.size() >= RANK_TOP_MSG_LENGHT ? RANK_TOP_MSG_LENGHT.intValue() : interactByRdList.size());
            topUser = interactByRdList.stream().map(item -> {
                BaseRankTopUserDTO baseRankTopUserDTO = new BaseRankTopUserDTO();
                baseRankTopUserDTO.setRankUserId(item.getId());
                baseRankTopUserDTO.setRankHeadImg(item.getHeadImg());
                baseRankTopUserDTO.setRankNickName(item.getNickName());
                return baseRankTopUserDTO;
            }).collect(Collectors.toList());
            interactBrief.setTopUsers(topUser);
            rankBrief.add(interactBrief);
        }
        if (((Boolean)this.activityProperties.getRankType().get(RankEnum.INVITE.name().toLowerCase())).booleanValue()) {
            RankBriefDTO inviteBrief = new RankBriefDTO();
            inviteBrief.setRankTitle(RankEnum.INVITE.getDesc());
            inviteBrief.setRankCode(RankEnum.INVITE.name());
            List<UserInviteOrderVO> inviteOrderVOS = this.loadInvite(areaCode);
            for (int i = 0; i < inviteOrderVOS.size(); ++i) {
                if (!inviteOrderVOS.get(i).getUserId().toString().equals(param.getUserId().toString())) continue;
                rankForUser.put(RankEnum.INVITE.name(), i + 1);
                break;
            }
            inviteOrderVOS = inviteOrderVOS.subList(0, inviteOrderVOS.size() >= RANK_TOP_MSG_LENGHT ? RANK_TOP_MSG_LENGHT.intValue() : inviteOrderVOS.size());
            List topUser2 = inviteOrderVOS.stream().map(item -> {
                BaseRankTopUserDTO baseRankTopUserDTO = new BaseRankTopUserDTO();
                baseRankTopUserDTO.setRankUserId(item.getUserId());
                baseRankTopUserDTO.setRankHeadImg(item.getHeadImg());
                baseRankTopUserDTO.setRankNickName(item.getNickname());
                return baseRankTopUserDTO;
            }).collect(Collectors.toList());
            inviteBrief.setTopUsers(topUser2);
            rankBrief.add(inviteBrief);
        }
        result.setRankBrief(rankBrief);
        result.setRankForUser(rankForUser);
        return result;
    }

    private RankUserCompositeDTO convertToForum(ForumRankVo source) {
        ForumRankUserDTO forumRankUser = new ForumRankUserDTO();
        forumRankUser.setRankUserId(source.getUserId());
        forumRankUser.setRankNickName(source.getUserName());
        forumRankUser.setRankHeadImg(source.getUserImg());
        forumRankUser.setContentQualityScore(source.getContentQualityScore());
        forumRankUser.setLikeTotal(source.getLikeTotal());
        List postTitleInfo = source.getPostTitleInfo();
        forumRankUser.setPostList(postTitleInfo.stream().map(e -> {
            ForumPostDTO forumPostDTO = new ForumPostDTO();
            forumPostDTO.setId(e.getId());
            forumPostDTO.setTitle(e.getTitle());
            return forumPostDTO;
        }).collect(Collectors.toList()));
        return new RankUserCompositeDTO(forumRankUser);
    }

    private RankUserCompositeDTO convertToInteract(InteractRankInfo source) {
        InteractRankUserDTO interactRankUser = new InteractRankUserDTO();
        interactRankUser.setRankUserId(source.getId());
        interactRankUser.setRankHeadImg(source.getHeadImg());
        interactRankUser.setRankNickName(source.getNickName());
        interactRankUser.setCommentTotal(source.getReplyNum());
        return new RankUserCompositeDTO(interactRankUser);
    }

    private RankUserCompositeDTO convertToInvite(UserInviteOrderVO source) {
        InviteRankUserDTO inviteRankUser = new InviteRankUserDTO();
        inviteRankUser.setRankUserId(source.getUserId());
        inviteRankUser.setRankNickName(source.getNickname());
        inviteRankUser.setRankHeadImg(source.getHeadImg());
        inviteRankUser.setInviteTotal(source.getInviteNum());
        return new RankUserCompositeDTO(inviteRankUser);
    }

    private List<ForumRankVo> loadForum(String areaCode) {
        TypeReference<List<ForumRankVo>> typeReference = new TypeReference<List<ForumRankVo>>(){};
        List forumRankVoList = (List)this.redisHashMapAdapter.get(this.buildKey(RankEnum.FORUM), areaCode, (TypeReference)typeReference);
        if (!CollectionUtils.isEmpty((Collection)forumRankVoList)) {
            forumRankVoList.removeIf(s -> this.activityProperties.getForumRankBlack().contains(s.getUserId()));
            return forumRankVoList;
        }
        return this.loadForumRankFromDb(areaCode);
    }

    @Override
    public List<ForumRankVo> loadForumRankFromDb(String areaCode) {
        List forumRankVoListFromDb = this.forumPostIntegrationService.forumRank(areaCode, this.activityProperties.getForumRankBlack());
        if (forumRankVoListFromDb.size() > 0) {
            this.redisHashMapAdapter.put(this.buildKey(RankEnum.FORUM), areaCode, (Object)forumRankVoListFromDb);
            this.redisHashMapAdapter.expire(this.buildKey(RankEnum.FORUM), 86400L);
        }
        return forumRankVoListFromDb;
    }

    private List<InteractRankInfo> loadInteract(String areaCode) {
        TypeReference<List<InteractRankInfo>> typeReference = new TypeReference<List<InteractRankInfo>>(){};
        List interactRankInfos = (List)this.redisHashMapAdapter.get(this.buildKey(RankEnum.INTERACT), areaCode, (TypeReference)typeReference);
        if (!CollectionUtils.isEmpty((Collection)interactRankInfos)) {
            interactRankInfos.removeIf(s -> this.activityProperties.getInteractRankBlack().contains(s.getId()));
            return interactRankInfos;
        }
        return this.loadInteractRankFromDb(areaCode);
    }

    @Override
    public List<InteractRankInfo> loadInteractRankFromDb(String areaCode) {
        List interactRankInfosFromDb = this.forumPostIntegrationService.getInteractRankInfo(areaCode, Integer.valueOf(10), this.activityProperties.getInteractRankBlack());
        if (interactRankInfosFromDb.size() > 0) {
            this.redisHashMapAdapter.put(this.buildKey(RankEnum.INTERACT), areaCode, (Object)interactRankInfosFromDb);
            this.redisHashMapAdapter.expire(this.buildKey(RankEnum.INTERACT), 86400L);
        }
        return interactRankInfosFromDb;
    }

    private List<UserInviteOrderVO> loadInvite(String areaCode) {
        TypeReference<List<UserInviteOrderVO>> typeReference = new TypeReference<List<UserInviteOrderVO>>(){};
        List inviteRankInfos = (List)this.redisHashMapAdapter.get(this.buildKey(RankEnum.INVITE), areaCode, (TypeReference)typeReference);
        if (!CollectionUtils.isEmpty((Collection)inviteRankInfos)) {
            inviteRankInfos.removeIf(s -> this.activityProperties.getInviteRankBlack().contains(s.getUserId()));
            return inviteRankInfos;
        }
        return this.loadInviteRankFromDb(areaCode);
    }

    @Override
    public List<UserInviteOrderVO> loadInviteRankFromDb(String areaCode) {
        List userInviteOrderVOSFromDb = this.userIntegrationService.getOrderTen(Integer.valueOf(10), areaCode, this.activityProperties.getInviteRankBlack());
        if (userInviteOrderVOSFromDb.size() > 0) {
            this.redisHashMapAdapter.put(this.buildKey(RankEnum.INVITE), areaCode, (Object)userInviteOrderVOSFromDb);
            this.redisHashMapAdapter.expire(this.buildKey(RankEnum.INVITE), 86400L);
        }
        return userInviteOrderVOSFromDb;
    }

    @Override
    public CurrentUserRankDTO doCurrentUser(RankParam param) {
        CurrentUserRankDTO currentUserRankDTO = new CurrentUserRankDTO();
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(Long.valueOf(param.getUserId().longValue()));
        currentUserRankDTO.setUserId(Long.valueOf(param.getUserId().longValue()));
        currentUserRankDTO.setNickName(Objects.isNull(userInfoDTO) ? "" : userInfoDTO.getNickname());
        currentUserRankDTO.setHeadImg(Objects.isNull(userInfoDTO) ? "" : userInfoDTO.getHeadImg());
        currentUserRankDTO.setLikeNum(Integer.valueOf(Objects.isNull(userInfoDTO) ? 0 : userInfoDTO.getLikeNum()));
        ForumPostRankForUserVo forumPostRankForUserVo = this.forumPostIntegrationService.forumRankForUser(Long.valueOf(param.getUserId().longValue()));
        if (Objects.nonNull(forumPostRankForUserVo)) {
            currentUserRankDTO.setPostNum(forumPostRankForUserVo.getForumPostNum());
            currentUserRankDTO.setContentQualityScore(forumPostRankForUserVo.getContentQualityScore());
        } else {
            log.error("  cannot find forum info  for userId : {}", (Object)param.getUserId());
        }
        currentUserRankDTO.setCommentTotal(this.forumPostIntegrationService.replyNumForUser(Long.valueOf(param.getUserId().longValue())));
        currentUserRankDTO.setInviteTotal(this.userIntegrationService.getInviteNumByUserId(Long.valueOf(param.getUserId().longValue())).getInviteNum());
        return currentUserRankDTO;
    }

    @Override
    public Map<String, Integer> rankForUser(Long userId) {
        return null;
    }

    private KeyGenerator buildKey(RankEnum rankEnum) {
        return RedisConfig.RANK_LIST.copy().appendKey((Object)rankEnum.name().toLowerCase());
    }
}

