/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.rank.impl;

import com.bxm.localnews.activity.common.config.ActivityProperties;
import com.bxm.localnews.activity.common.constant.RankEnum;
import com.bxm.localnews.activity.dto.CurrentUserRankDTO;
import com.bxm.localnews.activity.dto.RankBriefMocDto;
import com.bxm.localnews.activity.dto.RankCompositeDTO;
import com.bxm.localnews.activity.dto.RankDetailDTO;
import com.bxm.localnews.activity.dto.RankUserCompositeDTO;
import com.bxm.localnews.activity.param.RankParam;
import com.bxm.localnews.activity.rank.RankSelfService;
import com.bxm.localnews.activity.rank.RankService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankServiceImpl
implements RankService {
    private static final Logger log = LogManager.getLogger(RankServiceImpl.class);
    @Autowired
    private RankSelfService rankSelfService;
    @Autowired
    private ActivityProperties activityProperties;
    private static String All = "all";

    @Override
    public RankBriefMocDto rankBriefList(RankParam param) {
        log.debug("input param : {}", (Object)param);
        if (!((Boolean)this.activityProperties.getRankType().get(All)).booleanValue()) {
            return null;
        }
        RankBriefMocDto result = this.rankSelfService.buildTopUserInfo(param);
        if (log.isDebugEnabled()) {
            log.debug("result : {}", (Object)result);
        }
        return result;
    }

    @Override
    public RankCompositeDTO rankCompositeInfo(RankParam param) {
        log.debug("param : {}", (Object)param);
        if (!((Boolean)this.activityProperties.getRankType().get(All)).booleanValue()) {
            return null;
        }
        RankCompositeDTO rankCompositeDTO = this.buildRankList(param);
        if (log.isDebugEnabled()) {
            log.debug("rankCompositeDTO :{}", (Object)rankCompositeDTO);
        }
        return rankCompositeDTO;
    }

    private CurrentUserRankDTO buildCurrentUserRankInfo(RankParam param) {
        return this.rankSelfService.doCurrentUser(param);
    }

    private RankCompositeDTO buildRankList(RankParam param) {
        int i;
        RankDetailDTO rankDetailDTO;
        RankCompositeDTO rankCompositeDTO = new RankCompositeDTO();
        HashMap<String, Integer> ranForUser = new HashMap<String, Integer>();
        ArrayList<RankDetailDTO> result = new ArrayList<RankDetailDTO>();
        ArrayList<RankDetailDTO> resultForNull = new ArrayList<RankDetailDTO>();
        if (((Boolean)this.activityProperties.getRankType().get(RankEnum.FORUM.name().toLowerCase())).booleanValue()) {
            rankDetailDTO = this.rankSelfService.rankForumList(param);
            if (rankDetailDTO.getRankUsers().size() > 0) {
                for (i = 0; i < rankDetailDTO.getRankUsers().size(); ++i) {
                    if (!((RankUserCompositeDTO)rankDetailDTO.getRankUsers().get(i)).getForumRankUser().getRankUserId().toString().equals(param.getUserId().toString())) continue;
                    ranForUser.put(RankEnum.FORUM.name(), i + 1);
                    break;
                }
            }
            this.sortRank(result, resultForNull, rankDetailDTO, RankEnum.FORUM, param, ranForUser);
        }
        if (((Boolean)this.activityProperties.getRankType().get(RankEnum.INTERACT.name().toLowerCase())).booleanValue()) {
            rankDetailDTO = this.rankSelfService.rankInteractList(param);
            if (rankDetailDTO.getRankUsers().size() > 0) {
                for (i = 0; i < rankDetailDTO.getRankUsers().size(); ++i) {
                    if (!((RankUserCompositeDTO)rankDetailDTO.getRankUsers().get(i)).getInteractRankUser().getRankUserId().toString().equals(param.getUserId().toString())) continue;
                    ranForUser.put(RankEnum.INTERACT.name(), i + 1);
                    break;
                }
            }
            this.sortRank(result, resultForNull, rankDetailDTO, RankEnum.INTERACT, param, ranForUser);
        }
        if (((Boolean)this.activityProperties.getRankType().get(RankEnum.INVITE.name().toLowerCase())).booleanValue()) {
            rankDetailDTO = this.rankSelfService.rankInviteList(param);
            if (rankDetailDTO.getRankUsers().size() > 0) {
                for (i = 0; i < rankDetailDTO.getRankUsers().size(); ++i) {
                    if (!((RankUserCompositeDTO)rankDetailDTO.getRankUsers().get(i)).getInviteRankUser().getRankUserId().toString().equals(param.getUserId().toString())) continue;
                    ranForUser.put(RankEnum.INVITE.name(), i + 1);
                    break;
                }
            }
            this.sortRank(result, resultForNull, rankDetailDTO, RankEnum.INVITE, param, ranForUser);
        }
        result.addAll(resultForNull);
        CurrentUserRankDTO currentUserRankDTO = this.buildCurrentUserRankInfo(param);
        currentUserRankDTO.setRankForUser(ranForUser);
        rankCompositeDTO.setRankList(result);
        rankCompositeDTO.setCurrentUser(currentUserRankDTO);
        return rankCompositeDTO;
    }

    private void sortRank(List<RankDetailDTO> result, List<RankDetailDTO> resultForNull, RankDetailDTO rankDetailDTO, RankEnum rankEnum, RankParam param, Map<String, Integer> ranForUser) {
        if (StringUtils.isNotBlank((CharSequence)param.getActiveRankCode()) && param.getActiveRankCode().equals(rankEnum.name())) {
            rankDetailDTO.setActive(Boolean.TRUE);
        }
        if (StringUtils.isBlank((CharSequence)param.getActiveRankCode()) && rankDetailDTO.getRankCode().equals(RankEnum.FORUM.name())) {
            rankDetailDTO.setActive(Boolean.TRUE);
        }
        if (rankDetailDTO.getRankUsers().size() > 0) {
            result.add(rankDetailDTO);
        } else {
            resultForNull.add(rankDetailDTO);
        }
    }
}

