/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.record.download;

import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.thirdparty.service.WxMpFacadeService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WeixinMediaDownload {
    private static final Logger logger = LoggerFactory.getLogger(WeixinMediaDownload.class);
    private String baseUrl = "https://api.weixin.qq.com/cgi-bin/media/get/jssdk?access_token=";
    private OKHttpService okHttpService;
    private BizConfigProperties bizConfigProperties;
    private SequenceCreater sequenceCreater;
    private WxMpFacadeService wxMpFacadeService;

    @Autowired
    public WeixinMediaDownload(OKHttpService okHttpService, BizConfigProperties bizConfigProperties, SequenceCreater sequenceCreater, WxMpFacadeService wxMpFacadeService) {
        this.okHttpService = okHttpService;
        this.bizConfigProperties = bizConfigProperties;
        this.sequenceCreater = sequenceCreater;
        this.wxMpFacadeService = wxMpFacadeService;
    }

    public File download(String mediaId) {
        String url = this.buildURL(mediaId);
        String filePath = this.bizConfigProperties.getTempDir() + this.sequenceCreater.nextStringId() + ".speex";
        logger.info("\u5fae\u4fe1\u5f55\u97f3\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740:[{}]", (Object)url);
        this.okHttpService.download(url, filePath);
        return new File(filePath);
    }

    private String buildURL(String mediaId) {
        return this.baseUrl + this.wxMpFacadeService.getAccessToken() + "&media_id=" + mediaId;
    }
}

