/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.record.parser.impl;

import com.baidu.aip.speech.AipSpeech;
import com.bxm.localnews.activity.common.config.ActivityProperties;
import com.bxm.localnews.activity.record.convert.ConvertProcesser;
import com.bxm.localnews.activity.record.download.OSSDownloader;
import com.bxm.localnews.activity.record.download.WeixinMediaDownload;
import com.bxm.localnews.activity.record.parser.RecordParser;
import com.bxm.localnews.activity.vo.RecordInfoBean;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordParserImpl
implements RecordParser {
    private static final Logger log = LoggerFactory.getLogger(RecordParserImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(RecordParserImpl.class);
    private AliyunOSSService aliyunOSSService;
    private ActivityProperties activityProperties;
    private WeixinMediaDownload weixinMediaDownload;
    private OSSDownloader ossDownloader;
    private ConvertProcesser convertProcesser;

    @Autowired
    public RecordParserImpl(AliyunOSSService aliyunOSSService, ActivityProperties activityProperties, WeixinMediaDownload weixinMediaDownload, ConvertProcesser convertProcesser, OSSDownloader ossDownloader) {
        this.aliyunOSSService = aliyunOSSService;
        this.activityProperties = activityProperties;
        this.weixinMediaDownload = weixinMediaDownload;
        this.convertProcesser = convertProcesser;
        this.ossDownloader = ossDownloader;
    }

    @Override
    public RecordInfoBean parse(String url, int duration) {
        File ossFile = this.ossDownloader.download(url);
        RecordInfoBean recordInfo = this.convertProcesser.convert(ossFile, duration);
        recordInfo.setOssUrl(url);
        this.parse(recordInfo);
        return recordInfo;
    }

    @Override
    public RecordInfoBean parse(File recordFile, int duration) {
        RecordInfoBean recordInfo = this.convertProcesser.convert(recordFile, duration);
        this.parse(recordInfo);
        return recordInfo;
    }

    @Override
    public RecordInfoBean parse(String mediaId) {
        File mediaFile = this.weixinMediaDownload.download(mediaId);
        RecordInfoBean recordInfo = this.convertProcesser.convert(mediaFile, -1);
        String ossUrl = this.aliyunOSSService.upload(recordInfo.getConvertFile(), null);
        recordInfo.setOssUrl(ossUrl);
        logger.info("wechat vioce ossAddress :[{}]", (Object)ossUrl);
        this.parse(recordInfo);
        return recordInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(RecordInfoBean recordInfo) {
        AipSpeech client = new AipSpeech(this.activityProperties.getBaiduAiAppId(), this.activityProperties.getBaiduAiApiKey(), this.activityProperties.getBaiduAiSecretKey());
        client.setConnectionTimeoutInMillis(10000);
        client.setSocketTimeoutInMillis(100000);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(recordInfo.getConvertFile());
            byte[] res = IOUtils.toByteArray((InputStream)fis);
            JSONObject result = client.asr(res, recordInfo.getConvertExtend(), 16000, null);
            int errorNo = result.getInt("err_no");
            if (0 == errorNo) {
                JSONArray resultArray = result.getJSONArray("result");
                String firstMatchResult = (String)resultArray.get(0);
                recordInfo.setContent(firstMatchResult);
            } else {
                recordInfo.setContent("");
                String errorMsg = result.getString("err_msg");
                log.error("\u5f55\u97f3\u89e3\u6790\u9519\u8bef\uff0cerrorCode:{},errorMsg:{}", (Object)errorNo, (Object)errorMsg);
            }
        }
        catch (Exception e) {
            recordInfo.setContent("");
            log.error("\u5f55\u97f3\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff0c\u6587\u4ef6\u4fe1\u606f:" + recordInfo, (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            this.clear(recordInfo);
        }
    }

    private void clear(RecordInfoBean recordInfo) {
        boolean reuslt;
        boolean result;
        if (null != recordInfo.getSourceFile() && !(result = recordInfo.getSourceFile().delete())) {
            log.warn("\u6587\u4ef6\u65e0\u6cd5\u5220\u9664\u6216\u4e0d\u5b58\u5728,\u6587\u4ef6\u8def\u5f84\uff1a" + recordInfo.getSourceFile());
        }
        if (null != recordInfo.getConvertFile() && !(reuslt = recordInfo.getConvertFile().delete())) {
            log.warn("\u6587\u4ef6\u65e0\u6cd5\u5220\u9664\u6216\u4e0d\u5b58\u5728,\u6587\u4ef6\u8def\u5f84\uff1a" + recordInfo.getConvertFile());
        }
    }
}

