/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.common.constant.CouponLabelEnum;
import com.bxm.localnews.activity.domain.CouponMapper;
import com.bxm.localnews.activity.dto.CouponDTO;
import com.bxm.localnews.activity.dto.CouponDetailDTO;
import com.bxm.localnews.activity.param.CouponParam;
import com.bxm.localnews.activity.service.CouponService;
import com.bxm.localnews.activity.vo.Coupon;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponServiceImpl
implements CouponService {
    @Autowired
    private CouponMapper couponMapper;

    @Override
    public PageWarper<CouponDTO> listCoupon(CouponParam couponParam) {
        List couponList = this.couponMapper.queryByPageSize(couponParam);
        PageWarper pageWarper = new PageWarper(couponList);
        List<CouponDTO> couponDTOList = couponList.stream().sorted(Comparator.comparing(Coupon::getDaySales).reversed()).map(this::convertCoupon).collect(Collectors.toList());
        this.fillingCouponDto(couponDTOList);
        pageWarper.setList(couponDTOList);
        return pageWarper;
    }

    private CouponDTO convertCoupon(Coupon coupon) {
        CouponDTO couponDTO = new CouponDTO();
        BeanUtils.copyProperties((Object)coupon, (Object)couponDTO);
        return couponDTO;
    }

    private void fillingCouponDto(List<CouponDTO> couponDTOList) {
        Iterator<CouponDTO> it = couponDTOList.iterator();
        int size = couponDTOList.size();
        for (int i = 0; i < size; ++i) {
            CouponDTO c = it.next();
            if ((i & 1) != 1) {
                c.setLabel(CouponLabelEnum.SHIPPING_99.getDesc());
                continue;
            }
            c.setLabel(CouponLabelEnum.SAVE_MONEY.getDesc());
        }
    }

    @Override
    public CouponDetailDTO getCouponDetail(Long id) {
        Coupon coupon = this.couponMapper.selectByPrimaryKey(id);
        CouponDetailDTO couponDetailDTO = new CouponDetailDTO();
        BeanUtils.copyProperties((Object)coupon, (Object)couponDetailDTO);
        return couponDetailDTO;
    }
}

