/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.common.config.SignProperties;
import com.bxm.localnews.activity.domain.SignRecordMapper;
import com.bxm.localnews.activity.dto.CalendarSignDTO;
import com.bxm.localnews.activity.dto.SignDTO;
import com.bxm.localnews.activity.dto.SignLeaderBoard;
import com.bxm.localnews.activity.service.DailySignService;
import com.bxm.localnews.activity.service.SignConfigService;
import com.bxm.localnews.activity.vo.SignConfig;
import com.bxm.localnews.activity.vo.SignRecord;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DailySignServiceImpl
extends BaseService
implements DailySignService {
    @Autowired
    private SignConfigService signConfigService;
    @Autowired
    private SignRecordMapper signRecordMapper;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private UserAccountIntegrationService userAccountIntegrationService;
    @Autowired
    private RedisZSetAdapter redisZSetAdapter;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private LocationFacadeService locationFacadeService;
    @Autowired
    private SignProperties signProperties;

    @Override
    public SignDTO signRecord(Long userId, String areaCode) {
        SignDTO signDTO = this.generateSign(userId);
        signDTO.setEnableSignBoard(Byte.valueOf((byte)0));
        LocationDetailDTO locationDetailDTO = this.locationFacadeService.getLocationDetailByCode(areaCode);
        if (null != locationDetailDTO && locationDetailDTO.getEnableSignBoard() == 1) {
            signDTO.setEnableSignBoard(Byte.valueOf((byte)1));
        }
        return signDTO;
    }

    @Override
    public List<CalendarSignDTO> listSignRecord(Long userId) {
        Date now = new Date();
        String signDate = DateUtils.formatDate((Date)now);
        String beforeDate = DateUtils.formatDate((Date)DateUtils.addField((Date)DateUtils.parseDate((String)signDate), (int)2, (int)-1));
        List<CalendarSignDTO> beforeSignRecords = this.getMonthSignRecord(userId, beforeDate);
        List<CalendarSignDTO> signRecords = this.getMonthSignRecord(userId, signDate);
        beforeSignRecords.addAll(signRecords);
        return beforeSignRecords;
    }

    @Override
    public Message executeUserSign(Long userId, String areaCode) {
        Message message = Message.build();
        SignDTO signDTO = this.generateSign(userId);
        if (signDTO.isTodaySignState()) {
            return message.setSuccess(false).setMessage("\u7528\u6237\u5df2\u7b7e\u5230");
        }
        String requestId = String.valueOf(this.nextId());
        Long id = this.nextId();
        if (!this.distributedLock.lock(userId + "" + id, requestId)) {
            return message.setSuccess(false).setMessage("\u7528\u6237\u5df2\u7b7e\u5230");
        }
        int signDay = signDTO.getCount().intValue() + 1;
        Date date = new Date();
        SignRecord signRecord = new SignRecord(id, userId, date, Integer.valueOf(signDay), Long.valueOf(signDTO.getGold().longValue()), Boolean.valueOf(false), areaCode);
        this.signRecordMapper.insertSelective(signRecord);
        AccountGoldParam param = new AccountGoldParam(userId, "USABLE_GOLD", Boolean.valueOf(true), signDTO.getGold(), id, "SIGN_DAILY");
        this.userAccountIntegrationService.addGold(param);
        this.record2redis(userId, date);
        this.rankingSignRecord(userId);
        this.distributedLock.unlock(userId + "" + id, requestId);
        return message;
    }

    private void record2redis(Long userId, Date date) {
        KeyGenerator signRecordKey = RedisConfig.SIGN_NOTIFICATION_KEY.copy().appendKey((Object)DateUtils.formatDate((Date)date));
        this.redisSetAdapter.add(signRecordKey, new Object[]{userId});
        this.redisSetAdapter.expire(signRecordKey, 172800L);
    }

    private void rankingSignRecord(Long userId) {
        List signRecordList = this.signRecordMapper.listUserSignRecord(userId);
        if (CollectionUtils.isNotEmpty((Collection)signRecordList)) {
            SignRecord yesterdaySign;
            String lastAreaCode;
            UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
            if (null == userInfoDTO) {
                return;
            }
            SignRecord todaySign = (SignRecord)signRecordList.get(0);
            String areaCode = todaySign.getAreaCode();
            if (StringUtils.isNotEmpty((CharSequence)areaCode)) {
                SignLeaderBoard.LeaderBoard leaderBoard = new SignLeaderBoard.LeaderBoard();
                leaderBoard.setUserId(todaySign.getUserId());
                leaderBoard.setCount(todaySign.getSignDay());
                leaderBoard.setNickname(userInfoDTO.getNickname() == null ? "" : userInfoDTO.getNickname());
                leaderBoard.setHeadImg(StringUtils.isEmpty((CharSequence)userInfoDTO.getHeadImg()) ? this.userIntegrationService.getDefaultHeadImgUrl() : userInfoDTO.getHeadImg());
                KeyGenerator signRecordKey = RedisConfig.SIGN_RANKING_KEY.copy().appendKey((Object)areaCode);
                Set leaderBoardSet = this.redisZSetAdapter.range(signRecordKey, 0L, 100L, true, SignLeaderBoard.LeaderBoard.class);
                Optional<SignLeaderBoard.LeaderBoard> boardOptional = leaderBoardSet.stream().filter(e -> e.getUserId().equals(leaderBoard.getUserId())).findFirst();
                if (boardOptional.isPresent()) {
                    this.redisZSetAdapter.remove(signRecordKey, new Object[]{boardOptional.get()});
                    this.redisZSetAdapter.add(signRecordKey, (Object)leaderBoard, (double)leaderBoard.getCount().intValue());
                } else {
                    this.redisZSetAdapter.add(signRecordKey, (Object)leaderBoard, (double)leaderBoard.getCount().intValue());
                }
            }
            if (todaySign.getSignDay() >= 2 && signRecordList.size() >= 2 && StringUtils.isNotEmpty((CharSequence)(lastAreaCode = (yesterdaySign = (SignRecord)signRecordList.get(1)).getAreaCode())) && !areaCode.equals(lastAreaCode)) {
                SignLeaderBoard.LeaderBoard leaderBoard = new SignLeaderBoard.LeaderBoard();
                leaderBoard.setUserId(todaySign.getUserId());
                KeyGenerator signRecordKey = RedisConfig.SIGN_RANKING_KEY.copy().appendKey((Object)lastAreaCode);
                Set leaderBoardSet = this.redisZSetAdapter.range(signRecordKey, 0L, 100L, true, SignLeaderBoard.LeaderBoard.class);
                Optional<SignLeaderBoard.LeaderBoard> boardOptional = leaderBoardSet.stream().filter(e -> e.getUserId().equals(leaderBoard.getUserId())).findFirst();
                boardOptional.ifPresent(e -> this.redisZSetAdapter.remove(signRecordKey, new Object[]{e}));
            }
        }
    }

    @Override
    public Message executeUserFillSign(Long userId, String areaCode) {
        Date date;
        Message message = Message.build();
        SignDTO signDTO = this.generateSign(userId);
        if (!signDTO.isYesterdaySignState()) {
            return message.setSuccess(false).setMessage("\u5f53\u524d\u7528\u6237\u5df2\u8865\u7b7e");
        }
        String requestId = String.valueOf(this.nextId());
        Long id = this.nextId();
        if (this.distributedLock.lock(userId + "" + id, requestId)) {
            Date yesterday = DateUtils.addField((Date)new Date(), (int)5, (int)-1);
            date = new Date();
            SignRecord beforeSignRecord = this.signRecordMapper.getBeforeYesterDaySignRecord(userId);
            int signDay = 1;
            if (beforeSignRecord != null) {
                signDay += beforeSignRecord.getSignDay().intValue();
            }
            SignRecord signRecord = new SignRecord(id, userId, yesterday, Integer.valueOf(signDay), Long.valueOf(0L), Boolean.valueOf(true), areaCode);
            this.signRecordMapper.insertSelective(signRecord);
            if (signDTO.isTodaySignState()) {
                this.signRecordMapper.updateTodaySign(userId, DateUtils.formatDate((Date)date), Integer.valueOf(signDay + 1));
            }
        } else {
            return message.setSuccess(false).setMessage("\u5f53\u524d\u7528\u6237\u5df2\u8865\u7b7e");
        }
        this.record2redis(userId, date);
        this.rankingSignRecord(userId);
        this.distributedLock.unlock(userId + "" + id, requestId);
        return message;
    }

    @Override
    public SignLeaderBoard getSignLeaderBoard(Long userId, String areaCode) {
        if (userId == null || StringUtils.isEmpty((CharSequence)areaCode)) {
            this.logger.warn("\u8bf7\u6c42\u7b7e\u5230\u6392\u884c\u699c\u53c2\u6570\u9519\u8bef,userId:[{}],areaCode:[{}]", (Object)userId, (Object)areaCode);
            return null;
        }
        LocationDetailDTO locationDetailDTO = this.locationFacadeService.getLocationDetailByCode(areaCode);
        if (null == locationDetailDTO || null == locationDetailDTO.getEnableSignBoard() || 0 == locationDetailDTO.getEnableSignBoard()) {
            return null;
        }
        KeyGenerator signRecordKey = RedisConfig.SIGN_RANKING_KEY.copy().appendKey((Object)areaCode);
        Set leaderBoardSet = this.redisZSetAdapter.range(signRecordKey, 0L, (long)(this.signProperties.getRankSize() - 1), true, SignLeaderBoard.LeaderBoard.class);
        SignLeaderBoard signLeaderBoard = new SignLeaderBoard();
        signLeaderBoard.setUserId(userId);
        int index = 1;
        for (SignLeaderBoard.LeaderBoard e : leaderBoardSet) {
            e.setRanking(Integer.valueOf(index));
            if (signLeaderBoard.getUserId().equals(e.getUserId())) {
                BeanUtils.copyProperties((Object)e, (Object)signLeaderBoard);
            }
            ++index;
        }
        signLeaderBoard.setLeaderBoardList(leaderBoardSet);
        if (null == signLeaderBoard.getRanking()) {
            UserInfoDTO user = this.userIntegrationService.getUserFromRedisDB(signLeaderBoard.getUserId());
            if (null != user) {
                signLeaderBoard.setHeadImg(user.getHeadImg());
                signLeaderBoard.setNickname(user.getNickname());
                SignRecord signRecord = this.signRecordMapper.getTodaySignRecord(userId);
                if (null != signRecord) {
                    if (areaCode.equals(signRecord.getAreaCode() == null ? "" : signRecord.getAreaCode())) {
                        signLeaderBoard.setCount(signRecord.getSignDay());
                    }
                } else {
                    SignRecord yesterdaySignRecord = this.signRecordMapper.getYesterdaySignRecord(userId);
                    if (null != yesterdaySignRecord && areaCode.equals(yesterdaySignRecord.getAreaCode() == null ? "" : yesterdaySignRecord.getAreaCode())) {
                        signLeaderBoard.setCount(yesterdaySignRecord.getSignDay());
                    }
                }
            } else {
                signLeaderBoard.setHeadImg(this.userIntegrationService.getDefaultHeadImgUrl());
                signLeaderBoard.setNickname("");
            }
        }
        signLeaderBoard.setLeaderBoardList(leaderBoardSet);
        return signLeaderBoard;
    }

    private SignConfig getSignConfig(int signDay) {
        List<SignConfig> signConfigList = this.signConfigService.allSignConfig();
        if (signDay < 7) {
            for (SignConfig travSignConfig : signConfigList) {
                if (travSignConfig.getDate() != signDay) continue;
                return travSignConfig;
            }
        }
        return signConfigList.stream().filter(signConfig -> signConfig.getDate() == 7).findFirst().get();
    }

    private SignDTO generateSign(Long userId) {
        SignDTO signDTO = new SignDTO();
        SignRecord yesterdaySignRecord = this.signRecordMapper.getYesterdaySignRecord(userId);
        signDTO.setYesterdaySignState(yesterdaySignRecord == null);
        SignRecord signRecord = this.signRecordMapper.getLastSignRecord(userId);
        if (signRecord == null) {
            signDTO.setGold(Integer.valueOf(this.getSignConfig(1).getReward().intValue()));
            signDTO.setCount(Long.valueOf(0L));
            signDTO.setYesterdaySignState(true);
        } else {
            Date today = new Date();
            if (org.apache.commons.lang3.time.DateUtils.isSameDay((Date)signRecord.getSignDate(), (Date)today)) {
                signDTO.setTodaySignState(true);
                signDTO.setGold(Integer.valueOf(this.getSignConfig(signRecord.getSignDay() + 1).getReward().intValue()));
                signDTO.setCount(Long.valueOf(signRecord.getSignDay().longValue()));
            } else if (yesterdaySignRecord == null) {
                signDTO.setGold(Integer.valueOf(this.getSignConfig(1).getReward().intValue()));
                signDTO.setCount(Long.valueOf(0L));
                signDTO.setYesterdaySignState(true);
            } else {
                signDTO.setGold(Integer.valueOf(this.getSignConfig(yesterdaySignRecord.getSignDay() + 1).getReward().intValue()));
                signDTO.setCount(Long.valueOf(yesterdaySignRecord.getSignDay().longValue()));
            }
        }
        return signDTO;
    }

    private List<CalendarSignDTO> getMonthSignRecord(Long userId, String signDate) {
        List<CalendarSignDTO> signRecords = this.generateMonthSign(signDate);
        List signRecordList = this.signRecordMapper.getMonthSignRecord(userId, signDate);
        signRecords.forEach(calendarSignDTO -> signRecordList.forEach(signRecord -> {
            String signRecordDate = DateUtils.formatAtWill((Date)signRecord.getSignDate(), (String)"yyyy-MM-dd");
            if (signRecordDate.equals(calendarSignDTO.getSignDate())) {
                calendarSignDTO.setSignFlag(Boolean.valueOf(true));
                calendarSignDTO.setFill(signRecord.getFillSign());
            }
        }));
        return signRecords;
    }

    private List<CalendarSignDTO> generateMonthSign(String signDate) {
        List<String> monthDates = this.getDayByMonth(signDate);
        ArrayList calendarSignDTOS = Lists.newArrayListWithCapacity((int)monthDates.size());
        for (String monthDate : monthDates) {
            CalendarSignDTO calendarSignDTO = new CalendarSignDTO();
            calendarSignDTO.setSignDate(monthDate);
            calendarSignDTOS.add(calendarSignDTO);
        }
        return calendarSignDTOS;
    }

    private List<String> getDayByMonth(String signDate) {
        int yearParam = Integer.parseInt(StringUtils.split((String)signDate, (String)"-")[0]);
        int monthParam = Integer.parseInt(StringUtils.split((String)signDate, (String)"-")[1]);
        ArrayList list = Lists.newArrayList();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(yearParam, monthParam - 1, 1);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.getActualMaximum(5);
        for (int i = 1; i <= day; ++i) {
            String monthDate = null;
            if (month < 10 && i < 10) {
                monthDate = String.valueOf(year) + "-0" + month + "-0" + i;
            }
            if (month < 10 && i >= 10) {
                monthDate = String.valueOf(year) + "-0" + month + "-" + i;
            }
            if (month >= 10 && i < 10) {
                monthDate = String.valueOf(year) + "-" + month + "-0" + i;
            }
            if (month >= 10 && i >= 10) {
                monthDate = String.valueOf(year) + "-" + month + "-" + i;
            }
            list.add(monthDate);
        }
        return list;
    }
}

