/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.common.config.HelpInfoProperties;
import com.bxm.localnews.activity.common.utils.UploadBase64Img;
import com.bxm.localnews.activity.config.BaConfig;
import com.bxm.localnews.activity.domain.HelpInfoMapper;
import com.bxm.localnews.activity.param.HelpInfoQueryParam;
import com.bxm.localnews.activity.service.HelpInfoFacadeService;
import com.bxm.localnews.activity.service.HelpInfoService;
import com.bxm.localnews.activity.vo.HelpBaseInfo;
import com.bxm.localnews.activity.vo.HelpCertInfo;
import com.bxm.localnews.activity.vo.HelpIndexPageInfo;
import com.bxm.localnews.activity.vo.HelpRankInfo;
import com.bxm.localnews.activity.vo.HelpWindowInfo;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.ForumPostIntegrationService;
import com.bxm.localnews.integration.PushMsgIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.vo.ForumBasicVo;
import com.bxm.localnews.vo.PostImgVo;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HelpInfoServiceImpl
implements HelpInfoService,
HelpInfoFacadeService {
    private static final Logger logger = LoggerFactory.getLogger(HelpInfoServiceImpl.class);
    @Resource
    private HelpInfoMapper helpInfoMapper;
    @Resource
    private HelpInfoProperties helpInfoProperties;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private ForumPostIntegrationService forumPostIntegrationService;
    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private ShortLinkService shortLinkService;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private UploadBase64Img uploadBase64Img;
    @Resource
    private BaConfig baConfig;
    @Resource
    private BaseUrlFacadeService baseUrlFacadeService;

    @Override
    public Boolean isActiveArea(String areaCode) {
        if (StringUtils.isEmpty((CharSequence)this.helpInfoProperties.getActiveArea())) {
            return false;
        }
        if ("0".equals(this.helpInfoProperties.getActiveArea())) {
            return true;
        }
        return this.helpInfoProperties.getActiveArea().contains(areaCode);
    }

    @Override
    public HelpIndexPageInfo getIndexPageInfo(Integer size, Long userId, Integer pageType) {
        HelpIndexPageInfo helpIndexPageInfo = new HelpIndexPageInfo();
        HelpRankInfo helpRankInfo = this.getUserRank(userId);
        helpIndexPageInfo.setUserHelpInfo(helpRankInfo);
        helpIndexPageInfo.setRoundList(this.getRoundList(pageType, size, userId, helpRankInfo));
        Integer helpedNum = this.getHelpedNum();
        helpIndexPageInfo.setHelpedNum(helpedNum);
        helpIndexPageInfo.setHelpRate(this.helpInfoProperties.getHelpRate());
        helpIndexPageInfo.setHelpTotalAmount(this.addComma(this.helpInfoProperties.getHelpRate().multiply(new BigDecimal(this.helpInfoProperties.getHelpTotalLimit())).intValue()));
        helpIndexPageInfo.setHelpedAmount(this.addComma(this.helpInfoProperties.getHelpRate().multiply(new BigDecimal(helpedNum)).intValue()));
        Integer helpPercent = helpedNum * 100 / this.helpInfoProperties.getHelpTotalLimit();
        if (helpPercent < 1) {
            helpPercent = 1;
        }
        helpIndexPageInfo.setHelpPercent(helpPercent.toString());
        if (this.helpInfoProperties.getHelpPoint() <= helpedNum) {
            helpIndexPageInfo.setHelpPoint(Integer.valueOf(this.helpInfoProperties.getHelpRate().multiply(new BigDecimal(this.helpInfoProperties.getHelpPoint())).intValue()));
        }
        helpIndexPageInfo.setHelpedUserImgList(this.getHelpedUserImgList(userId, helpRankInfo));
        HelpInfoQueryParam param = new HelpInfoQueryParam();
        param.setPageNum(Integer.valueOf(1));
        param.setPageSize(Integer.valueOf(3));
        param.setType(Byte.valueOf((byte)1));
        helpIndexPageInfo.setPersonalRankList(this.getRankingList(param).getList());
        param.setType(Byte.valueOf((byte)2));
        helpIndexPageInfo.setTeamRankList(this.getRankingList(param).getList());
        if (0 == this.helpInfoProperties.getState()) {
            helpIndexPageInfo.setActivityStatus(Integer.valueOf(1));
        } else if (this.isActivityValid()) {
            helpIndexPageInfo.setActivityStatus(Integer.valueOf(0));
        } else {
            helpIndexPageInfo.setActivityStatus(Integer.valueOf(2));
        }
        return helpIndexPageInfo;
    }

    @Override
    public PageWarper<HelpRankInfo> getRankingList(HelpInfoQueryParam param) {
        PageWarper resultPage = new PageWarper(this.helpInfoMapper.getRankingList(param));
        if (CollectionUtils.isNotEmpty((Collection)resultPage.getList())) {
            int index = (param.getPageNum() - 1) * param.getPageSize() + 1;
            for (HelpRankInfo helpRankInfo : resultPage.getList()) {
                helpRankInfo.setRank(Integer.valueOf(index));
                ++index;
                if (2 == helpRankInfo.getType()) {
                    helpRankInfo.setInviteUserId(this.helpInfoMapper.getTeamCreatorById(helpRankInfo.getHelperId()));
                    continue;
                }
                helpRankInfo.setInviteUserId(helpRankInfo.getHelperId());
            }
        }
        return resultPage;
    }

    @Override
    public HelpRankInfo getUserRank(Long userId) {
        Long creator;
        HelpRankInfo helpRankInfo = this.getUserRankInfo(userId);
        if (helpRankInfo != null && (null == helpRankInfo.getInviteNum() || 0 == helpRankInfo.getInviteNum())) {
            helpRankInfo.setRank(Integer.valueOf(999));
        }
        if (null != helpRankInfo && null != helpRankInfo.getType() && 2 == helpRankInfo.getType() && userId.equals(creator = this.helpInfoMapper.getTeamCreatorById(helpRankInfo.getHelperId()))) {
            helpRankInfo.setCreator(creator);
        }
        return helpRankInfo;
    }

    @Override
    @Transactional
    public Message help(String areaCode, String areaName, Long userId, Byte type, String teamName, Long inviteUserId) {
        if (1 != type && 2 != type && 3 != type) {
            return Message.build((boolean)false).setMessage("\u53c2\u6570\u9519\u8bef");
        }
        if (!this.isActivityValid()) {
            return Message.build((boolean)false).setMessage("\u6d3b\u52a8\u7ed3\u675f\uff0c\u70b9\u51fb\u4e86\u89e3\u66f4\u591a");
        }
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
        if (null == userInfoDTO || StringUtils.isEmpty((CharSequence)userInfoDTO.getNickname())) {
            return Message.build((boolean)false).setMessage("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Long inviteHelperId = null;
        Byte inviteHelperType = 0;
        if (3 == type) {
            HelpBaseInfo inviteUserHelpInfo = this.getUserHelpBaseInfo(inviteUserId);
            if (null == inviteUserHelpInfo || null == inviteUserHelpInfo.getHelperId()) {
                return Message.build((boolean)false).setMessage("\u9080\u8bf7\u7528\u6237\u65e0\u52a9\u529b\u4fe1\u606f");
            }
            inviteHelperId = inviteUserHelpInfo.getHelperId();
            inviteHelperType = inviteUserHelpInfo.getType();
        }
        if (this.helpInfoMapper.countUserHelpInfo(userId) > 0) {
            return Message.build((boolean)false).setMessage("\u60a8\u5df2\u52a9\u529b\u8fc7\u8be5\u6d3b\u52a8");
        }
        if (2 == type && this.helpInfoMapper.countHelpTeamByName(teamName) > 0) {
            return Message.build((boolean)false).setMessage("\u5df2\u5b58\u5728\u8be5\u56e2\u961f\u540d");
        }
        if (this.distributedLock.lock(userId.toString(), this.sequenceCreater.nextStringId(), 3L, TimeUnit.SECONDS) && (2 != type || 2 == type && this.distributedLock.lock(teamName, this.sequenceCreater.nextStringId(), 3L, TimeUnit.SECONDS))) {
            Long helpedNum = this.redisStringAdapter.increment(RedisConfig.BLUE_SKY_HELPED_NUM.copy());
            if (helpedNum > (long)this.helpInfoProperties.getHelpTotalLimit().intValue()) {
                this.redisStringAdapter.decrement(RedisConfig.BLUE_SKY_HELPED_NUM.copy());
                return Message.build((boolean)false).setMessage("\u5e7f\u5fb7\u84dd\u5929\u6551\u63f4\u961f\u52a9\u529b\u76ee\u6807\u8fbe\u6210\uff0c\u611f\u8c22\u53c2\u4e0e");
            }
            if (helpedNum.equals(this.helpInfoProperties.getHelpTotalLimit().longValue())) {
                this.redisStringAdapter.set(RedisConfig.BLUE_SKY_HELP_COMPLETE.copy(), (Object)true);
            } else {
                this.redisStringAdapter.remove(RedisConfig.BLUE_SKY_HELP_COMPLETE.copy());
            }
        } else {
            return Message.build((boolean)false).setMessage("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.doHelp(areaCode, areaName, type, teamName, userInfoDTO, inviteUserId, inviteHelperId, inviteHelperType);
        return Message.build((boolean)true);
    }

    @Override
    public Message updateTeamImg(Long userId, String teamImg) {
        int update = this.helpInfoMapper.updateTeamImgByCreator(userId, teamImg);
        HelpBaseInfo helpBaseInfo = this.getUserHelpBaseInfo(userId);
        if (null != helpBaseInfo && 2 == helpBaseInfo.getType()) {
            this.helpInfoMapper.updateHelpTeamImg(helpBaseInfo.getHelperId(), teamImg);
        }
        if (update > 0) {
            return Message.build((boolean)true);
        }
        return Message.build((boolean)false).setMessage("\u8be5\u7528\u6237\u975e\u56e2\u961f\u53d1\u8d77\u4eba");
    }

    @Override
    public HelpCertInfo getUserCert(Long userId) {
        HelpCertInfo helpCertInfo = new HelpCertInfo();
        Date createTime = this.helpInfoMapper.getUserHelpTime(userId);
        if (null == createTime) {
            return null;
        }
        Integer countUserRank = this.helpInfoMapper.countUserRank(createTime, userId);
        if (null == countUserRank) {
            return null;
        }
        helpCertInfo.setRank(Integer.valueOf(countUserRank + 1));
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
        if (userInfoDTO != null) {
            helpCertInfo.setHelperId(userId);
            helpCertInfo.setHelperName(userInfoDTO.getNickname());
            helpCertInfo.setHelperImg(userInfoDTO.getHeadImg());
        }
        helpCertInfo.setRankRate(99 - helpCertInfo.getRank() * 100 / 450000 + "");
        helpCertInfo.setJumpAddress(this.shortLinkService.generateShortUrl(StringUtils.join((Object[])new Serializable[]{this.baseUrlFacadeService.getContentViewSceneBaseUrl(), this.baConfig.getJumpAddress(), "?shareUserId=", userId, "&type=", helpCertInfo.getType(), "&source=poster"})));
        helpCertInfo.setCreatePost(Boolean.valueOf(this.redisStringAdapter.hasKey(RedisConfig.BLUE_SKY_CREATE_POST.copy().appendKey((Object)userId)) == false));
        helpCertInfo.setCertDate(DateUtils.formatAtWill((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
        return helpCertInfo;
    }

    @Override
    public Message shareCreatePost(Long userId, String areaCode, String base64Str) {
        Date createTime = this.helpInfoMapper.getUserHelpTime(userId);
        if (null == createTime) {
            return Message.build((boolean)false).setMessage("\u7528\u6237\u672a\u52a9\u529b");
        }
        KeyGenerator key = RedisConfig.BLUE_SKY_CREATE_POST.copy().appendKey((Object)userId);
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            return Message.build((boolean)false).setMessage("\u5df2\u521b\u5efa\u8fc7\u5e16\u5b50");
        }
        this.redisStringAdapter.set(key, (Object)true);
        Integer countUserRank = this.helpInfoMapper.countUserRank(createTime, userId);
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
        if (countUserRank != null && userInfoDTO != null) {
            String url;
            ForumBasicVo forumBasicVo = new ForumBasicVo();
            forumBasicVo.setTextField("\u6211\u662f" + userInfoDTO.getNickname() + "\uff0c\u6211\u662f\u7b2c" + (countUserRank + 1) + "\u4f4d\u4e3a\u5e7f\u5fb7\u84dd\u5929\u6551\u63f4\u961f\u52a9\u529b\u7684\u5e7f\u5fb7\u4eba\uff01\u8ba9\u6211\u4eec\u4e00\u8d77\u81f4\u656c\u751f\u547d\u7684\u6551\u63f4\u8005\uff01");
            forumBasicVo.setForumId(this.helpInfoProperties.getForumId());
            forumBasicVo.setAreaCode(areaCode);
            forumBasicVo.setUserId(userId);
            String postAddress = StringUtils.join((Object[])new Serializable[]{this.baseUrlFacadeService.getContentViewSceneBaseUrl(), this.baConfig.getPostAddress(), "?userId=", userId, "&areaName=\u5e7f\u5fb7&areaCode=341822000000&hasShareBtn=1&shareDialogWay=1&source=poster"});
            try {
                postAddress = URLEncoder.encode(postAddress, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("url encode \u5931\u8d25\uff0curl\uff1a" + postAddress);
            }
            forumBasicVo.setExtraContent("<a href=\"wst://web/webDetail?url=" + postAddress + "\">\u70b9\u51fb\u9a6c\u4e0a\u53c2\u4e0e\u52a9\u529b</a>");
            if (StringUtils.isNotBlank((CharSequence)base64Str) && StringUtils.isNotBlank((CharSequence)(url = this.uploadBase64Img.uploadBase64Img(base64Str)))) {
                ArrayList<PostImgVo> imgList = new ArrayList<PostImgVo>();
                PostImgVo postImgVo = new PostImgVo();
                postImgVo.setImgUrl(url);
                postImgVo.setType("IMG");
                imgList.add(postImgVo);
                forumBasicVo.setPostImgList(imgList);
            }
            this.forumPostIntegrationService.createPost(forumBasicVo);
        }
        return Message.build((boolean)true);
    }

    @Override
    public HelpBaseInfo getUserHelpBaseInfo(Long userId) {
        if (null == userId) {
            return null;
        }
        HelpBaseInfo helpBaseInfo = this.helpInfoMapper.getPersonalInfoByUserId(userId);
        if (null == helpBaseInfo) {
            helpBaseInfo = this.helpInfoMapper.getTeamInfoByUserId(userId);
        }
        return helpBaseInfo;
    }

    public String getHomeWindowUrl(Long userId, String areaCode, String areaName) {
        String homeWindowUrl = StringUtils.join((Object[])new String[]{this.baseUrlFacadeService.getContentViewSceneBaseUrl(), this.baConfig.getHomeWindowUrl()});
        if (StringUtils.isBlank((CharSequence)homeWindowUrl)) {
            return null;
        }
        KeyGenerator key = RedisConfig.BLUE_SKY_HOME_WINDOW.copy().appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)userId);
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            return null;
        }
        HelpWindowInfo helpWindowInfo = this.getBaseHelpWindowInfo(areaCode, userId);
        if (null == helpWindowInfo) {
            return null;
        }
        this.redisStringAdapter.set(key, (Object)true, (long)DateUtils.getCurSeconds());
        return homeWindowUrl + "?source=dialog&userId=" + userId + "&areaCode=" + areaCode + "&areaName=" + areaName + "&inviteUserId=" + helpWindowInfo.getInviteUserId() + "&userName=" + helpWindowInfo.getUserName() + "&userImg=" + helpWindowInfo.getUserImg();
    }

    @Override
    public HelpWindowInfo getHelpWindowInfo(String areaCode, Long userId) {
        KeyGenerator key = RedisConfig.BLUE_SKY_H5_HOME_WINDOW.copy().appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)userId);
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            return null;
        }
        HelpWindowInfo helpWindowInfo = this.getBaseHelpWindowInfo(areaCode, userId);
        if (null == helpWindowInfo) {
            return null;
        }
        this.redisStringAdapter.set(key, (Object)true, (long)DateUtils.getCurSeconds());
        return helpWindowInfo;
    }

    @Override
    public Message createHelpUserInvite(Long userId, Long inviteUserId) {
        if (userId.equals(inviteUserId)) {
            return Message.build((boolean)false).setMessage("\u9080\u8bf7\u4eba\u4e0e\u88ab\u9080\u8bf7\u4ebaid\u76f8\u540c");
        }
        int insertNum = this.helpInfoMapper.createHelpUserInvite(userId, inviteUserId);
        if (insertNum > 0) {
            return Message.build((boolean)true);
        }
        return Message.build((boolean)false).setMessage("\u521b\u5efa\u5931\u8d25");
    }

    private List<HelpBaseInfo> getRoundList(Integer pageType, Integer size, Long userId, HelpRankInfo helpRankInfo) {
        if (2 == pageType && null != helpRankInfo) {
            if (1 == helpRankInfo.getType()) {
                return this.helpInfoMapper.getRoundList(size, userId);
            }
            List userIdList = this.helpInfoMapper.getRoundUserIdList(size, helpRankInfo.getHelperId());
            ArrayList<HelpBaseInfo> roundList = new ArrayList<HelpBaseInfo>();
            if (CollectionUtils.isNotEmpty((Collection)userIdList)) {
                for (Long id : userIdList) {
                    UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(id);
                    if (null == userInfoDTO) continue;
                    HelpBaseInfo helpBaseInfo = new HelpBaseInfo();
                    helpBaseInfo.setHelperId(id);
                    helpBaseInfo.setHelperName(userInfoDTO.getNickname());
                    helpBaseInfo.setHelperImg(userInfoDTO.getHeadImg());
                    roundList.add(helpBaseInfo);
                }
            }
            return roundList;
        }
        return this.helpInfoMapper.getRoundList(size, null);
    }

    private List<String> getHelpedUserImgList(Long userId, HelpRankInfo helpRankInfo) {
        List helpedUserIds;
        ArrayList<String> userImgList = new ArrayList<String>();
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
        if (null != helpRankInfo && null != userInfoDTO) {
            userImgList.add(userInfoDTO.getHeadImg());
            helpedUserIds = this.helpInfoMapper.getHelpedUserIds(userId, Integer.valueOf(4));
        } else {
            helpedUserIds = this.helpInfoMapper.getHelpedUserIds(userId, Integer.valueOf(5));
        }
        if (null != helpedUserIds) {
            for (Long id : helpedUserIds) {
                UserInfoDTO userInfo = this.userIntegrationService.getUserFromRedisDB(id);
                if (null == userInfo) continue;
                userImgList.add(userInfo.getHeadImg());
            }
        }
        return userImgList;
    }

    private HelpRankInfo getUserRankInfo(Long userId) {
        HelpBaseInfo helpBaseInfo = this.getUserHelpBaseInfo(userId);
        if (null == helpBaseInfo) {
            return null;
        }
        return this.helpInfoMapper.getRankInfoByHelperIdAndType(helpBaseInfo.getHelperId(), helpBaseInfo.getType());
    }

    private void doHelp(String areaCode, String areaName, Byte type, String teamName, UserInfoDTO userInfoDTO, Long inviteUserId, Long inviteHelperId, Byte inviteHelperType) {
        HelpBaseInfo helpBaseInfo = new HelpBaseInfo();
        helpBaseInfo.setId(this.sequenceCreater.nextLongId());
        helpBaseInfo.setType(type);
        if (2 == type) {
            helpBaseInfo.setHelperName(teamName);
            helpBaseInfo.setCreator(userInfoDTO.getId());
            helpBaseInfo.setCreatorName(userInfoDTO.getNickname());
            helpBaseInfo.setCreatorImg(userInfoDTO.getHeadImg());
            helpBaseInfo.setHelperId(this.sequenceCreater.nextLongId());
            helpBaseInfo.setHelperImg(this.helpInfoProperties.getDefaultTeamImg());
            this.helpInfoMapper.insertTeamInfo(helpBaseInfo);
            this.helpInfoMapper.insertTeamUserRelation(helpBaseInfo.getHelperId(), helpBaseInfo.getCreator());
            this.helpInfoMapper.insertHelpInfo(helpBaseInfo);
        } else if (1 == type) {
            helpBaseInfo.setHelperId(userInfoDTO.getId());
            helpBaseInfo.setHelperName(userInfoDTO.getNickname());
            helpBaseInfo.setHelperImg(userInfoDTO.getHeadImg());
            this.helpInfoMapper.insertHelpInfo(helpBaseInfo);
        } else if (3 == type) {
            if (1 == inviteHelperType) {
                helpBaseInfo.setHelperId(userInfoDTO.getId());
                helpBaseInfo.setHelperName(userInfoDTO.getNickname());
                helpBaseInfo.setHelperImg(userInfoDTO.getHeadImg());
                helpBaseInfo.setType(inviteHelperType);
                helpBaseInfo.setInviteUserId(inviteUserId);
                this.helpInfoMapper.insertHelpInfo(helpBaseInfo);
            } else if (2 == inviteHelperType) {
                this.helpInfoMapper.insertTeamUserRelation(inviteHelperId, userInfoDTO.getId());
            }
            if (null != inviteHelperId) {
                this.helpInfoMapper.increaseInviteNum(inviteHelperId, inviteHelperType);
            }
            this.sendMessage(areaCode, areaName, userInfoDTO, inviteUserId);
        }
    }

    private void sendMessage(String areaCode, String areaName, UserInfoDTO userInfoDTO, Long sendUserId) {
        try {
            String title = userInfoDTO.getNickname() + "\u7528\u6237\u5df2\u7ecf\u5e2e\u4f60\u52a9\u529b\u6210\u529f\uff0c\u5949\u732e\u4e861\u4efd\u7231\u5fc3\uff0c\u5feb\u6765\u770b\u770b\u5427";
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
            info.addExtend("url", (Object)StringUtils.join((Object[])new Serializable[]{this.baseUrlFacadeService.getContentViewSceneBaseUrl(), this.baConfig.getSuccessAddress(), "?userId=", sendUserId, "&areaCode=", areaCode, "&areaName=", areaName}));
            PushMessage message = PushMessage.build();
            message.setTitle("\u901a\u77e5\u6d88\u606f");
            message.setContent(title);
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)sendUserId));
            message.setPayloadInfo(info);
            this.pushMsgIntegrationService.pushMsg(message);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private HelpWindowInfo getBaseHelpWindowInfo(String areaCode, Long userId) {
        HelpWindowInfo helpWindowInfo = new HelpWindowInfo();
        if (0 == this.helpInfoProperties.getState() || !this.isActiveArea(areaCode).booleanValue() || !this.isActivityValid()) {
            return null;
        }
        Integer helpedNum = this.getHelpedNum();
        if (helpedNum >= this.helpInfoProperties.getHelpTotalLimit()) {
            return null;
        }
        UserInfoDTO user = this.userIntegrationService.getUserFromRedisDB(userId);
        if (null == user) {
            return null;
        }
        HelpBaseInfo userHelpInfo = this.getUserHelpBaseInfo(userId);
        if (null != userHelpInfo) {
            return null;
        }
        Long inviteUserId = this.helpInfoMapper.getInviteUserIdByUserId(userId);
        HelpBaseInfo inviteHelpInfo = this.getUserHelpBaseInfo(inviteUserId);
        if (null == inviteHelpInfo) {
            return null;
        }
        helpWindowInfo.setInviteUserId(inviteUserId);
        helpWindowInfo.setUserName(inviteHelpInfo.getHelperName());
        helpWindowInfo.setUserImg(inviteHelpInfo.getHelperImg());
        return helpWindowInfo;
    }

    private boolean isActivityValid() {
        Date startTime = DateUtils.parse((String)this.helpInfoProperties.getStartTime());
        Date endTime = DateUtils.parse((String)this.helpInfoProperties.getEndTime());
        Date now = new Date();
        return now.after(startTime) && now.before(endTime);
    }

    private Integer getHelpedNum() {
        Integer helpedNum = (Integer)this.redisStringAdapter.get(RedisConfig.BLUE_SKY_HELPED_NUM.copy(), Integer.class);
        if (null == helpedNum) {
            helpedNum = this.helpInfoMapper.getHelpedNum();
            if (null == helpedNum) {
                helpedNum = 0;
            }
            this.redisStringAdapter.set(RedisConfig.BLUE_SKY_HELPED_NUM.copy(), (Object)helpedNum);
        }
        return helpedNum;
    }

    private String addComma(Integer i) {
        DecimalFormat df = new DecimalFormat("#,###");
        return df.format(i);
    }
}

