/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.common.constant.CashEnum;
import com.bxm.localnews.activity.domain.LotteryDrawMapper;
import com.bxm.localnews.activity.param.CashDetailParam;
import com.bxm.localnews.activity.service.LotteryDrawService;
import com.bxm.localnews.activity.vo.WechatUserInfoVo;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.InviteRecordIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.AccountCashParam;
import com.bxm.localnews.thirdparty.service.PushMessageService;
import com.bxm.localnews.vo.InviteRecord;
import com.bxm.newidea.component.vo.PageWarper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LotteryDrawServiceImpl
implements LotteryDrawService {
    private LotteryDrawMapper lotteryDrawMapper;
    private UserIntegrationService userIntegrationService;
    private UserAccountIntegrationService userAccountIntegrationService;
    private InviteRecordIntegrationService inviteRecordIntegrationService;
    private PushMessageService pushMessageService;
    private BizLogService bizLogService;

    @Autowired
    public LotteryDrawServiceImpl(LotteryDrawMapper lotteryDrawMapper, UserIntegrationService userIntegrationService, UserAccountIntegrationService userAccountIntegrationService, InviteRecordIntegrationService inviteRecordIntegrationService, PushMessageService pushMessageService, BizLogService bizLogService) {
        this.lotteryDrawMapper = lotteryDrawMapper;
        this.userIntegrationService = userIntegrationService;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.inviteRecordIntegrationService = inviteRecordIntegrationService;
        this.pushMessageService = pushMessageService;
        this.bizLogService = bizLogService;
    }

    @Override
    public WechatUserInfoVo getUserInfo(Long userId, String city, String district) {
        WechatUserInfoVo user = new WechatUserInfoVo();
        if (StringUtils.isBlank((CharSequence)city) && StringUtils.isBlank((CharSequence)district)) {
            user.setActivityArea(Boolean.valueOf(true));
        } else {
            String areaCode = null;
            if (StringUtils.isNotBlank((CharSequence)district)) {
                areaCode = this.lotteryDrawMapper.getCodeByName(district);
                user.setShareArea(district.substring(0, district.length() - 1));
            }
            if (StringUtils.isBlank(areaCode) && StringUtils.isNotBlank((CharSequence)city)) {
                areaCode = this.lotteryDrawMapper.getCodeByName(city);
                user.setShareArea(city.substring(0, city.length() - 1));
            }
            user.setAreaCode(areaCode);
            if (StringUtils.isNotBlank((CharSequence)user.getAreaCode())) {
                user.setActivityArea(Boolean.valueOf(true));
                if (userId != null) {
                    this.bizLogService.conformDrawAreaUser(userId, user.getAreaCode());
                }
            } else {
                user.setActivityArea(Boolean.valueOf(false));
            }
            this.getWechatUserInfo(userId, user);
        }
        return user;
    }

    @Override
    public List<BigDecimal> getPrizeList() {
        ArrayList<BigDecimal> prizeList = new ArrayList<BigDecimal>();
        List prizeMapList = this.lotteryDrawMapper.getPrizeList();
        if (CollectionUtils.isNotEmpty((Collection)prizeMapList)) {
            Map prizeMap = (Map)prizeMapList.get(0);
            for (int i = 1; i < 9; ++i) {
                BigDecimal prize = new BigDecimal(prizeMap.get("prize_" + i).toString());
                prizeList.add(prize);
            }
        }
        return prizeList;
    }

    @Override
    public List<WechatUserInfoVo> getWinUserList() {
        return this.lotteryDrawMapper.getWinUserList();
    }

    @Override
    public String lotteryDraw(Long userId, Integer platform, String areaCode) {
        List prizeMapList = this.lotteryDrawMapper.getPrizeList();
        if (CollectionUtils.isEmpty((Collection)prizeMapList) || this.lotteryDrawMapper.updateDrawTimes(userId) <= 0) {
            return "0";
        }
        Boolean isTempUser = this.userIntegrationService.isTempUser(userId);
        Integer hasDrawTimes = this.lotteryDrawMapper.getHasDrawTimes(userId);
        String winPrize = this.getWinPrize(prizeMapList, hasDrawTimes, isTempUser);
        if (!"0".equals(winPrize)) {
            BigDecimal winCash = new BigDecimal(winPrize);
            winPrize = winCash.stripTrailingZeros().toPlainString();
            AccountCashParam param = new AccountCashParam();
            param.setAddTotal(Boolean.valueOf(true));
            param.setCashType(CashEnum.TEMP_CASH.name());
            param.setCash(winCash);
            this.addInviteUserCash(userId, winCash, param);
            if (Boolean.FALSE.equals(isTempUser)) {
                param.setCashType(CashEnum.DRAWABLEL_CASH.name());
            }
            param.setInviteType(null);
            param.setInvitedUserName(null);
            param.setCashFlowType("SELF_BOUNTY");
            param.setUserId(userId);
            this.userAccountIntegrationService.addCash(param);
            this.lotteryDrawMapper.disableUserRedPacket(userId);
            this.bizLogService.lotteryDraw(userId, hasDrawTimes, winCash, platform, areaCode);
        }
        return winPrize;
    }

    @Override
    public Boolean share(Long userId) {
        if (null == userId) {
            return false;
        }
        List prizeMapList = this.lotteryDrawMapper.getPrizeList();
        if (CollectionUtils.isNotEmpty((Collection)prizeMapList)) {
            Integer totalTimes = Integer.valueOf(((Map)prizeMapList.get(0)).get("total_times").toString());
            return this.lotteryDrawMapper.addRemainTimes(userId, totalTimes) > 0;
        }
        return false;
    }

    @Override
    public PageWarper<WechatUserInfoVo> getDetailPage(CashDetailParam param) {
        List resultList = this.lotteryDrawMapper.getDetailList(param);
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            UserInfoDTO user = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
            for (WechatUserInfoVo userInfo : resultList) {
                Long invitedUserId;
                UserInfoDTO invitedUser;
                if (1 == userInfo.getType()) {
                    if (null == user) continue;
                    userInfo.setNickname(user.getNickname());
                    userInfo.setHeadImg(user.getHeadImg());
                    continue;
                }
                InviteRecord inviteRecord = this.inviteRecordIntegrationService.getInviteRecordById(param.getUserId(), userInfo.getRelationId());
                if (null == inviteRecord || null == (invitedUser = this.userIntegrationService.getUserFromRedisDB(invitedUserId = inviteRecord.getInvitedUserId()))) continue;
                userInfo.setNickname(invitedUser.getNickname());
                userInfo.setHeadImg(invitedUser.getHeadImg());
            }
        }
        return new PageWarper(resultList);
    }

    @Override
    public Boolean isActiveArea(String city, String district) {
        if (StringUtils.isBlank((CharSequence)city) && StringUtils.isBlank((CharSequence)district)) {
            return true;
        }
        String areaCode = this.lotteryDrawMapper.getCodeByName(district);
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            areaCode = this.lotteryDrawMapper.getCodeByName(city);
        }
        return StringUtils.isNotBlank((CharSequence)areaCode);
    }

    private void getWechatUserInfo(Long userId, WechatUserInfoVo user) {
        if (userId != null) {
            UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
            if (userInfoDTO != null) {
                user.setHeadImg(userInfoDTO.getHeadImg());
                user.setNickname(userInfoDTO.getNickname());
            }
            user.setTempUser(this.userIntegrationService.isTempUser(userId));
            user.setWalletCash(this.lotteryDrawMapper.getWalletCash(userId));
            Integer remainTimes = this.lotteryDrawMapper.getRemainTimes(userId);
            user.setRemainTimes(remainTimes);
            List prizeMapList = this.lotteryDrawMapper.getPrizeList();
            if (CollectionUtils.isNotEmpty((Collection)prizeMapList)) {
                Integer totalTimes = Integer.valueOf(((Map)prizeMapList.get(0)).get("total_times").toString());
                Integer hasDrawTimes = this.lotteryDrawMapper.getHasDrawTimes(userId);
                user.setHasDrawTimes(hasDrawTimes);
                if (remainTimes != 0 || hasDrawTimes >= totalTimes) {
                    user.setCanAddTimes(Boolean.valueOf(false));
                } else {
                    user.setCanAddTimes(Boolean.valueOf(true));
                }
            }
        }
    }

    private String getWinPrize(List<Map<String, Object>> prizeMapList, Integer hasDrawTimes, Boolean isTempUser) {
        String winPrize = "0";
        if (Boolean.TRUE.equals(isTempUser)) {
            Object prize = prizeMapList.get(0).get("win_prize_" + hasDrawTimes);
            if (null != prize) {
                winPrize = prize.toString();
            }
        } else {
            Map<String, Object> prizeMap = prizeMapList.get(0);
            BigDecimal minPrize = new BigDecimal(prizeMap.get("prize_1").toString());
            for (int i = 2; i < 9; ++i) {
                BigDecimal prize = new BigDecimal(prizeMap.get("prize_" + i).toString());
                if (minPrize.compareTo(prize) <= 0) continue;
                minPrize = prize;
            }
            winPrize = minPrize.stripTrailingZeros().toPlainString();
        }
        return winPrize;
    }

    private void addInviteUserCash(Long userId, BigDecimal winCash, AccountCashParam param) {
        Long inviteUserId = this.lotteryDrawMapper.getInviteUserByUserId(userId);
        if (inviteUserId != null) {
            Long id = this.inviteRecordIntegrationService.updateInviteCash(inviteUserId, userId, winCash);
            param.setRelationId(id);
            param.setUserId(inviteUserId);
            param.setCashFlowType("APPLET_BOUNTY");
            InviteRecord inviteRecord = this.inviteRecordIntegrationService.getInviteRecordByInvitedUser(inviteUserId, userId);
            if (null != inviteRecord) {
                param.setInviteType(inviteRecord.getType());
                param.setInvitedUserName(inviteRecord.getInvitedUserName());
                if ("LOGIN_APP".equals(inviteRecord.getInviteState())) {
                    param.setCashType(CashEnum.STABILIZE_CASH.name());
                } else if ("SUCCESS_WITHDRAW".equals(inviteRecord.getInviteState())) {
                    param.setCashType(CashEnum.DRAWABLEL_CASH.name());
                }
                this.userAccountIntegrationService.addCash(param);
                this.pushMessageService.pushMessage(winCash, inviteUserId);
            }
        }
    }
}

