/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.localnews.activity.common.constant.MerchantSortTypeEnum;
import com.bxm.localnews.activity.domain.MerchantMapper;
import com.bxm.localnews.activity.dto.MerchantDetailDTO;
import com.bxm.localnews.activity.dto.MerchantListDTO;
import com.bxm.localnews.activity.param.MerchantDetailBasicParam;
import com.bxm.localnews.activity.param.MerchantDetailParam;
import com.bxm.localnews.activity.param.MerchantListParam;
import com.bxm.localnews.activity.param.MerchantParam;
import com.bxm.localnews.activity.service.MerchantService;
import com.bxm.localnews.activity.vo.MerchantVO;
import com.bxm.localnews.activity.vo.UserForMerchantInfo;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="merchantService")
public class MerchantServiceImpl
implements MerchantService {
    private static final Logger log = LogManager.getLogger(MerchantServiceImpl.class);
    @Resource
    private MerchantMapper merchantMapper;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private GeoService geoService;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    LocationFacadeService locationFacadeService;

    @Override
    public int saveMerchant(MerchantParam merchantParam) {
        MerchantVO merchantVO = new MerchantVO();
        BeanUtils.copyProperties((Object)merchantParam, (Object)merchantVO);
        merchantVO.setStatus(Integer.valueOf(0));
        merchantVO.setDeleteFlag(Integer.valueOf(0));
        if (merchantVO.getUserId() == null) {
            merchantVO.setUserId(Long.valueOf(0L));
        }
        return this.merchantMapper.saveMerchant(merchantVO);
    }

    @Override
    public List<MerchantListDTO> getMerchantList(MerchantListParam param) {
        log.info("MerchantListParam : {}", (Object)param);
        List<MerchantListDTO> listInfo = this.getInfoList(param);
        return this.sorted(listInfo, param);
    }

    private List<MerchantListDTO> sorted(List<MerchantListDTO> listInfo, MerchantListParam param) {
        List<MerchantListDTO> listForSort = listInfo.stream().filter(p -> p.getSort() != null && DateUtils.before((Date)p.getSortStartTime()) && DateUtils.after((Date)p.getSortEndTime())).collect(Collectors.toList());
        List listOther = listInfo.stream().filter(p -> p.getSort() == null || DateUtils.before((Date)p.getSortEndTime()) || DateUtils.after((Date)p.getSortStartTime())).collect(Collectors.toList());
        Collections.sort(listForSort, new Comparator<MerchantListDTO>(){

            @Override
            public int compare(MerchantListDTO o1, MerchantListDTO o2) {
                if (o1.getSort().equals(o2.getSort()) && o1.getDistanceNum() != null && o2.getDistanceNum() != null) {
                    if (o1.getDistanceNum() < o2.getDistanceNum()) {
                        return -1;
                    }
                    return 1;
                }
                if (o1.getSort() < o2.getSort()) {
                    return -1;
                }
                return 1;
            }
        });
        if (!param.getSortType().equals(MerchantSortTypeEnum.RECOMMEND_SORT.getCode()) && param.getSortType().equals(MerchantSortTypeEnum.DISTANCE_SORT.getCode())) {
            Collections.sort(listOther, new Comparator<MerchantListDTO>(){

                @Override
                public int compare(MerchantListDTO o1, MerchantListDTO o2) {
                    if (o1.getDistanceNum() != null && o2.getDistanceNum() != null && !o1.getDistanceNum().equals(o2.getDistanceNum())) {
                        if (o1.getDistanceNum() < o2.getDistanceNum()) {
                            return -1;
                        }
                        return 1;
                    }
                    if (o1.getDiscount() != null && o2.getDiscount() != null && o1.getDiscount().compareTo(o2.getDiscount()) > 0) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        listForSort.addAll(listOther);
        return listForSort;
    }

    private List<MerchantListDTO> getInfoList(MerchantListParam param) {
        List<Object> list = new ArrayList();
        String listInfoStr = this.redisStringAdapter.getString(this.getListKey(param));
        if (StringUtils.isNotBlank((CharSequence)listInfoStr)) {
            list = JSONArray.parseArray((String)listInfoStr, MerchantListDTO.class);
        } else {
            list = this.getFromDb(param);
            if (list.size() > 0) {
                this.redisStringAdapter.set(this.getListKey(param), (Object)JSONArray.toJSONString(list));
            }
        }
        this.distanceCalculation(param, list);
        return list;
    }

    private void distanceCalculation(MerchantListParam param, List<MerchantListDTO> list) {
        if (param.getLatitude() != null && param.getLongitude() != null) {
            Coordinate userLngAndLat = new Coordinate();
            userLngAndLat.setLongitude(param.getLongitude());
            userLngAndLat.setLatitude(param.getLatitude());
            for (MerchantListDTO merchantListDTO : list) {
                if (merchantListDTO.getGeoLat() == null || merchantListDTO.getGeoLng() == null) continue;
                Long distance = this.fillInstance(userLngAndLat, merchantListDTO.getGeoLat(), merchantListDTO.getGeoLng());
                merchantListDTO.setDistance((double)Math.round((double)distance.longValue() / 100.0) / 10.0 < 1.0 ? "<1km" : String.valueOf((double)Math.round((double)distance.longValue() / 100.0) / 10.0) + "km");
                merchantListDTO.setDistanceNum(distance);
            }
        }
    }

    private List<MerchantListDTO> getFromDb(MerchantListParam param) {
        LocationDetailDTO locationDetailDTO = null;
        if (StringUtils.isNotBlank((CharSequence)param.getAreaCode())) {
            BasicParam basicParam = new BasicParam();
            BeanUtils.copyProperties((Object)param, (Object)basicParam);
            locationDetailDTO = this.locationFacadeService.getInternalLocationByGeocode(param.getAreaCode(), basicParam);
        }
        List list = this.merchantMapper.selectForList(Objects.nonNull(locationDetailDTO) ? locationDetailDTO.getCode() : null);
        return list.stream().map(this::convert).collect(Collectors.toList());
    }

    private MerchantListDTO convert(MerchantVO merchantVO) {
        MerchantListDTO merchantListDTO = MerchantListDTO.builder().merchantId(Integer.valueOf(merchantVO.getId().intValue())).merchantName(merchantVO.getName()).facadeUrl(StringUtils.isNotBlank((CharSequence)merchantVO.getFacadeUrl()) ? Arrays.asList(merchantVO.getFacadeUrl().split(",")) : new ArrayList()).merchantTypeDesc(StringUtils.isNotBlank((CharSequence)merchantVO.getType()) ? merchantVO.getType() : "").build();
        BeanUtils.copyProperties((Object)merchantVO, (Object)merchantListDTO);
        return merchantListDTO;
    }

    private KeyGenerator getListKey(MerchantListParam param) {
        return RedisConfig.MERCHANT_LIST.copy().appendKey((Object)(StringUtils.isNotBlank((CharSequence)param.getAreaCode()) ? param.getAreaCode() : "all"));
    }

    @Override
    public MerchantDetailDTO getMerchantDetail(MerchantDetailParam param) {
        MerchantVO merchantVO = this.merchantMapper.selectByPrimaryKey(param.getMerchantId());
        MerchantDetailDTO merchantDetailDTO = this.convertToDetail(merchantVO);
        this.distanceCalculationDetail(param, merchantDetailDTO);
        return merchantDetailDTO;
    }

    private MerchantDetailDTO convertToDetail(MerchantVO merchantVO) {
        UserInfoDTO userInfoDTO;
        MerchantDetailDTO detail = new MerchantDetailDTO();
        detail.setFacadeUrl(StringUtils.isNotBlank((CharSequence)merchantVO.getFacadeUrl()) ? Arrays.asList(merchantVO.getFacadeUrl().split(",")) : new ArrayList());
        detail.setImgUrls(StringUtils.isNotBlank((CharSequence)merchantVO.getImgUrls()) ? Arrays.asList(merchantVO.getImgUrls().split(",")) : new ArrayList());
        detail.setMerchantName(merchantVO.getName());
        detail.setMerchantTypeDesc(StringUtils.isNotBlank((CharSequence)merchantVO.getType()) ? merchantVO.getType() : "");
        BeanUtils.copyProperties((Object)merchantVO, (Object)detail);
        if (merchantVO.getRelationUserId() != null && Objects.nonNull(userInfoDTO = this.userIntegrationService.getUserFromRedisDB(Long.valueOf(merchantVO.getRelationUserId().intValue())))) {
            UserForMerchantInfo userInfo = UserForMerchantInfo.builder().userId(merchantVO.getRelationUserId()).headimgurl(StringUtils.isNotBlank((CharSequence)userInfoDTO.getHeadImg()) ? userInfoDTO.getHeadImg() : "").nickName(StringUtils.isNotBlank((CharSequence)userInfoDTO.getNickname()) ? userInfoDTO.getNickname() : "").userJobDesc(StringUtils.isNotBlank((CharSequence)userInfoDTO.getPersonalProfile()) ? (userInfoDTO.getPersonalProfile().startsWith("\u4e00\u53e5\u8bdd\u4ecb\u7ecd\u4e0b\u81ea\u5df1") ? "\u6682\u65f6\u6ca1\u6709\u4ecb\u7ecd\u81ea\u5df1" : userInfoDTO.getPersonalProfile()) : "\u6682\u65f6\u6ca1\u6709\u4ecb\u7ecd\u81ea\u5df1").build();
            detail.setUserForMerchantInfo(userInfo);
        }
        return detail;
    }

    @Override
    public MerchantDetailDTO getDetailForShareOutSite(MerchantDetailBasicParam param) {
        MerchantVO merchantVO = this.merchantMapper.selectByPrimaryKey(param.getMerchantId());
        MerchantDetailDTO detail = this.convertToDetail(merchantVO);
        return detail;
    }

    private void distanceCalculationDetail(MerchantDetailParam param, MerchantDetailDTO merchantDetailDTO) {
        if (param.getLatitude() != null && param.getLongitude() != null) {
            Coordinate userLngAndLat = new Coordinate();
            userLngAndLat.setLongitude(param.getLongitude());
            userLngAndLat.setLatitude(param.getLatitude());
            if (merchantDetailDTO.getGeoLat() != null && merchantDetailDTO.getGeoLng() != null) {
                Long distance = this.fillInstance(userLngAndLat, merchantDetailDTO.getGeoLat(), merchantDetailDTO.getGeoLng());
                merchantDetailDTO.setDistance((double)Math.round((double)distance.longValue() / 100.0) / 10.0 < 1.0 ? "<1km" : String.valueOf((double)Math.round((double)distance.longValue() / 100.0) / 10.0) + "km");
            }
        }
    }

    private Long fillInstance(Coordinate userLngAndLat, Double geoLat, Double geoLng) {
        Coordinate lngAndLat = new Coordinate();
        lngAndLat.setLongitude(geoLng);
        lngAndLat.setLatitude(geoLat);
        return this.geoService.getDistance(userLngAndLat, lngAndLat);
    }
}

