/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.domain.DailyTaskMapper;
import com.bxm.localnews.activity.domain.NoviceTaskRecordMapper;
import com.bxm.localnews.activity.domain.SignRecordMapper;
import com.bxm.localnews.activity.dto.AppletAppTaskResultDTO;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.activity.service.VipService;
import com.bxm.localnews.activity.strategy.TaskStrategyContext;
import com.bxm.localnews.activity.vo.BaskInfoMeta;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.activity.vo.MissionModel;
import com.bxm.localnews.activity.vo.NoviceTaskRecord;
import com.bxm.localnews.activity.vo.SignRecord;
import com.bxm.localnews.activity.vo.UserMissionModel;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.InfoCombineStateEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.common.constant.WxMiniSceneEnum;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.service.WxMpFacadeService;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.gexin.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="missionService")
public class MissionServiceImpl
extends BaseService
implements MissionService {
    private static final Logger logger = LoggerFactory.getLogger(MissionServiceImpl.class);
    @Resource
    private SignRecordMapper signRecordMapper;
    @Resource
    private DailyTaskMapper dailyTaskMapper;
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private NoviceTaskRecordMapper noviceTaskRecordMapper;
    @Resource
    private TaskStrategyContext taskStrategyContext;
    @Resource
    private LocationFacadeService locationFacadeService;
    @Resource
    private NewsProperties newsProperties;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private VipService vipService;
    @Resource
    private AdvertService advertService;
    @Resource
    private AppVersionSupplyService appVersionSupplyService;
    @Resource
    private WxMpFacadeService wxMpFacadeService;
    @Resource
    private UserAuthIntegrationService userAuthIntegrationService;

    public Json<MissionModel> listMissions(Long userId, String areaCode, String curVer, Integer platform) {
        MissionModel retModel = new MissionModel();
        List<UserMissionModel> userTask = this.getUserTaskByPlatform(userId, platform);
        List<UserMissionModel> newbieTaskList = userTask.stream().filter(e -> DailyTask.NEWBIE_TASK.equals(e.getType())).sorted(Comparator.comparingInt(DailyTask::getLevel)).collect(Collectors.toList());
        List<UserMissionModel> dailyTaskList = userTask.stream().filter(e -> DailyTask.DAILY_TASK.equals(e.getType())).sorted(Comparator.comparingInt(DailyTask::getLevel)).collect(Collectors.toList());
        LocationDetailDTO locationDetailDTO = this.getLocation(userId, areaCode);
        boolean isPost = this.checkPost(locationDetailDTO);
        this.filterNewbieTask(newbieTaskList, retModel, userId, isPost, locationDetailDTO);
        this.filterDailyTask(dailyTaskList, retModel, userId, isPost, locationDetailDTO, curVer);
        logger.info("\u7528\u6237id\u4e3a[{}]\u9996\u6b21\u5904\u7406\u540e\u7684\u4efb\u52a1\u4fe1\u606f\u4e3a:{}", (Object)userId, (Object)JSON.toJSONString(userTask));
        this.supplementAdvertMission(curVer, retModel, areaCode, userId, isPost);
        Long gainGold = this.getRewardToday(userId);
        retModel.setGainGold(gainGold == null ? null : Integer.valueOf(gainGold.intValue()));
        retModel.setTotalGold(Integer.valueOf(this.newsProperties.getGoldPerDay()));
        this.sendFinishedToBackup(retModel);
        return ResultUtil.genSuccessResult((Object)retModel);
    }

    private void sendFinishedToBackup(MissionModel retModel) {
        ArrayList finished = Lists.newArrayList();
        ArrayList notFinish = Lists.newArrayList();
        retModel.getDailyTaskList().forEach(e -> {
            if (Objects.equals(e.getCompleted(), Boolean.TRUE)) {
                finished.add(e);
            } else {
                notFinish.add(e);
            }
        });
        notFinish.addAll(finished);
        retModel.setDailyTaskList((List)notFinish);
    }

    private void supplementAdvertMission(String curVer, MissionModel retModel, String areaCode, Long userId, boolean isPost) {
        List<Object> advertDailyTaskList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)curVer)) {
            List advertList = this.advertService.queryAdByType(Byte.valueOf((byte)2), areaCode, userId, null);
            advertDailyTaskList = this.convertAdvert(advertList);
        }
        Optional<UserMissionModel> advertDailyTaskStream = advertDailyTaskList.stream().filter(e -> "\u6bcf\u65e5\u7b7e\u5230".equals(e.getName())).findFirst();
        List<Object> dailyTaskList = new ArrayList<Object>();
        if (advertDailyTaskStream.isPresent()) {
            UserMissionModel dailySignTask = advertDailyTaskStream.get();
            SignRecord signRecord = this.signRecordMapper.getLastSignRecord(userId);
            if (signRecord != null && DateUtils.formatDate((Date)new Date()).equals(DateUtils.formatDate((Date)signRecord.getSignDate()))) {
                dailySignTask.setCompleted(Boolean.valueOf(true));
                dailySignTask.setAction("\u5df2\u5b8c\u6210");
            }
            dailyTaskList.add(dailySignTask);
            advertDailyTaskList.remove(dailySignTask);
        }
        dailyTaskList.addAll(retModel.getDailyTaskList());
        if (!isPost) {
            dailyTaskList = dailyTaskList.stream().filter(userMissionModel -> !userMissionModel.getName().equals(TaskEnum.TASK_POST_INTIVATION.getDesc())).collect(Collectors.toList());
        }
        dailyTaskList.addAll(advertDailyTaskList);
        retModel.setDailyTaskList(dailyTaskList);
    }

    private Long getRewardToday(Long userId) {
        KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
        logger.debug("\u4eceredis\u83b7\u53d6\u7528\u6237[{}]\u5f53\u5929\u5b8c\u6210\u4efb\u52a1\u83b7\u5f97\u5956\u52b1\u5c0f\u7ea2\u82b1\u603b\u6570", (Object)userId);
        return this.redisStringAdapter.getLong(userRewardSumKey);
    }

    private void filterNewbieTask(List<UserMissionModel> taskList, MissionModel retModel, Long userId, boolean isPost, LocationDetailDTO locationDetailDTO) {
        for (UserMissionModel e : taskList) {
            if (this.filterNotDisplayTaskByNoviceTask(e)) {
                logger.info("\u8be5\u4efb\u52a1[{}]\u4e0d\u5728\u524d\u7aef\u5c55\u793a", (Object)e.getName());
                continue;
            }
            TaskEnum taskEnum = TaskEnum.getTaskByType((byte)e.getTaskType());
            e.setColor(taskEnum.getColor());
            this.processNewbieTask(e, taskEnum, userId, isPost, locationDetailDTO);
            if ((TaskEnum.TASK_IMPROVE_INFO.equals((Object)taskEnum) || TaskEnum.TASK_FIRST_POST_INTIVATION.equals((Object)taskEnum)) && e.getCompleted().booleanValue()) continue;
            retModel.addNewbieTask(e);
        }
    }

    private void filterDailyTask(List<UserMissionModel> taskList, MissionModel retModel, Long userId, boolean isPost, LocationDetailDTO locationDetailDTO, String curVer) {
        Map<String, Byte> dailyTaskMap = this.getDailyTaskStatus(userId);
        for (UserMissionModel e : taskList) {
            TaskEnum taskEnum = TaskEnum.getTaskByType((byte)e.getTaskType());
            e.setColor(taskEnum.getColor());
            if (taskEnum.equals((Object)TaskEnum.TASK_WATCH_VIDEO) && this.appVersionSupplyService.isHighVersion(curVer, "3.1.4") < 0) continue;
            this.processDailyTask(e, taskEnum, userId, isPost, dailyTaskMap, locationDetailDTO);
            if (taskEnum.equals((Object)TaskEnum.TASK_ACTIVATION_VIP) && e.getCompleted().booleanValue()) continue;
            retModel.addDailyTask(e);
        }
    }

    private List<UserMissionModel> convertAdvert(List<AdvertVO> advertList) {
        ArrayList dailyTaskList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(advertList)) {
            return dailyTaskList;
        }
        advertList.forEach(advertDTO -> {
            UserMissionModel userMissionModel = new UserMissionModel();
            userMissionModel.setAction(advertDTO.getCopy());
            userMissionModel.setHeadImg(advertDTO.getIconUrl());
            userMissionModel.setName(advertDTO.getTaskMaintitle());
            userMissionModel.setRemark(advertDTO.getTaskSubtitle());
            userMissionModel.setAddress(advertDTO.getAddress());
            userMissionModel.setType(UserMissionModel.ADVERT_TASK);
            userMissionModel.setId(advertDTO.getId());
            userMissionModel.setMaterialId(advertDTO.getMaterialId());
            dailyTaskList.add(userMissionModel);
        });
        return dailyTaskList;
    }

    private Boolean checkPost(LocationDetailDTO locationDetailDTO) {
        return locationDetailDTO != null && locationDetailDTO.getEnableCommunityContent() != 0;
    }

    private Boolean checkVipActivation(Long userId, LocationDetailDTO locationDetailDTO) {
        return this.vipService.checkUserVip(userId) || this.isShowVipTask(locationDetailDTO);
    }

    private LocationDetailDTO getLocation(Long userId, String areaCode) {
        LocationDetailDTO locationDTO = null;
        if (StringUtils.isNotEmpty((CharSequence)areaCode)) {
            locationDTO = this.locationFacadeService.getLocationDetailByCode(areaCode);
        } else {
            LocationDetailDTO locationIntegrationDetailDTO = this.userIntegrationService.getLocationByUser(this.userIntegrationService.selectByPrimaryKey(userId));
            if (null != locationIntegrationDetailDTO) {
                locationDTO = new LocationDetailDTO();
                BeanUtils.copyProperties((Object)locationIntegrationDetailDTO, (Object)locationDTO);
            }
        }
        return locationDTO;
    }

    private boolean isShowVipTask(LocationDetailDTO locationDTO) {
        if (locationDTO == null) {
            return false;
        }
        return 0 == locationDTO.getEnableVip();
    }

    public Json<BaskInfoMeta> baskInfo(Long userId) {
        BigDecimal totalCash = this.userAccountIntegrationService.getUserTotalCash(userId);
        BaskInfoMeta meta = new BaskInfoMeta();
        meta.setInviteCode(userId);
        meta.setTotalCoin(totalCash);
        return ResultUtil.genSuccessResult((Object)meta);
    }

    public void completeDailyTask(Long userId, Byte taskId) {
        Assert.notNull((Object)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        logger.debug(LogMarker.BIZ, "[{}]\u5b8c\u6210\u4e86\u4efb\u52a1[{}]", (Object)userId, (Object)taskId);
        KeyGenerator key = this.getDailyTaskCacheKey(userId);
        this.redisHashMapAdapter.put(key, taskId.toString(), (Object)1);
        this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private KeyGenerator getDailyTaskCacheKey(Long userId) {
        return RedisConfig.DAILY_TASK_COMPELE_STATUS.copy().setKey(DateUtils.formatDate((Date)new Date()) + userId);
    }

    public Map<String, Byte> getDailyTaskStatus(Long userId) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Map result = this.redisHashMapAdapter.entries(this.getDailyTaskCacheKey(userId), Byte.class);
        if (result == null) {
            result = Maps.newHashMap();
        }
        return result;
    }

    public NewsMissionRewardDto completeTask(Long userId, TaskEnum taskEnum, String relationId, String content) {
        logger.debug("\u7528\u6237[{}]\u5b8c\u6210\u4efb\u52a1\u7c7b\u578b[{}]---\u5efa\u7acb\u9080\u8bf7\u5173\u7cfb[{}]", new Object[]{userId, taskEnum.name(), relationId});
        TaskContext taskContext = new TaskContext();
        taskContext.setUserId(userId);
        taskContext.setTaskEnum(taskEnum);
        taskContext.setRelationId(relationId);
        taskContext.setContent(content);
        return this.taskStrategyContext.chooseStrategy(taskContext);
    }

    public AppletAppTaskResultDTO completeSceneTask(Long userId, String scene) {
        TaskEnum taskEnum = WxMiniSceneEnum.getTaskEnumByScene((String)scene);
        if (null == taskEnum) {
            logger.warn("\u9519\u8bef\u573a\u666f\u503c[{}]\u4f20\u5165,\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u4efb\u52a1", (Object)scene);
            return new AppletAppTaskResultDTO();
        }
        boolean isCompleteNoviceTask = this.isCompleteNoviceTask(userId, taskEnum);
        NewsMissionRewardDto taskReward = this.completeTask(userId, taskEnum, null, null);
        AppletAppTaskResultDTO appletAppTaskResultDTO = new AppletAppTaskResultDTO();
        if (!isCompleteNoviceTask && taskReward.getGoldNum() != null && 0L < taskReward.getGoldNum()) {
            appletAppTaskResultDTO.setPopUpWindowFlag(Boolean.valueOf(true));
        }
        appletAppTaskResultDTO.setTaskReward(taskReward.getGoldNum());
        return appletAppTaskResultDTO;
    }

    private List<UserMissionModel> getUserTaskByPlatform(Long userId, Integer platform) {
        List userTask;
        if (5 == platform) {
            userTask = this.dailyTaskMapper.listMissions(userId, "APPLET_APP");
            logger.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5230\u7684\u5c0f\u7a0b\u5e8f\u4efb\u52a1\u4e3a:{}", (Object)JSON.toJSONString((Object)userTask));
        } else {
            userTask = this.dailyTaskMapper.listMissions(userId, "APP");
            logger.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5230\u7684\u5ba2\u6237\u7aef\u4efb\u52a1\u4e3a:{}", (Object)JSON.toJSONString((Object)userTask));
        }
        return userTask;
    }

    private void processNewbieTask(UserMissionModel model, TaskEnum taskEnum, Long userId, boolean isPost, LocationDetailDTO locationDetailDTO) {
        model.setCompleted(Boolean.valueOf(false));
        switch (taskEnum) {
            case TASK_IMPROVE_INFO: {
                model.setAddress("tt://perfectData");
                if (1 == model.getNewbiewTaskState()) {
                    model.setCompleted(Boolean.valueOf(true));
                    break;
                }
                UserInfoDTO user = this.userIntegrationService.getUserFromRedisDB(userId);
                model.setCompletedNum(Integer.valueOf(InfoCombineStateEnum.getInfoCompleteStatus((Long)(user.getInfoCompleteState() == null ? 0L : user.getInfoCompleteState()))));
                model.setTotalNum(Integer.valueOf(InfoCombineStateEnum.values().length));
                model.setInfoCompleteText("\u8d44\u6599\u5b8c\u6210\u5ea6" + model.getCompletedNum() * 100 / model.getTotalNum() + "%");
                break;
            }
            case TASK_FIRST_POST_INTIVATION: {
                model.setAddress("tt://postInvitation");
                if (1 == model.getNewbiewTaskState() || !isPost) {
                    model.setCompleted(Boolean.valueOf(true));
                }
                model.setName(model.getName().replace("\u672c\u5730", locationDetailDTO.getName()).replace("\u5e02", "").replace("\u53bf", ""));
                break;
            }
            case TASK_COLLECT_APPLET_MINI: {
                NoviceTaskRecord noviceTaskRecord = this.noviceTaskRecordMapper.findSelectiveByTaskType(model.getTaskType(), userId);
                if (null != noviceTaskRecord && 1 == noviceTaskRecord.getState()) {
                    model.setCompleted(Boolean.valueOf(true));
                }
                logger.info("\u6536\u85cf\u4efb\u52a1\u6ca1\u8bb0\u5f55\u6216\u8005\u672a\u5b8c\u6210,\u4efb\u52a1\u8bb0\u5f55\u4e3a:{}", (Object)JSON.toJSONString((Object)noviceTaskRecord));
                break;
            }
            case TASK_FOCUS_WECAHT: {
                UserAuth userAuth = this.userAuthIntegrationService.selectWechatUserAuthByUserId(userId);
                if (null == userAuth || !this.wxMpFacadeService.subscribeWechat(userAuth.getIdentifier()).booleanValue()) break;
                NoviceTaskRecord focusWechatTaskRecord = this.noviceTaskRecordMapper.findSelectiveByTaskType(Byte.valueOf(TaskEnum.TASK_FOCUS_WECAHT.getType()), userId);
                if (focusWechatTaskRecord == null) {
                    logger.info("\u5f53\u524d\u7528\u6237[{}]\u5173\u6ce8\u516c\u4f17\u53f7----\u89e6\u53d1\u4efb\u52a1\u5b8c\u6210", (Object)userId);
                    this.completeTask(userId, TaskEnum.TASK_FOCUS_WECAHT, null, null);
                }
                model.setCompleted(Boolean.valueOf(true));
                break;
            }
        }
    }

    private void processDailyTask(UserMissionModel userMissionModel, TaskEnum taskEnum, Long userId, boolean isPost, Map<String, Byte> dailyTaskMap, LocationDetailDTO locationDetailDTO) {
        userMissionModel.setState(Byte.valueOf(dailyTaskMap.get(userMissionModel.getId().toString()) == null ? (byte)0 : 1));
        KeyGenerator key = null;
        switch (taskEnum) {
            case TASK_NEWS_READ: {
                key = RedisConfig.NEWS_READ.copy().setKey(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
                userMissionModel.setAddress("tt://readNews");
                break;
            }
            case TASK_NEWS_SHARE: {
                key = RedisConfig.TASK_SHARE_NEWS_NUM.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
                userMissionModel.setAddress("tt://shareWxchat");
                break;
            }
            case TASK_VIDEO_READ: {
                key = RedisConfig.VIDEO_READ_NUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                userMissionModel.setAddress("tt://lookVideo");
                break;
            }
            case TASK_INVITED_FRIEND: {
                userMissionModel.setCompleted(Boolean.valueOf(false));
                userMissionModel.setAddress("tt://inviteSt");
                break;
            }
            case TASK_ACTIVATION_VIP: {
                Boolean isVip = this.checkVipActivation(userId, locationDetailDTO);
                userMissionModel.setCompleted(isVip);
                userMissionModel.setAddress("tt://callActivateVip");
                break;
            }
            case TASK_POST_INTIVATION: {
                userMissionModel.setCompleted(Boolean.valueOf(isPost));
                key = RedisConfig.POST_FORUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                userMissionModel.setAddress("tt://postInvitation");
                userMissionModel.setName(userMissionModel.getName().replace("\u672c\u5730", locationDetailDTO.getName()).replace("\u5e02", "").replace("\u53bf", ""));
                break;
            }
            case TASK_FIRST_BROWSE: {
                userMissionModel.setAddress("tt://shareNews");
                userMissionModel.setName(userMissionModel.getName().replace("\u672c\u5730", locationDetailDTO.getName()).replace("\u5e02", "").replace("\u53bf", ""));
                break;
            }
            case TASK_COMMENT_NEWS: {
                userMissionModel.setAddress("tt://commentNews");
                userMissionModel.setName(userMissionModel.getName().replace("\u672c\u5730", locationDetailDTO.getName()).replace("\u5e02", "").replace("\u53bf", ""));
                key = RedisConfig.NEWS_COMMENT.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                break;
            }
            case TASK_WATCH_VIDEO: {
                userMissionModel.setAddress("tt://watchVideos");
                key = RedisConfig.WATCH_VIDEO.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                break;
            }
        }
        if (key != null) {
            Integer number = this.redisStringAdapter.hasKey(key) != false ? this.redisStringAdapter.getInt(key) : Integer.valueOf(0);
            userMissionModel.setCompleted(Boolean.valueOf(number >= userMissionModel.getNumber()));
            userMissionModel.setCompletedNum(number);
            userMissionModel.setTotalNum(userMissionModel.getNumber());
        }
    }

    private boolean isCompleteNoviceTask(Long userId, TaskEnum taskEnum) {
        NoviceTaskRecord noviceTaskRecord = this.noviceTaskRecordMapper.findSelectiveByTaskType(Byte.valueOf(taskEnum.getType()), userId);
        if (null != noviceTaskRecord && 1 == noviceTaskRecord.getState()) {
            logger.debug("\u67e5\u8be2\u7684\u65b0\u4eba\u4efb\u52a1\u5df2\u5b8c\u6210,\u7528\u6237id:{},\u4efb\u52a1\u7c7b\u578b:{}", (Object)userId, (Object)taskEnum.getDesc());
            return true;
        }
        logger.debug("\u67e5\u8be2\u65b0\u4eba\u4efb\u52a1\u672a\u5b8c\u6210,\u7528\u6237id:{},\u4efb\u52a1\u7c7b\u578b:{}", (Object)userId, (Object)taskEnum.getDesc());
        return false;
    }

    private boolean filterNotDisplayTaskByNoviceTask(UserMissionModel model) {
        return TaskEnum.TASK_FIRST_LOGIN.getType() == model.getTaskType().byteValue();
    }
}

