/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.common.constant.CommodityCategoryEnum;
import com.bxm.localnews.activity.common.constant.VipStatusEnum;
import com.bxm.localnews.activity.domain.CommodityCodeMapper;
import com.bxm.localnews.activity.domain.CommodityMapper;
import com.bxm.localnews.activity.domain.MerchantMapper;
import com.bxm.localnews.activity.domain.WinnerMapper;
import com.bxm.localnews.activity.dto.MovieDTO;
import com.bxm.localnews.activity.dto.NoticeDTO;
import com.bxm.localnews.activity.param.MovieParam;
import com.bxm.localnews.activity.param.PrivilegeParam;
import com.bxm.localnews.activity.service.MovieService;
import com.bxm.localnews.activity.service.PrivilegeService;
import com.bxm.localnews.activity.service.VipService;
import com.bxm.localnews.activity.vo.CommodityCode;
import com.bxm.localnews.activity.vo.CommodityVO;
import com.bxm.localnews.activity.vo.MerchantVO;
import com.bxm.localnews.activity.vo.Vip;
import com.bxm.localnews.activity.vo.WinnerVO;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MovieServiceImpl
extends BaseService
implements MovieService {
    @Autowired
    private CommodityMapper commodityMapper;
    @Autowired
    private WinnerMapper winnerMapper;
    @Autowired
    private MerchantMapper merchantMapper;
    @Autowired
    private CommodityCodeMapper commodityCodeMapper;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private GeoService geoService;
    @Autowired
    private PrivilegeService privilegeService;
    @Autowired
    private LocationFacadeService locationFacadeService;
    private VipService vipService;

    @Override
    public boolean isHasMovie(Long userId) {
        Integer count = this.commodityMapper.countVipMovie(userId);
        return count > 0;
    }

    private VipService getVipService() {
        if (null == this.vipService) {
            this.vipService = (VipService)SpringContextHolder.getBean(VipService.class);
        }
        return this.vipService;
    }

    @Override
    public MovieDTO getMovieDetail(MovieParam movieParam) {
        WinnerVO winnerVO;
        MerchantVO merchantVO;
        List winnerList;
        Vip vip = this.getVipService().getVipByUser(movieParam.getUserId());
        if (null != vip && VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus()) && CollectionUtils.isNotEmpty((Collection)(winnerList = this.winnerMapper.getVipMovie(movieParam.getUserId()))) && null != (merchantVO = this.merchantMapper.selectByPrimaryKey((winnerVO = (WinnerVO)winnerList.get(0)).getMerchantId()))) {
            MovieDTO movieDTO = new MovieDTO();
            movieDTO.setTitle(merchantVO.getName());
            movieDTO.setBusinessArea(merchantVO.getBusinessArea());
            movieDTO.setBusinessEndTime(merchantVO.getBusinessEndTime());
            movieDTO.setBusinessStartTime(merchantVO.getBusinessStartTime());
            movieDTO.setDisplayAddress(merchantVO.getDisplayAddress());
            movieDTO.setGeoLat(merchantVO.getGeoLat());
            movieDTO.setGeoLng(merchantVO.getGeoLng());
            movieDTO.setHeadImg(merchantVO.getHeadImg());
            movieDTO.setMerchantName(merchantVO.getName());
            movieDTO.setServicePhone(merchantVO.getServicePhone());
            movieDTO.setCode(winnerVO.getCommodityCode());
            movieDTO.setExpireTime(winnerVO.getRedeemTime());
            movieDTO.setDistance(this.getDistance(movieParam, merchantVO));
            if (StringUtils.isNotEmpty((CharSequence)vip.getActivationAreaCode())) {
                movieDTO.setActivationAreaCode(vip.getActivationAreaCode());
            }
            return movieDTO;
        }
        return null;
    }

    private String getDistance(MovieParam movieParam, MerchantVO merchantVO) {
        PrivilegeParam privilegeParam = new PrivilegeParam();
        BeanUtils.copyProperties((Object)movieParam, (Object)privilegeParam);
        privilegeParam.setUserId(movieParam.getUserId());
        Coordinate userLngAndLat = this.privilegeService.getUserCoordinate(privilegeParam);
        if (null != userLngAndLat) {
            Coordinate merchantLngAndLat = new Coordinate();
            if (merchantVO.getGeoLng() != null && merchantVO.getGeoLat() != null) {
                merchantLngAndLat.setLongitude(merchantVO.getGeoLng());
                merchantLngAndLat.setLatitude(merchantVO.getGeoLat());
                Long distance = this.geoService.getDistance(userLngAndLat, merchantLngAndLat);
                String distancePreStr = "\u8ddd\u60a8";
                return distancePreStr + (double)Math.round((double)distance.longValue() / 100.0) / 10.0 + "km";
            }
        }
        return "";
    }

    @Override
    public NoticeDTO getMovieVipNotice(Long userId) {
        WinnerVO winnerVO;
        List winnerList = this.winnerMapper.getVipMovie(userId);
        if (CollectionUtils.isNotEmpty((Collection)winnerList) && (winnerVO = (WinnerVO)winnerList.get(0)).getPopup() == 1) {
            NoticeDTO noticeDTO = new NoticeDTO();
            noticeDTO.setName(CommodityCategoryEnum.MOVIE.getDesc());
            noticeDTO.setPopup(true);
            return noticeDTO;
        }
        return null;
    }

    @Override
    public void updateMovieVipNotice(Long userId) {
        List winnerList = this.winnerMapper.getVipMovie(userId);
        if (CollectionUtils.isNotEmpty((Collection)winnerList)) {
            WinnerVO winnerVO = (WinnerVO)winnerList.get(0);
            this.winnerMapper.updateWinnerPopup(winnerVO.getId());
        }
    }

    @Override
    public void doGeneratorMovie(Long userId, String areaCode) {
        int count = 0;
        this.retry(userId, count, areaCode);
    }

    private void retry(Long userId, Integer count, String areaCode) {
        if (count >= 3) {
            this.logger.error("\u83b7\u53d6\u9501\u8fbe\u4e09\u6b21\u4ee5\u4e0a\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c");
            return;
        }
        List commodityList = this.commodityMapper.selectByCategory(CommodityCategoryEnum.MOVIE.getType());
        if (CollectionUtils.isNotEmpty((Collection)commodityList)) {
            List winnerList = this.winnerMapper.getVipMovie(userId);
            if (CollectionUtils.isNotEmpty((Collection)winnerList)) {
                return;
            }
            String requestId = String.valueOf(this.nextSequence());
            CommodityVO commodityVO = this.getCommodity(commodityList, areaCode);
            if (null == commodityVO) {
                return;
            }
            List commodityCodeList = this.commodityCodeMapper.getUnusedCommodities(commodityVO.getId().longValue(), 1);
            if (CollectionUtils.isEmpty((Collection)commodityCodeList)) {
                return;
            }
            String code = ((CommodityCode)commodityCodeList.get(0)).getCode();
            if (this.distributedLock.lock(code, requestId)) {
                this.commodityCodeMapper.updateToUsed(code, commodityVO.getId().longValue());
                WinnerVO winnerVO = new WinnerVO();
                winnerVO.setAddTime(new Date());
                winnerVO.setCommodityCode(code);
                winnerVO.setId(this.nextSequence());
                winnerVO.setUserId(userId);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(2, 2);
                winnerVO.setRedeemTime(calendar.getTime());
                this.winnerMapper.insertSelective(winnerVO);
                this.distributedLock.unlock(code, requestId);
            } else {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                this.retry(userId, n, areaCode);
            }
        }
    }

    private CommodityVO getCommodity(List<CommodityVO> commodityList, String areaCode) {
        Optional<CommodityVO> commodityVO = commodityList.stream().filter(x -> this.isCurrentArea((CommodityVO)x, areaCode)).findFirst();
        return commodityVO.orElse(null);
    }

    private boolean isCurrentArea(CommodityVO commodityVO, String areaCode) {
        MerchantVO merchantVO = this.merchantMapper.selectByPrimaryKey(commodityVO.getMerchantId());
        String cityCode = merchantVO.getCityCode();
        String countyCode = merchantVO.getCountyCode();
        LocationDetailDTO locationDTO = this.locationFacadeService.getLocationDetailByCode(countyCode);
        if (null != locationDTO) {
            return areaCode.equals(countyCode);
        }
        LocationDetailDTO locationByCityCode = this.locationFacadeService.getLocationDetailByCode(cityCode);
        if (null != locationByCityCode) {
            return areaCode.equals(cityCode);
        }
        return false;
    }
}

