/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.domain.PrivilegeMapper;
import com.bxm.localnews.activity.domain.PrivilegeParticipantMapper;
import com.bxm.localnews.activity.service.PrivilegeParticipantService;
import com.bxm.localnews.activity.vo.PrivilegeParticipantVO;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="privilegeParticipantService")
public class PrivilegeParticipantServiceImpl
implements PrivilegeParticipantService {
    @Resource
    private PrivilegeParticipantMapper privilegeParticipantMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private RedisZSetAdapter redisZSetAdapter;
    @Resource
    private PrivilegeMapper privilegeMapper;
    @Resource
    private BizLogService bizLogService;

    @Override
    public PrivilegeParticipantVO getPrivilegeParticipant(Long userId, Long privilegeId) {
        return this.privilegeParticipantMapper.getPrivilegeParticipant(userId, privilegeId);
    }

    @Override
    public int saveParticipantPrivilege(Long userId, Long inviteUserId, Long privilegeId, String ip) {
        PrivilegeParticipantVO privilegeParticipantVO = new PrivilegeParticipantVO();
        privilegeParticipantVO.setId(this.sequenceCreater.nextLongId());
        if (this.getPrivilegeParticipant(inviteUserId, privilegeId) != null) {
            this.bizLogService.invitePrivilege(inviteUserId, userId, privilegeId);
            privilegeParticipantVO.setInviteUserId(inviteUserId);
        }
        privilegeParticipantVO.setIp(ip);
        privilegeParticipantVO.setUserId(userId);
        privilegeParticipantVO.setPrivilegeId(privilegeId);
        int saveResult = this.privilegeParticipantMapper.savePrivilegeParticipant(privilegeParticipantVO);
        this.privilegeMapper.updatePrivilegeParticipantNum(privilegeId);
        if (privilegeParticipantVO.getInviteUserId() != null) {
            KeyGenerator inviteNumRedisKey = RedisConfig.PRIVILEGE_INVITENUM.copy().appendKey((Object)privilegeId);
            this.redisZSetAdapter.incrementScore(inviteNumRedisKey, (Object)inviteUserId, 1.0);
        }
        this.bizLogService.joinPrivilege(userId, privilegeId);
        return saveResult;
    }
}

