/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.activity.common.constant.PrivilegeStatusEnum;
import com.bxm.localnews.activity.domain.PrivilegeAreaMapper;
import com.bxm.localnews.activity.domain.PrivilegeMapper;
import com.bxm.localnews.activity.domain.PrivilegeParticipantMapper;
import com.bxm.localnews.activity.domain.WinnerMapper;
import com.bxm.localnews.activity.dto.LeaderboardDTO;
import com.bxm.localnews.activity.dto.PrivilegeDTO;
import com.bxm.localnews.activity.dto.PrivilegeListDTO;
import com.bxm.localnews.activity.dto.PrivilegeOverviewDTO;
import com.bxm.localnews.activity.dto.PrivilegeParticipantDTO;
import com.bxm.localnews.activity.dto.WinnerDTO;
import com.bxm.localnews.activity.param.PrivilegeDetailParam;
import com.bxm.localnews.activity.param.PrivilegeOverviewParam;
import com.bxm.localnews.activity.param.PrivilegeParam;
import com.bxm.localnews.activity.param.PrivilegeParticipantParam;
import com.bxm.localnews.activity.param.PrivilegeRecommendParam;
import com.bxm.localnews.activity.service.PrivilegeService;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.dto.PrivilegeShareShortLinkDTO;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.Page;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="privilegeService")
public class PrivilegeServiceImpl
extends BaseService
implements PrivilegeService {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeServiceImpl.class);
    private static final String DEFAULT_HEAD_PNG = "https://bxm-news.oss-cn-hangzhou.aliyuncs.com/toutiao_test/common/default_head.png";
    private static final String BARCODE_PNG = "http://mtest.wstong.com/localnews_test/png/20181204/H8UKWHWUZ9Q03IK21BDCQ9W7WS4O2CD2VF9PJQ1.png";
    private static final String BARCODE_GIF = "http://mtest.wstong.com/localnews_test/gif/20181204/H8UKWHWUZ9Q03IK21BDCQ9W7WS4O2I80VF9PJP1.gif";
    @Resource
    private PrivilegeMapper privilegeMapper;
    @Resource
    private GeoService geoService;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private WinnerMapper winnerMapper;
    @Resource
    private RedisZSetAdapter redisZSetAdapter;
    @Resource
    private PrivilegeAreaMapper privilegeAreaMapper;
    @Resource
    private ShortLinkService shortLinkService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private LocationFacadeService locationFacadeService;
    @Resource
    private AppVersionSupplyService appVersionSupplyService;
    @Resource
    private PrivilegeParticipantMapper privilegeParticipantMapper;
    @Resource
    private RedisStringAdapter redisStringAdapter;

    private static PrivilegeParticipantDTO parseUserParticipant(String userInfoJson) {
        if (StringUtils.isNotBlank((CharSequence)userInfoJson)) {
            try {
                UserInfoDTO userInfoDTO = (UserInfoDTO)JSON.parseObject((String)userInfoJson, UserInfoDTO.class);
                PrivilegeParticipantDTO privilegeParticipantDTO = new PrivilegeParticipantDTO();
                BeanUtils.copyProperties((Object)userInfoDTO, (Object)privilegeParticipantDTO);
                return privilegeParticipantDTO;
            }
            catch (Exception e) {
                log.error("redis user parseObject error", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public PageWarper<PrivilegeParticipantDTO> listPrivilegeParticipantByInvite(PrivilegeParticipantParam privilegeParticipantParam) {
        Page inviterIds = (Page)this.privilegeParticipantMapper.listPrivilegeParticipantByInvite(privilegeParticipantParam);
        PageWarper pageWarper = new PageWarper((List)inviterIds);
        List inviterStrIds = inviterIds.stream().map(String::valueOf).collect(Collectors.toList());
        List userInfoJsonList = this.redisHashMapAdapter.multiGet(RedisConfig.USER_INFO, inviterStrIds, String.class);
        List privilegeParticipantDTOS = userInfoJsonList.stream().map(PrivilegeServiceImpl::parseUserParticipant).filter(Objects::nonNull).collect(Collectors.toList());
        if (inviterIds.size() > privilegeParticipantDTOS.size()) {
            List existUserIds = privilegeParticipantDTOS.stream().mapToLong(PrivilegeParticipantDTO::getId).boxed().collect(Collectors.toList());
            List lackUserIds = inviterIds.stream().filter(id -> !existUserIds.contains(id)).collect(Collectors.toList());
            for (Long lackUserId : lackUserIds) {
                UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(lackUserId);
                PrivilegeParticipantDTO privilegeParticipantDTO = new PrivilegeParticipantDTO();
                BeanUtils.copyProperties((Object)userInfoDTO, (Object)privilegeParticipantDTO);
                privilegeParticipantDTOS.add(privilegeParticipantDTO);
            }
        }
        pageWarper.setList(privilegeParticipantDTOS);
        return pageWarper;
    }

    @Override
    public PageWarper<PrivilegeListDTO> listPrivilege(PrivilegeParam privilegeParam, BasicParam basicParam) {
        this.logger.debug("\u83b7\u53d6\u6d3b\u52a8\u5217\u8868,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)privilegeParam));
        if (privilegeParam.getShowAll() == 0) {
            LocationDetailDTO locationDTO = this.locationFacadeService.getLocationDetailByCode(privilegeParam.getAreaCode());
            if (null == locationDTO || 0 == locationDTO.getEnableVip()) {
                this.logger.warn("\u5f53\u524d\u5730\u533a\u4e0d\u5b58\u5728\u6216\u672a\u5f00\u901a\uff0c\u8bf7\u6c42\u53c2\u6570:{}", JSON.toJSON((Object)privilegeParam));
                return new PageWarper(new ArrayList());
            }
            Date today = new Date();
            PrivilegeOverviewParam param = new PrivilegeOverviewParam();
            BeanUtils.copyProperties((Object)privilegeParam, (Object)param);
            List<Object> privilegeListDTOS = this.listPrivilege(param);
            privilegeListDTOS = privilegeListDTOS.stream().filter(x -> this.compareDate(today, x.getStartTime(), x.getEndTime())).collect(Collectors.toList());
            int total = privilegeListDTOS.size();
            Coordinate userLngAndLat = this.getUserCoordinate(privilegeParam);
            if (null != userLngAndLat) {
                this.distanceCalculation(userLngAndLat, privilegeListDTOS);
                privilegeListDTOS = privilegeListDTOS.stream().sorted(Comparator.comparing(PrivilegeListDTO::getDistanceNum)).collect(Collectors.toList());
            }
            privilegeListDTOS = privilegeListDTOS.stream().skip((privilegeParam.getPageNum() - 1) * privilegeParam.getPageSize()).limit(privilegeParam.getPageSize().intValue()).collect(Collectors.toList());
            privilegeListDTOS.forEach(this::fillFreeAndDiscount);
            Page page = new Page(privilegeParam.getPageNum().intValue(), privilegeParam.getPageSize().intValue());
            page.setTotal((long)total);
            page.addAll(privilegeListDTOS);
            return new PageWarper((List)page);
        }
        if (!this.getPublishState(basicParam).booleanValue()) {
            this.logger.error("\u5730\u533a\u7f16\u7801\u4e3a\u7a7a!!! \u7528\u6237:{},\u57fa\u7840\u53c2\u6570:{}", (Object)privilegeParam.getUserId(), JSON.toJSON((Object)basicParam));
            return new PageWarper(new ArrayList());
        }
        this.logger.warn("IOS\u63d0\u5305\u65f6\u8bf7\u6c42\u6b64\u63a5\u53e3!!! \u7528\u6237:{}", (Object)privilegeParam.getUserId());
        privilegeParam.setAreaCode(null);
        List privilegeListDTOS = this.privilegeMapper.listPrivilege(privilegeParam);
        Coordinate userLngAndLat = this.getUserCoordinate(privilegeParam);
        if (null != userLngAndLat) {
            this.distanceCalculation(userLngAndLat, privilegeListDTOS);
        }
        this.fillingPrivilegeCountDown(privilegeListDTOS);
        return new PageWarper(privilegeListDTOS);
    }

    private boolean compareDate(Date today, Date startDate, Date endDate) {
        long todayTime = today.getTime();
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        return todayTime > startTime && todayTime < endTime;
    }

    private List<PrivilegeListDTO> listPrivilege(PrivilegeOverviewParam privilegeParam) {
        TypeReference<List<PrivilegeListDTO>> typeReference = new TypeReference<List<PrivilegeListDTO>>(){};
        List records = (List)this.redisStringAdapter.get(this.getPrivilegeListKey(privilegeParam.getAreaCode()), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)records)) {
            records = this.privilegeMapper.listAllPrivilege(privilegeParam);
            this.redisStringAdapter.set(this.getPrivilegeListKey(privilegeParam.getAreaCode()), (Object)records);
        }
        return records;
    }

    private KeyGenerator getPrivilegeListKey(String areaCode) {
        return RedisConfig.PRIVILEGE_lIST.copy().appendKey((Object)areaCode);
    }

    private Boolean getPublishState(BasicParam basicParam) {
        return this.appVersionSupplyService.getPublishState(basicParam);
    }

    private void fillFreeAndDiscount(PrivilegeListDTO privilegeListDTO) {
        if (null != privilegeListDTO.getDistanceNum() && privilegeListDTO.getDistanceNum() > 200000L) {
            privilegeListDTO.setDistance(null);
        }
        if (StringUtils.isEmpty((CharSequence)privilegeListDTO.getFreeTitle())) {
            privilegeListDTO.setFree(false);
        } else {
            privilegeListDTO.setFree(true);
        }
        if (StringUtils.isBlank((CharSequence)privilegeListDTO.getDiscount())) {
            privilegeListDTO.setDiscount("");
        }
    }

    @Override
    public List<PrivilegeOverviewDTO> listAllPrivilege(PrivilegeOverviewParam privilegeParam) {
        LocationDetailDTO locationDTO = this.locationFacadeService.getLocationDetailByCode(privilegeParam.getAreaCode());
        if (null == locationDTO || 0 == locationDTO.getEnableVip()) {
            this.logger.warn("\u5f53\u524d\u5730\u533a\u4e0d\u5b58\u5728\u6216\u672a\u5f00\u901a\uff0c\u8bf7\u6c42\u53c2\u6570:{}", JSON.toJSON((Object)privilegeParam));
            return null;
        }
        List<Object> privilegeListDTOS = this.listPrivilege(privilegeParam);
        Date today = new Date();
        privilegeListDTOS = privilegeListDTOS.stream().filter(x -> x.getDiscount() != null || x.getFreeTitle() != null).filter(x -> this.compareDate(today, x.getStartTime(), x.getEndTime())).collect(Collectors.toList());
        if (null != privilegeParam.getLatitude() && null != privilegeParam.getLongitude()) {
            Coordinate userLngAndLat = new Coordinate();
            userLngAndLat.setLatitude(privilegeParam.getLatitude());
            userLngAndLat.setLongitude(privilegeParam.getLongitude());
            this.distanceCalculation(userLngAndLat, privilegeListDTOS);
            privilegeListDTOS = privilegeListDTOS.stream().sorted(Comparator.comparing(PrivilegeListDTO::getDistanceNum)).collect(Collectors.toList());
        }
        privilegeListDTOS.forEach(this::fillFreeAndDiscount);
        List<PrivilegeOverviewDTO> privilegeOverviewDTOList = privilegeListDTOS.stream().map(this::convertPrivilege).collect(Collectors.toList());
        return privilegeOverviewDTOList;
    }

    private PrivilegeOverviewDTO convertPrivilege(PrivilegeListDTO privilegeListDTO) {
        PrivilegeOverviewDTO privilegeOverviewDTO = new PrivilegeOverviewDTO();
        BeanUtils.copyProperties((Object)privilegeListDTO, (Object)privilegeOverviewDTO);
        return privilegeOverviewDTO;
    }

    @Override
    public PageWarper<PrivilegeListDTO> listRecommendPrivilege(PrivilegeRecommendParam privilegeRecommendParam) {
        List privilegeListDTOS = this.privilegeMapper.listRecommendPrivilege(privilegeRecommendParam);
        Coordinate userLngAndLat = this.getUserCoordinate((PrivilegeParam)privilegeRecommendParam);
        if (null != userLngAndLat) {
            this.distanceCalculation(userLngAndLat, privilegeListDTOS);
        }
        this.fillingPrivilegeCountDown(privilegeListDTOS);
        return new PageWarper(privilegeListDTOS);
    }

    @Override
    public PrivilegeDTO getPrivilegeDetail(PrivilegeDetailParam privilegeDetailParam) {
        PrivilegeDTO privilegeDTO = this.privilegeMapper.getPrivilegeDetail(privilegeDetailParam.getId());
        if (null == privilegeDTO) {
            return null;
        }
        PrivilegeParam param = new PrivilegeParam();
        BeanUtils.copyProperties((Object)privilegeDetailParam, (Object)param);
        Coordinate userLngAndLat = this.getUserCoordinate(param);
        this.distanceCalculation(userLngAndLat, privilegeDTO);
        if (privilegeDetailParam.getUserId() != null) {
            User user = this.userIntegrationService.selectByPrimaryKey(privilegeDetailParam.getUserId());
            PrivilegeShareShortLinkDTO privilegeShareShortLinkDTO = new PrivilegeShareShortLinkDTO();
            privilegeShareShortLinkDTO.setId(privilegeDetailParam.getId());
            privilegeShareShortLinkDTO.setUserId(privilegeDetailParam.getUserId());
            String name = "\u6e38\u5ba2";
            if (user != null) {
                if (StringUtils.isNotEmpty((CharSequence)user.getNickname())) {
                    name = user.getNickname();
                } else if (StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
                    name = user.getPhone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
                }
            }
            privilegeShareShortLinkDTO.setUserName(name);
            privilegeShareShortLinkDTO.setUserUrl(StringUtils.isEmpty((CharSequence)(user == null ? null : user.getHeadImg())) ? DEFAULT_HEAD_PNG : user.getHeadImg());
            privilegeDTO.setShortLink(this.shortLinkService.getPrivilegeShareShortLink(privilegeShareShortLinkDTO));
        }
        if (StringUtils.isEmpty((CharSequence)privilegeDetailParam.getAreaCode())) {
            privilegeDTO.setBarcode(BARCODE_PNG);
            privilegeDTO.setBarcodeGif(BARCODE_GIF);
            privilegeDTO.setCountdown(Long.valueOf(36000000L));
            Date date = new Date();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            ((Calendar)calendar).add(5, 1);
            date = calendar.getTime();
            privilegeDTO.setEndTime(date);
            KeyGenerator inviteNumRedisKey = RedisConfig.PRIVILEGE_INVITENUM.copy().appendKey((Object)privilegeDetailParam.getId());
            Set inviteUserIds = this.redisZSetAdapter.range(inviteNumRedisKey, 0L, 2L, true, Long.class);
            ArrayList<LeaderboardDTO> leaderboardDTOS = new ArrayList<LeaderboardDTO>();
            for (Long inviteUserId : inviteUserIds) {
                LeaderboardDTO leaderboardDTO = new LeaderboardDTO();
                UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(inviteUserId);
                String nickname = userInfoDTO.getNickname();
                if (StringUtils.isEmpty((CharSequence)nickname)) {
                    nickname = userInfoDTO.getPhone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
                }
                leaderboardDTO.setNickname(nickname);
                leaderboardDTO.setUserId(inviteUserId);
                leaderboardDTO.setHeadImg(StringUtils.isEmpty((CharSequence)userInfoDTO.getHeadImg()) ? DEFAULT_HEAD_PNG : userInfoDTO.getHeadImg());
                leaderboardDTO.setInviteNum(Long.valueOf(this.redisZSetAdapter.score(inviteNumRedisKey, (Object)inviteUserId).longValue()));
                leaderboardDTOS.add(leaderboardDTO);
            }
            privilegeDTO.setLeaderboardDTOS(leaderboardDTOS);
            if (privilegeDetailParam.getUserId() != null) {
                privilegeDTO.setParticipated(Boolean.valueOf(this.privilegeParticipantMapper.getPrivilegeParticipant(privilegeDetailParam.getUserId(), privilegeDetailParam.getId()) != null));
            }
            privilegeDTO.setAreaCodeList(this.privilegeAreaMapper.listPrivilegeAreaCode(privilegeDetailParam.getId()));
        }
        return privilegeDTO;
    }

    @Override
    public List<WinnerDTO> listWinnerByPrivilegeId(Long privilegeId, Long userId, boolean isDisplayCommodityCode) {
        List winnerDTOS = this.winnerMapper.listWinnerByPrivilegeId(privilegeId);
        for (WinnerDTO winnerDTO : winnerDTOS) {
            if (StringUtils.isEmpty((CharSequence)winnerDTO.getNickname())) {
                winnerDTO.setNickname(winnerDTO.getPhone());
            }
            if (StringUtils.isEmpty((CharSequence)winnerDTO.getHeadImg())) {
                winnerDTO.setHeadImg(DEFAULT_HEAD_PNG);
            }
            if (!isDisplayCommodityCode) {
                winnerDTO.setCommodityCode(null);
            } else if (userId == null) {
                winnerDTO.setCommodityCode(null);
            } else if (!winnerDTO.getUserId().equals(userId)) {
                winnerDTO.setCommodityCode(null);
            }
            if (winnerDTO.getPopup() != 1 || winnerDTO.getCommodityCode() == null) continue;
            this.winnerMapper.updateWinnerPopup(winnerDTO.getId());
        }
        return winnerDTOS;
    }

    @Override
    public PrivilegeDTO getPrivilegeDetail(Long id, Long userId, Long inviteUserId) {
        return null;
    }

    @Override
    public Coordinate getUserCoordinate(PrivilegeParam privilegeParam) {
        Double longitude = privilegeParam.getLongitude();
        Double latitude = privilegeParam.getLatitude();
        if (null == longitude || null == latitude) {
            return null;
        }
        Coordinate userLngAndLat = new Coordinate();
        userLngAndLat.setLongitude(longitude);
        userLngAndLat.setLatitude(latitude);
        return userLngAndLat;
    }

    private void distanceCalculation(Coordinate userLngAndLat, List<PrivilegeListDTO> privilegeListDTOS) {
        if (null != userLngAndLat) {
            for (PrivilegeListDTO privilegeListDTO : privilegeListDTOS) {
                Coordinate merchantLngAndLat = new Coordinate();
                if (privilegeListDTO.getGeoLng() == null || privilegeListDTO.getGeoLat() == null) continue;
                merchantLngAndLat.setLongitude(privilegeListDTO.getGeoLng());
                merchantLngAndLat.setLatitude(privilegeListDTO.getGeoLat());
                Long distance = this.geoService.getDistance(userLngAndLat, merchantLngAndLat);
                String townName = privilegeListDTO.getTownName();
                String distancePreStr = "";
                if (!StringUtils.isEmpty((CharSequence)townName)) {
                    distancePreStr = "";
                }
                privilegeListDTO.setDistance(distancePreStr + (double)Math.round((double)distance.longValue() / 100.0) / 10.0 + "km");
                privilegeListDTO.setDistanceNum(distance);
            }
        }
    }

    private void distanceCalculation(Coordinate userLngAndLat, PrivilegeDTO privilegeListDTO) {
        if (null != userLngAndLat) {
            Coordinate merchantLngAndLat = new Coordinate();
            if (privilegeListDTO.getGeoLng() != null && privilegeListDTO.getGeoLat() != null) {
                merchantLngAndLat.setLongitude(privilegeListDTO.getGeoLng());
                merchantLngAndLat.setLatitude(privilegeListDTO.getGeoLat());
                Long distance = this.geoService.getDistance(userLngAndLat, merchantLngAndLat);
                String distancePreStr = "\u8ddd\u60a8";
                privilegeListDTO.setDistance(distancePreStr + (double)Math.round((double)distance.longValue() / 100.0) / 10.0 + "km");
            }
        }
    }

    private void fillingPrivilegeCountDown(List<PrivilegeListDTO> privilegeListDTOS) {
        Long currentTime = System.currentTimeMillis();
        for (PrivilegeListDTO privilegeListDTO : privilegeListDTOS) {
            if (PrivilegeStatusEnum.WAIT_TO_START != PrivilegeStatusEnum.getEnumByStatus((Integer)privilegeListDTO.getStatus())) continue;
            privilegeListDTO.setCountdown(this.getPrivilegeUnStartContent(currentTime, privilegeListDTO.getStartTime()));
        }
    }

    private String getPrivilegeUnStartContent(Long currentTime, Date privilegeStartDate) {
        Long waitTime = privilegeStartDate.getTime() - currentTime;
        Long oneDay = 86400000L;
        Long oneHour = 3600000L;
        Long oneMinute = 60000L;
        Long oneSecond = 1000L;
        if (waitTime.compareTo(oneDay) >= 0) {
            long dayNum = Math.round((double)waitTime.longValue() / (double)oneDay.longValue());
            return dayNum + "\u5929\u540e\u5f00\u59cb";
        }
        if (waitTime.compareTo(oneDay) < 0 && waitTime.compareTo(oneHour) >= 0) {
            long hourNum = Math.round((double)waitTime.longValue() / (double)oneHour.longValue());
            return hourNum + "\u5c0f\u65f6\u540e\u5f00\u59cb";
        }
        if (waitTime.compareTo(oneHour) < 0 && waitTime.compareTo(oneMinute) >= 0) {
            long minuteNum = Math.round((double)waitTime.longValue() / (double)oneMinute.longValue());
            return minuteNum + "\u5206\u949f\u540e\u5f00\u59cb";
        }
        if (waitTime.compareTo(oneMinute) < 0 && waitTime.compareTo(oneSecond) >= 0) {
            long secondNum = Math.round((double)waitTime.longValue() / (double)oneSecond.longValue());
            return secondNum + "\u79d2\u540e\u5f00\u59cb";
        }
        return null;
    }
}

