/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.activity.common.config.SignProperties;
import com.bxm.localnews.activity.domain.SignConfigMapper;
import com.bxm.localnews.activity.domain.SignRecordMapper;
import com.bxm.localnews.activity.dto.SignLeaderBoard;
import com.bxm.localnews.activity.dto.SignWarper;
import com.bxm.localnews.activity.service.SignFacadeService;
import com.bxm.localnews.activity.vo.SignConfig;
import com.bxm.localnews.activity.vo.SignRecord;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.vo.Location;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.PushMsgIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.stereotype.Service;

@Service
public class SignServiceImpl
extends BaseService
implements SignFacadeService {
    private static final Logger logger = LoggerFactory.getLogger(SignServiceImpl.class);
    private static final int EXPIRE_TIME = 172800;
    private static final int SIGN_LIST_LENGTH = 8;
    @Resource
    private SignConfigMapper signConfigMapper;
    @Resource
    private SignRecordMapper signRecordMapper;
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisZSetAdapter redisZSetAdapter;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Resource
    private LocationFacadeService locationFacadeService;
    @Resource
    private SignProperties signProperties;

    public SignWarper listSignRecord(Long userId, int platform) {
        SignWarper warper = new SignWarper();
        Date today = new Date();
        List<SignRecord> signRecords = this.buildSignList(0, today, userId, true);
        warper.setAutoSign(true);
        warper.setTodaySignState(true);
        warper.setSignReward(Long.valueOf(0L));
        warper.setTotalGold(BigDecimal.valueOf(this.userAccountIntegrationService.getUserUsableGold(userId).intValue()));
        warper.setRecords(signRecords);
        warper.setCount((long)this.getSignCount(userId));
        return warper;
    }

    private KeyGenerator getSignCountKey(Long userId) {
        return RedisConfig.SIGN_COUNT_KEY.copy().appendKey((Object)userId.toString());
    }

    private KeyGenerator getSignListKey(Long userId) {
        return RedisConfig.SIGN_LIST_KEY.copy().appendKey((Object)userId.toString());
    }

    private int getSignCount(Long userId) {
        Integer count = this.redisStringAdapter.getInt(this.getSignCountKey(userId));
        return count == null ? 1 : count;
    }

    private List<SignRecord> buildSignList(int startIndex, Date startDate, Long userId, boolean newList) {
        ArrayList records = Lists.newArrayList();
        List<SignConfig> signConfigs = this.getSignConfigInfo();
        int startNum = startIndex > 8 ? (startIndex - 1) / 8 * 8 : 0;
        int actualStartIndex = startIndex % 8;
        if (startIndex > 0 && actualStartIndex == 0) {
            actualStartIndex = 8;
        } else if (startIndex == 0) {
            actualStartIndex = 1;
        }
        for (int i = 0; i < 8; ++i) {
            SignRecord record = new SignRecord();
            int signDay = i + 1 + startNum;
            record.setSignDay(Integer.valueOf(signDay));
            if (startIndex == 0) {
                record.setSignDate(DateUtils.addField((Date)startDate, (int)5, (int)i));
            } else {
                record.setSignDate(DateUtils.addField((Date)startDate, (int)5, (int)(i + 1 - actualStartIndex)));
            }
            if (newList) {
                record.setSignFlag(Boolean.valueOf(false));
            } else {
                record.setSignFlag(Boolean.valueOf(startIndex >= signDay));
            }
            if (signDay >= 8) {
                record.setSignReward(signConfigs.get(7).getReward());
            } else {
                record.setSignReward(signConfigs.get(i).getReward());
            }
            records.add(record);
        }
        this.redisStringAdapter.set(this.getSignListKey(userId), (Object)records, 172800L);
        return records;
    }

    public List<SignConfig> getSignConfigInfo() {
        TypeReference<List<SignConfig>> typeReference = new TypeReference<List<SignConfig>>(){};
        List redisRet = (List)this.redisStringAdapter.get(RedisConfig.SIGN_CACHE_KEY, (TypeReference)typeReference);
        if (CollectionUtils.isNotEmpty((Collection)redisRet)) {
            return redisRet;
        }
        List list = this.signConfigMapper.listAll();
        this.redisStringAdapter.set(RedisConfig.SIGN_CACHE_KEY, (Object)list, 604800L);
        return list;
    }

    public void syncSignRanking() {
        String tableName = "b_sign_record_";
        ArrayList signRecordList = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            signRecordList.addAll(this.signRecordMapper.listSignRecordByUser(tableName + i));
        }
        Map<String, List<SignRecord>> signRecordMap = signRecordList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getAreaCode())).collect(Collectors.groupingBy(SignRecord::getAreaCode));
        signRecordMap.forEach((k, v) -> {
            v = v.stream().sorted(Comparator.comparing(SignRecord::getSignDay).reversed()).collect(Collectors.toList());
            logger.info("\u626b\u63cf\u5404\u5730\u533a\u6392\u884c\u699c\u4fe1\u606f->[{}]\u8be5\u5730\u533a\u7b7e\u5230\u699c\u4fe1\u606f:[{}]", k, (Object)JSONObject.toJSONString(v));
            LocationDetailDTO locationOptional = this.locationFacadeService.getLocationDetailByCode(k);
            if (null != locationOptional) {
                if (!this.checkEnableSignBoard(locationOptional)) {
                    if (this.checkIsSatisfiedEnableSignBoard((List<SignRecord>)v)) {
                        Location location = new Location();
                        location.setEnableSignBoard(Integer.valueOf(1));
                        location.setCode(locationOptional.getCode());
                        this.locationFacadeService.update(location);
                    } else {
                        return;
                    }
                }
                KeyGenerator signRecordKey = RedisConfig.SIGN_RANKING_KEY.copy().appendKey(k);
                HashSet tuples = new HashSet();
                v.forEach(x -> {
                    SignLeaderBoard.LeaderBoard leaderBoard = new SignLeaderBoard.LeaderBoard();
                    UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(x.getUserId());
                    if (null != userInfoDTO) {
                        leaderBoard.setNickname(userInfoDTO.getNickname() == null ? "" : userInfoDTO.getNickname()).setHeadImg(StringUtils.isEmpty((CharSequence)userInfoDTO.getHeadImg()) ? this.userIntegrationService.getDefaultHeadImgUrl() : userInfoDTO.getHeadImg()).setUserId(x.getUserId()).setCount(x.getSignDay());
                        DefaultTypedTuple tuple = new DefaultTypedTuple((Object)leaderBoard, Double.valueOf(leaderBoard.getCount().intValue()));
                        tuples.add(tuple);
                    }
                });
                this.redisZSetAdapter.remove(signRecordKey);
                this.redisZSetAdapter.add(signRecordKey, tuples);
            }
        });
    }

    private boolean checkEnableSignBoard(LocationDetailDTO locationOptional) {
        return null != locationOptional.getEnableSignBoard() && 1 == locationOptional.getEnableSignBoard();
    }

    private boolean checkIsSatisfiedEnableSignBoard(List<SignRecord> signRecordList) {
        return signRecordList.size() >= this.signProperties.getOpenDemandSize() && signRecordList.get(this.signProperties.getOpenDemandSize() - 1).getSignDay() >= this.signProperties.getOpenMinRequirement();
    }

    public void noticeUserSign() {
        Date date = new Date();
        String today = DateUtils.formatDate((Date)date);
        String yesterday = DateUtils.formatDate((Date)DateUtils.addField((Date)date, (int)5, (int)-1));
        KeyGenerator signRecordKey = RedisConfig.SIGN_NOTIFICATION_KEY.copy().appendKey((Object)today);
        KeyGenerator yesterdaySignRecordKey = RedisConfig.SIGN_NOTIFICATION_KEY.copy().appendKey((Object)yesterday);
        Set userIdSet = this.redisSetAdapter.difference(yesterdaySignRecordKey, Long.class, new KeyGenerator[]{signRecordKey});
        this.pushMsgIntegrationService.pushSignNotificationMsg(userIdSet);
    }
}

