/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.activity.common.config.VipRankProperties;
import com.bxm.localnews.activity.common.config.WechatCustomerServiceProperties;
import com.bxm.localnews.activity.common.constant.VipStatusEnum;
import com.bxm.localnews.activity.domain.VipMapper;
import com.bxm.localnews.activity.domain.VipViewRecordMapper;
import com.bxm.localnews.activity.dto.CustomerServiceDTO;
import com.bxm.localnews.activity.dto.NoticeDTO;
import com.bxm.localnews.activity.dto.UserSuccessFriendDTO;
import com.bxm.localnews.activity.dto.UserVipInfoDTO;
import com.bxm.localnews.activity.dto.WechatUserInfoDTO;
import com.bxm.localnews.activity.dto.WechatVipInfoDTO;
import com.bxm.localnews.activity.param.RecordWechatParam;
import com.bxm.localnews.activity.service.MovieService;
import com.bxm.localnews.activity.service.VipFacadeService;
import com.bxm.localnews.activity.service.VipService;
import com.bxm.localnews.activity.vo.Vip;
import com.bxm.localnews.activity.vo.VipViewRecord;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.PushMsgIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class VipServiceImpl
extends BaseService
implements VipService,
VipFacadeService {
    @Resource
    private WechatCustomerServiceProperties wechatCustomerServiceProperties;
    @Resource
    private VipRankProperties vipRankProperties;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private VipMapper vipMapper;
    @Resource
    private VipViewRecordMapper vipViewRecordMapper;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private LocationFacadeService locationFacadeService;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Resource
    private MovieService movieService;
    @Resource
    private BizLogService bizLogService;
    @Resource
    private DistributedLock distributedLock;

    public Message saveVipViewRecord(Long userId, String unionId, Integer platform) {
        this.confirmUserRelation(unionId, userId, platform);
        this.updateUserVip(userId, unionId);
        this.updateVipViewRecord(unionId);
        return Message.build();
    }

    public Long addUserVipByPay(Long userId) {
        Vip vip = this.vipMapper.selectVipByUser(userId, null);
        Boolean isUpdate = Boolean.FALSE;
        if (vip == null) {
            isUpdate = Boolean.TRUE;
            User user = this.userIntegrationService.selectByPrimaryKey(userId);
            vip = this.generateVip(this.userIntegrationService.getLocationByUser(user).getCode(), user.getWeixin(), userId);
        }
        if (VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus())) {
            return null;
        }
        vip.setSource(Byte.valueOf((byte)2));
        Date now = new Date();
        vip.setModifyTime(now);
        vip.setActivationDate(now);
        vip.setExpiredDate(DateUtils.addField((Date)now, (int)1, (int)1));
        vip.setStatus(VipStatusEnum.ACTIVATED.getType());
        vip.setShowGuide(Byte.valueOf((byte)1));
        if (isUpdate.booleanValue()) {
            this.saveUserVip(vip);
        } else {
            this.vipMapper.updateUserVip(vip);
        }
        this.logger.info("\u7528\u6237[{}]\u8d2d\u4e70vip\u6210\u529f", (Object)userId);
        this.movieService.doGeneratorMovie(userId, vip.getActivationAreaCode());
        this.bizLogService.buyVip(userId);
        this.pushMsgIntegrationService.pushActivationVipSuccessMessage(userId);
        this.removeUserLayer(vip.getUserId());
        return vip.getId();
    }

    public Message updateVipViewRecord(String unionId) {
        this.vipViewRecordMapper.updateViewRecordByUser(unionId);
        return Message.build();
    }

    public Integer countVipByUser(Long userId) {
        return this.vipMapper.countVipByUser(userId);
    }

    @Override
    public WechatVipInfoDTO addWechatUserVip(String areaCode, String wechatUid, String wechatName, String wechatImg) {
        Vip vip = this.vipMapper.selectVipByUser(null, wechatUid);
        if (vip == null) {
            vip = this.generateVip(areaCode, wechatUid, null);
            this.saveUserVip(vip);
            this.saveUserToCache(wechatName, wechatImg);
        } else if (!this.redisStringAdapter.hasKey(this.getUserReceiveVipKey(vip.getWechatUid())).booleanValue()) {
            Date now = new Date();
            Long time = DateUtils.addField((Date)now, (int)12, (int)30).getTime();
            this.redisStringAdapter.set(this.getUserReceiveVipKey(vip.getWechatUid()), (Object)time.toString(), 1800L);
        }
        return this.convertVip(vip, areaCode);
    }

    private void saveUserVip(Vip vip) {
        String randomId = this.sequenceCreater.nextStringId();
        if (this.distributedLock.lock(vip.getWechatUid(), randomId, 1L, TimeUnit.SECONDS) && this.vipMapper.selectVipByUser(null, vip.getWechatUid()) == null) {
            this.vipMapper.insertSelective(vip);
        }
    }

    @Override
    public UserSuccessFriendDTO getSuccessFriend(Long userId) {
        UserSuccessFriendDTO userSuccessFriendDTO = new UserSuccessFriendDTO();
        List<WechatUserInfoDTO> list = this.getWechatUserList(userId, (byte)1, null);
        userSuccessFriendDTO.setHelpFriendList(list);
        Vip vip = this.vipMapper.selectVipByUser(userId, null);
        if (null == vip) {
            vip = new Vip();
        }
        if (null == vip.getInvitedCount()) {
            vip.setInvitedCount(Integer.valueOf(3));
        }
        userSuccessFriendDTO.setInvitedCount(Long.valueOf(vip.getInvitedCount().intValue()));
        if (CollectionUtils.isNotEmpty(list) && list.size() > vip.getInvitedCount()) {
            ArrayList userInfoDTOList = Lists.newArrayList();
            int i = 0;
            while ((long)i < userSuccessFriendDTO.getInvitedCount()) {
                userInfoDTOList.add(list.get(i));
                ++i;
            }
            userSuccessFriendDTO.setHelpFriendList((List)userInfoDTOList);
        }
        List<WechatUserInfoDTO> viewList = this.getWechatUserList(userId, null, (byte)1);
        userSuccessFriendDTO.setViewCount(Long.valueOf(viewList.size()));
        return userSuccessFriendDTO;
    }

    @Override
    public List<WechatUserInfoDTO> getInviteFriendRecord(Long userId) {
        return this.getWechatUserList(userId, null, (byte)1);
    }

    @Override
    public Message addViewRecord(RecordWechatParam recordWechatParam) {
        Message message = Message.build();
        this.logger.debug("\u6dfb\u52a0vip\u67e5\u770b\u8bb0\u5f55, \u9080\u8bf7\u4eba\uff1a[{}], \u53d7\u9080\u4eba[{}]", (Object)recordWechatParam.getUserId(), (Object)recordWechatParam.getWechatUid());
        VipViewRecord vipViewRecord = this.vipViewRecordMapper.getViewRecordByUserAndWechatUid(recordWechatParam);
        if (vipViewRecord != null) {
            this.logger.debug("\u9080\u8bf7\u8bb0\u5f55\u5df2\u5b58\u5728: \u6570\u636e\uff1a[{}]", (Object)JSON.toJSONString((Object)vipViewRecord));
            if (vipViewRecord.getDisplayFlag() == 0) {
                return message;
            }
            vipViewRecord.setViewTime(new Date());
            this.vipViewRecordMapper.updateByPrimaryKey(vipViewRecord);
            return message;
        }
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(recordWechatParam.getUserId());
        if (recordWechatParam.getWechatUid().equals(userInfoDTO.getWeixin())) {
            this.logger.debug("\u672c\u4eba\u67e5\u770b\u4e0d\u8bb0\u5f55");
            return message;
        }
        if (StringUtils.isEmpty((CharSequence)recordWechatParam.getWechatImg())) {
            recordWechatParam.setWechatImg(this.userIntegrationService.getDefaultHeadImgUrl());
        }
        VipViewRecord viewRecord = new VipViewRecord();
        viewRecord.setId(this.sequenceCreater.nextLongId());
        BeanUtils.copyProperties((Object)recordWechatParam, (Object)viewRecord);
        viewRecord.setDisplayFlag(Byte.valueOf((byte)1));
        viewRecord.setViewTime(new Date());
        this.vipViewRecordMapper.insertSelective(viewRecord);
        return Message.build();
    }

    @Override
    public CustomerServiceDTO getCustomerService() {
        CustomerServiceDTO customerServiceDTO = new CustomerServiceDTO();
        customerServiceDTO.setCustomerServiceName(this.wechatCustomerServiceProperties.getCustomerServiceName());
        customerServiceDTO.setCustomerServiceImg(this.wechatCustomerServiceProperties.getCustomerServiceImg());
        return customerServiceDTO;
    }

    @Override
    public Message modifyUserGuid(Long userId) {
        this.vipMapper.updateUserGuide(userId);
        return Message.build();
    }

    @Override
    public UserVipInfoDTO modifyAndGetUserVip(Long userId, String areaCode) {
        UserInfoDTO userInfoDTO;
        Vip vip = this.vipMapper.selectVipByUser(userId, null);
        if (vip == null) {
            userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
            if (StringUtils.isNotEmpty((CharSequence)userInfoDTO.getWeixin())) {
                vip = this.vipMapper.selectVipByUser(null, userInfoDTO.getWeixin());
                if (vip == null) {
                    vip = this.generateVip(areaCode, userInfoDTO.getWeixin(), userId);
                    this.saveUserVip(vip);
                }
            } else {
                vip = this.generateVip(areaCode, null, userId);
            }
        }
        if (StringUtils.isEmpty((CharSequence)vip.getWechatUid()) && StringUtils.isNotEmpty((CharSequence)(userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId)).getWeixin())) {
            vip.setWechatUid(userInfoDTO.getWeixin());
            this.vipMapper.updateUserVip(vip);
        }
        if (vip.getUserId() == null) {
            this.updateUserVip(userId, vip.getWechatUid());
        }
        return this.convertUserVip(vip);
    }

    @Override
    public boolean checkUserVip(Long userId) {
        Vip vip = this.vipMapper.selectVipByUser(userId, null);
        return null != vip && VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus());
    }

    @Override
    public WechatVipInfoDTO getWechatVip(String unionId, String areaCode) {
        Vip vip = this.vipMapper.selectVipByUser(null, unionId);
        return this.convertVip(vip, areaCode);
    }

    @Override
    public List<WechatUserInfoDTO> getVipRank() {
        return new ArrayList<WechatUserInfoDTO>(this.getUserVipRank());
    }

    @Override
    public Message modifyUserShowLayer(Long userId) {
        this.redisStringAdapter.set(this.getUserShowLayerKey(userId), 1L);
        return Message.build();
    }

    @Override
    public Vip getVipByUser(Long userId) {
        return this.vipMapper.selectVipByUser(userId, null);
    }

    @Override
    public List<WechatUserInfoDTO> getAllSuccessWechatUserList(Long userId) {
        return this.getWechatUserList(userId, (byte)1, null);
    }

    private WechatVipInfoDTO convertVip(Vip vip, String areaCode) {
        LocationDetailDTO locationDetailDTO;
        WechatVipInfoDTO wechatVipInfoDTO = new WechatVipInfoDTO();
        if (vip == null) {
            wechatVipInfoDTO.setActivationVip(VipStatusEnum.RECEIVE_NOT_LOGIN.getType());
            return wechatVipInfoDTO;
        }
        wechatVipInfoDTO.setNum(vip.getNum());
        wechatVipInfoDTO.setSource(vip.getSource());
        if (vip.getUserId() == null) {
            wechatVipInfoDTO.setActivationVip(VipStatusEnum.RECEIVE_NOT_LOGIN.getType());
            if (this.redisStringAdapter.hasKey(this.getUserReceiveVipKey(vip.getWechatUid())).booleanValue()) {
                wechatVipInfoDTO.setRemainDate(this.redisStringAdapter.getLong(this.getUserReceiveVipKey(vip.getWechatUid())));
            }
        }
        if ((locationDetailDTO = this.locationFacadeService.getLocationDetailByCode(areaCode)) != null) {
            wechatVipInfoDTO.setApplyArea(locationDetailDTO.getFullName());
            wechatVipInfoDTO.setAreaName(locationDetailDTO.getName());
        }
        if (vip.getUserId() != null) {
            wechatVipInfoDTO.setActivationVip(vip.getStatus());
        }
        return wechatVipInfoDTO;
    }

    private UserVipInfoDTO convertUserVip(Vip vip) {
        List<WechatUserInfoDTO> list;
        LocationDetailDTO locationIntegrationDetailDTO;
        UserInfoDTO userInfoDTO;
        UserVipInfoDTO userVipInfoDTO = new UserVipInfoDTO();
        userVipInfoDTO.setNum(vip.getNum());
        userVipInfoDTO.setInvitedCount(Long.valueOf(vip.getInvitedCount() == null ? 3L : Long.valueOf(vip.getInvitedCount().intValue())));
        userVipInfoDTO.setShowGuide(vip.getShowGuide());
        userVipInfoDTO.setActivationVip(vip.getStatus());
        userVipInfoDTO.setSource(vip.getSource());
        if (VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus())) {
            NoticeDTO notice;
            Date now = new Date();
            Integer remainDay = DateUtils.getDiffDays((Date)vip.getExpiredDate(), (Date)now, (boolean)Boolean.FALSE);
            if (remainDay <= 0) {
                remainDay = -1;
            }
            if (remainDay > 0 && null != (notice = this.movieService.getMovieVipNotice(vip.getUserId()))) {
                userVipInfoDTO.setNotice(notice);
            }
            userVipInfoDTO.setRemainDay(Long.valueOf(remainDay + 1));
            userVipInfoDTO.setActivationStatus(Byte.valueOf((byte)2));
        }
        if ((userInfoDTO = this.userIntegrationService.getUserFromRedisDB(vip.getUserId())) != null) {
            WechatUserInfoDTO wechatUserInfoDTO = new WechatUserInfoDTO();
            wechatUserInfoDTO.setWechatName(userInfoDTO.getNickname());
            wechatUserInfoDTO.setWechatImg(userInfoDTO.getHeadImg());
            userVipInfoDTO.setWechatUserInfoDTO(wechatUserInfoDTO);
        }
        if ((locationIntegrationDetailDTO = this.userIntegrationService.getLocationByUser(this.userIntegrationService.selectByPrimaryKey(vip.getUserId()))) != null) {
            userVipInfoDTO.setAreaName(locationIntegrationDetailDTO.getName());
            userVipInfoDTO.setApplyArea(locationIntegrationDetailDTO.getFullName());
            userVipInfoDTO.setReductionAmount(locationIntegrationDetailDTO.getReductionAmount());
        }
        if (!VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus())) {
            List<WechatUserInfoDTO> recordList;
            userVipInfoDTO.setShowLayer(this.getUserShowLayer(vip.getUserId(), vip.getStatus()));
            if (userVipInfoDTO.getShowLayer() == 1) {
                list = this.getWechatUserList(vip.getUserId(), (byte)1, null);
                userVipInfoDTO.setHelpFriendList(list);
                if (CollectionUtils.isEmpty(list)) {
                    userVipInfoDTO.setShowLayer(Byte.valueOf((byte)0));
                }
                if (CollectionUtils.isNotEmpty(list) && list.size() < vip.getInvitedCount()) {
                    userVipInfoDTO.setShowLayer(this.expireUserShowLayer(vip.getUserId()));
                }
            }
            if (CollectionUtils.isEmpty(recordList = this.getWechatUserList(vip.getUserId(), null, null))) {
                userVipInfoDTO.setActivationStatus(Byte.valueOf((byte)0));
            } else {
                userVipInfoDTO.setActivationStatus(Byte.valueOf((byte)1));
            }
        }
        if (userVipInfoDTO.getShowGuide() == 1) {
            list = this.getWechatUserList(vip.getUserId(), (byte)1, null);
            userVipInfoDTO.setHelpFriendList(list);
        }
        if (VipStatusEnum.ACTIVATED.getType().equals(vip.getStatus())) {
            userVipInfoDTO.setShowLayer(Byte.valueOf((byte)0));
        }
        return userVipInfoDTO;
    }

    private Vip generateVip(String areaCode, String wechatUid, Long userId) {
        LocationDetailDTO locationDTO;
        Vip vip = new Vip();
        vip.setId(this.sequenceCreater.nextLongId());
        vip.setNum(this.generateVipNum());
        if (userId != null) {
            vip.setUserId(userId);
        }
        if ((locationDTO = this.locationFacadeService.getLocationDetailByCode(areaCode)) == null || locationDTO.getInvitedCount() == null) {
            locationDTO = this.locationFacadeService.getAcitivateVipLocation();
            this.logger.error("\u7528\u6237id:{},\u7528\u6237\u5fae\u4fe1:{},\u5f53\u524d\u5730\u533a:{},\u7ecf\u68c0\u6d4b\u5e76\u65e0\u5f00\u901aVIP,\u5730\u533a\u8f6c\u6362\u4e3a:{}", new Object[]{userId, wechatUid, areaCode, locationDTO.getName()});
        }
        vip.setActivationAreaCode(locationDTO.getCode());
        vip.setInvitedCount(locationDTO.getInvitedCount());
        vip.setWechatUid(wechatUid);
        Date now = new Date();
        vip.setCreateTime(now);
        vip.setWechatUid(wechatUid);
        vip.setSource(Byte.valueOf((byte)1));
        vip.setStatus(VipStatusEnum.INACTIVATE.getType());
        vip.setShowGuide(Byte.valueOf((byte)0));
        Long time = DateUtils.addField((Date)now, (int)12, (int)30).getTime();
        if (StringUtils.isNotEmpty((CharSequence)wechatUid)) {
            this.redisStringAdapter.set(this.getUserReceiveVipKey(wechatUid), (Object)time.toString(), 1800L);
        }
        return vip;
    }

    private String generateVipNum() {
        Set set = this.redisSetAdapter.getAllMembers(this.getUserVipNumKey(), Integer.class);
        Integer num = this.getRandomIntInRangeWithExclude(10000000, 99999999, set);
        this.redisSetAdapter.add(this.getUserVipNumKey(), new Object[]{num});
        return String.valueOf(num);
    }

    private WechatUserInfoDTO convertVipViewRecord(VipViewRecord vipViewRecord) {
        WechatUserInfoDTO wechatUserInfoDTO = new WechatUserInfoDTO();
        wechatUserInfoDTO.setWechatImg(vipViewRecord.getWechatImg());
        wechatUserInfoDTO.setWechatName(vipViewRecord.getWechatName());
        return wechatUserInfoDTO;
    }

    private List<WechatUserInfoDTO> getWechatUserList(Long userId, Byte checked, Byte displayFlag) {
        List vipViewRecordList = this.vipViewRecordMapper.selectVipRecordList(userId, checked, displayFlag);
        return vipViewRecordList.stream().map(this::convertVipViewRecord).collect(Collectors.toList());
    }

    private KeyGenerator getUserVipRankKey() {
        return RedisConfig.USER_VIP_RANK.copy();
    }

    private KeyGenerator getUserVipRankImgKey() {
        return RedisConfig.USER_VIP_RANK_IMG.copy();
    }

    private KeyGenerator getUserVipNumKey() {
        return RedisConfig.USER_VIP_NUM_RECORD.copy();
    }

    private KeyGenerator getUserLayerExpireTimeKey(Long userId) {
        return RedisConfig.USER_LAYER_EXPIRE_TIME.copy().appendKey((Object)userId);
    }

    private KeyGenerator getUserReceiveVipKey(String wechatUid) {
        return RedisConfig.USER_RECEIVE_VIP_TIME.copy().appendKey((Object)wechatUid);
    }

    private KeyGenerator getUserShowLayerKey(Long userId) {
        return RedisConfig.USER_SHOW_LAYER.copy().appendKey((Object)userId);
    }

    private Integer getRandomIntInRangeWithExclude(int min, int max, Set<Integer> exclude) {
        Random random = new Random();
        return random.ints(min, max + 1).filter(r -> !exclude.contains(r)).limit(1L).findFirst().getAsInt();
    }

    private Set<String> getUserVipRankByCache() {
        HashSet set = Sets.newHashSet();
        if (this.redisSetAdapter.hasKey(this.getUserVipRankKey()).booleanValue()) {
            set = this.redisSetAdapter.getAllMembers(this.getUserVipRankKey(), String.class);
        }
        if (CollectionUtils.isEmpty((Collection)set)) {
            List list = this.vipRankProperties.getRank();
            set = new HashSet(list);
            Object[] objects = list.toArray();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.redisSetAdapter.add(this.getUserVipRankKey(), objects);
            }
        }
        return set;
    }

    private Set<WechatUserInfoDTO> getUserVipRank() {
        Set<Object> set = Sets.newHashSet();
        if (this.redisSetAdapter.hasKey(this.getUserVipRankKey()).booleanValue()) {
            TypeReference<WechatUserInfoDTO> wechatUserInfoDTOTypeReference = new TypeReference<WechatUserInfoDTO>(){};
            set = this.redisSetAdapter.getAllMembers(this.getUserVipRankKey(), (TypeReference)wechatUserInfoDTOTypeReference);
        }
        if (CollectionUtils.isEmpty((Collection)set)) {
            List list = this.vipRankProperties.getRank();
            List imgList = this.vipRankProperties.getRankImg();
            set = this.convertNameAndImg(list, imgList);
            Object[] objects = set.toArray();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.redisSetAdapter.add(this.getUserVipRankKey(), objects);
            }
        }
        return set;
    }

    private Set<WechatUserInfoDTO> convertNameAndImg(List<String> list, List<String> imgList) {
        HashSet wechatUserInfoDTOS = Sets.newHashSet();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            WechatUserInfoDTO wechatUserInfoDTO = new WechatUserInfoDTO();
            wechatUserInfoDTO.setWechatName(list.get(i));
            wechatUserInfoDTO.setWechatImg(imgList.get(i));
            wechatUserInfoDTOS.add(wechatUserInfoDTO);
        }
        return wechatUserInfoDTOS;
    }

    private void confirmUserRelation(String unionId, Long userId, Integer platform) {
        VipViewRecord vipViewRecord = this.vipViewRecordMapper.getCheckedByWechatUid(unionId);
        if (vipViewRecord != null) {
            return;
        }
        vipViewRecord = this.vipViewRecordMapper.getLastVipViewRecord(unionId);
        if (vipViewRecord == null) {
            return;
        }
        Date now = new Date();
        vipViewRecord.setCheckTime(now);
        vipViewRecord.setDisplayFlag(Byte.valueOf((byte)0));
        vipViewRecord.setChecked(Byte.valueOf((byte)1));
        this.vipViewRecordMapper.updateByPrimaryKey(vipViewRecord);
        this.logger.debug("\u786e\u8ba4vip\u9080\u8bf7\u5173\u7cfb\uff1a" + JSON.toJSONString((Object)vipViewRecord));
        Vip vip = this.vipMapper.selectVipByUser(vipViewRecord.getUserId(), null);
        if (vip == null) {
            return;
        }
        this.activationVip(vip, vipViewRecord.getWechatName(), platform);
        this.bizLogService.inviteVip(userId, platform);
    }

    private void activationVip(Vip vip, String wechatName, Integer platform) {
        if (!VipStatusEnum.INACTIVATE.getType().equals(vip.getStatus())) {
            return;
        }
        List<WechatUserInfoDTO> list = this.getWechatUserList(vip.getUserId(), (byte)1, null);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.redisStringAdapter.remove(this.getUserLayerExpireTimeKey(vip.getUserId()));
        if (list.size() < vip.getInvitedCount()) {
            this.pushMsgIntegrationService.pushHelpMessage(vip.getUserId(), wechatName, Integer.valueOf(vip.getInvitedCount() - list.size()));
        } else {
            Date now = new Date();
            vip.setModifyTime(now);
            vip.setActivationDate(now);
            vip.setExpiredDate(DateUtils.addField((Date)now, (int)1, (int)1));
            vip.setStatus(VipStatusEnum.ACTIVATED.getType());
            vip.setShowGuide(Byte.valueOf((byte)1));
            this.vipMapper.updateUserVip(vip);
            this.logger.debug("\u6fc0\u6d3b\u9080\u8bf7\u4ebavip\uff1a" + JSON.toJSONString((Object)vip));
            this.removeUserLayer(vip.getUserId());
            this.movieService.doGeneratorMovie(vip.getUserId(), vip.getActivationAreaCode());
            this.pushMsgIntegrationService.pushActivationVipSuccessMessage(vip.getUserId());
            this.bizLogService.activateVip(vip.getUserId(), platform);
        }
    }

    private void saveUserToCache(Long userId) {
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
        if (this.redisSetAdapter.size(this.getUserVipRankKey()) >= 20L) {
            this.redisSetAdapter.pop(this.getUserVipRankKey(), Long.valueOf(1L), String.class);
        }
        this.redisSetAdapter.add(this.getUserVipRankKey(), new Object[]{userInfoDTO.getNickname()});
    }

    private void saveUserToCache(String wechaName, String wechatImg) {
        TypeReference<WechatUserInfoDTO> wechatUserInfoDTOTypeReference = new TypeReference<WechatUserInfoDTO>(){};
        if (this.redisSetAdapter.size(this.getUserVipRankKey()) >= 50L) {
            this.redisSetAdapter.pop(this.getUserVipRankKey(), Long.valueOf(1L), (TypeReference)wechatUserInfoDTOTypeReference);
        }
        WechatUserInfoDTO wechatUserInfoDTO = new WechatUserInfoDTO();
        wechatUserInfoDTO.setWechatImg(wechatImg);
        wechatUserInfoDTO.setWechatName(wechaName);
        ArrayList wechatUserInfoDTOS = Lists.newArrayList((Object[])new WechatUserInfoDTO[]{wechatUserInfoDTO});
        this.redisSetAdapter.add(this.getUserVipRankKey(), wechatUserInfoDTOS.toArray());
    }

    private void updateUserVip(Long userId, String unionId) {
        Vip vip = this.vipMapper.selectVipByUser(null, unionId);
        if (vip == null || vip.getUserId() != null) {
            return;
        }
        vip.setUserId(userId);
        this.vipMapper.updateUserVip(vip);
    }

    private Byte getUserShowLayer(Long userId, Byte status) {
        Boolean isSuccessVip = VipStatusEnum.ACTIVATED.getType().equals(status);
        if (isSuccessVip.booleanValue()) {
            return (byte)0;
        }
        if (this.redisStringAdapter.hasKey(this.getUserShowLayerKey(userId)).booleanValue()) {
            return (byte)0;
        }
        return (byte)1;
    }

    private Byte expireUserShowLayer(Long userId) {
        if (this.redisStringAdapter.hasKey(this.getUserLayerExpireTimeKey(userId)).booleanValue()) {
            return (byte)0;
        }
        this.redisStringAdapter.set(this.getUserLayerExpireTimeKey(userId), (Object)DateUtils.getCurrentDateTime(), 86400L);
        return (byte)1;
    }

    private void removeUserLayer(Long userId) {
        this.redisStringAdapter.remove(this.getUserShowLayerKey(userId));
    }
}

