/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.common.utils.AmountUtil;
import com.bxm.localnews.activity.dto.ScoreDto;
import com.bxm.localnews.activity.service.redpacket.command.CommandGradeService;
import com.bxm.localnews.activity.service.redpacket.command.RecordGradeService;
import com.bxm.localnews.activity.vo.GradeResultBean;
import com.bxm.localnews.common.exception.BusinessException;
import java.io.File;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommandGradeServiceImpl
implements CommandGradeService {
    private static final Logger logger = LoggerFactory.getLogger(CommandGradeServiceImpl.class);
    @Autowired
    private RecordGradeService recordGradeService;

    @Override
    public ScoreDto grade(String target, String commandUrl, Integer length) {
        GradeResultBean bean;
        if (null == length) {
            length = -1;
        }
        if ((bean = this.recordGradeService.getByUrl(target, commandUrl, length)) == null) {
            throw new BusinessException("\u53e3\u4ee4\u8bc4\u5206\u5f02\u5e38");
        }
        return this.convertToScoreDto(bean, commandUrl, length);
    }

    @Override
    public ScoreDto grade(String target, String mediaId) {
        GradeResultBean bean = this.recordGradeService.getByWx(target, mediaId);
        if (bean == null) {
            throw new BusinessException("\u53e3\u4ee4\u8bc4\u5206\u5f02\u5e38");
        }
        return this.convertToScoreDto(bean, null, -1);
    }

    @Override
    public GradeResultBean testRecord(String content, String path, Integer len) {
        if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)path)) {
            logger.warn("\u53c2\u6570\u6709\u8bef\uff0ccontent:{},path:{}", (Object)content, (Object)path);
            return null;
        }
        File file = new File(path);
        return this.recordGradeService.getByLocal(content, file, null == len ? -1 : len);
    }

    private ScoreDto convertToScoreDto(GradeResultBean bean, String commandUrl, Integer length) {
        Integer score = AmountUtil.halfUptIntValue((BigDecimal)new BigDecimal(bean.calCompositeScore()));
        Integer matchScale = AmountUtil.halfUptIntValue((BigDecimal)new BigDecimal(bean.getMatchScore()));
        String userScale = "0%";
        if (score > 40) {
            userScale = AmountUtil.halfUptStringValue((BigDecimal)new BigDecimal(Math.ceil(70.0 + 29.0 * Math.sqrt(((double)score.intValue() - 40.0) / 60.0)))) + "%";
        }
        Integer star = this.getStarByScore(score);
        if (commandUrl == null) {
            commandUrl = bean.getOssUrl();
        }
        if (length == -1) {
            length = bean.getLength();
        }
        return new ScoreDto(commandUrl, score, length, matchScale, userScale, star);
    }

    private Integer getStarByScore(Integer score) {
        if (score >= 40 && score <= 59) {
            return 2;
        }
        if (score >= 60 && score <= 69) {
            return 3;
        }
        if (score >= 70 && score <= 89) {
            return 4;
        }
        if (score >= 90) {
            return 5;
        }
        return 0;
    }
}

