/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.common.config.CommandRedPacketProperties;
import com.bxm.localnews.activity.common.constant.PackTypeEnum;
import com.bxm.localnews.activity.common.constant.RedPacketObtainStatesEnum;
import com.bxm.localnews.activity.common.utils.AmountUtil;
import com.bxm.localnews.activity.domain.LotteryDrawMapper;
import com.bxm.localnews.activity.domain.RedPacketMapper;
import com.bxm.localnews.activity.dto.CommandResultDTO;
import com.bxm.localnews.activity.dto.ScoreDto;
import com.bxm.localnews.activity.dto.SubtractDTO;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketAmountService;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketObtainService;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketStateService;
import com.bxm.localnews.activity.vo.RedPacket;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.service.BaseService;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedPacketObtainServiceImpl
extends BaseService
implements RedPacketObtainService {
    private static final Logger logger = LoggerFactory.getLogger(RedPacketObtainServiceImpl.class);
    @Autowired
    private LotteryDrawMapper lotteryDrawMapper;
    @Autowired
    private LocationFacadeService locationFacadeService;
    @Autowired
    private RedPacketStateService redPacketStateService;
    @Autowired
    private CommandRedPacketProperties commandRedPacketProperties;
    @Autowired
    private RedPacketMapper redPacketMapper;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private RedPacketAmountService redPacketAmountService;

    @Override
    public CommandResultDTO obtainRedPacket(Long rpId, ScoreDto scoreDto, User user, Integer platform, Integer retryTime) {
        if (retryTime == 0) {
            logger.error("retry time is 0, rpid:[{}],userId:[{}]", (Object)rpId, (Object)user.getId());
            return new CommandResultDTO(RedPacketObtainStatesEnum.LESS40.getType());
        }
        String requestId = this.nextSequence().toString();
        if (!this.distributedLock.lock(rpId.toString(), requestId)) {
            logger.warn("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u91cd\u8bd5, rpid:[{}], retry time:[{}]", (Object)rpId, (Object)retryTime);
            retryTime = retryTime - 1;
            return this.obtainRedPacket(rpId, scoreDto, user, platform, retryTime);
        }
        RedPacket redPacket = this.redPacketMapper.queryOne(rpId);
        RedPacketObtainStatesEnum rpObtainState = this.redPacketStateService.rpStatesCheck(redPacket, user.getId());
        if (rpObtainState != null) {
            this.distributedLock.unlock(rpId.toString(), requestId);
            return new CommandResultDTO(rpObtainState.getType());
        }
        SubtractDTO subtractDTO = null;
        try {
            subtractDTO = this.redPacketAmountService.setSurplusAmount(redPacket, scoreDto, user, platform);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.distributedLock.unlock(rpId.toString(), requestId);
        if (null == subtractDTO || !subtractDTO.getSubtractSuccess().booleanValue()) {
            logger.warn("\u7ea2\u5305\u51cf\u6263\u5931\u8d25\u91cd\u8bd5, rpid:[{}], retry time:[{}], version:[{}]", new Object[]{rpId, retryTime, redPacket.getVersion()});
            retryTime = retryTime - 1;
            return this.obtainRedPacket(rpId, scoreDto, user, platform, retryTime);
        }
        return this.convertToCommandResultDTO(scoreDto, user, subtractDTO);
    }

    @Override
    public CommandResultDTO publicObtainRedPacket(Long rpId, Integer packetType, String city, String district, ScoreDto scoreDto, User user, Integer platform, Integer retryTime) {
        CommandResultDTO commandResultDTO = this.obtainRedPacket(rpId, scoreDto, user, platform, retryTime);
        commandResultDTO.setNewUserAmount(this.getNewUserRpAmount(city, district, packetType, user));
        return commandResultDTO;
    }

    @Override
    public String getNewUserRpAmount(String city, String district, Integer packetType, User user) {
        logger.info("getNewUserRpAmount ,city:[{}],district:[{}],packetType:[{}],receive:[{}],user state:[{}]", new Object[]{city, district, packetType, user.getReceiveRedPacket(), user.getState()});
        boolean isUnusable = !packetType.equals(PackTypeEnum.WALL.getType()) || user.getReceiveRedPacket() == 0 || user.getState() != 2;
        logger.info("isUnusable :[{}]", (Object)isUnusable);
        if (isUnusable) {
            return null;
        }
        String areaCode = this.getAreaCodeByCityName(city, district);
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return null;
        }
        LocationDetailDTO locationDetailDTO = this.locationFacadeService.getLocationDetailByCode(areaCode);
        if (null == locationDetailDTO) {
            return null;
        }
        return AmountUtil.halfUpScale2StringValue((BigDecimal)locationDetailDTO.getNewRedPacket());
    }

    private String getAreaCodeByCityName(String city, String district) {
        String areaCode = "";
        if (StringUtils.isNotBlank((CharSequence)district)) {
            areaCode = this.lotteryDrawMapper.getCodeByName(district);
        }
        if (StringUtils.isBlank((CharSequence)areaCode) && StringUtils.isNotBlank((CharSequence)city)) {
            areaCode = this.lotteryDrawMapper.getCodeByName(city);
        }
        return areaCode;
    }

    private CommandResultDTO convertToCommandResultDTO(ScoreDto scoreDto, User user, SubtractDTO subtractDTO) {
        CommandResultDTO commandResultDTO = new CommandResultDTO();
        commandResultDTO.setStatus(RedPacketObtainStatesEnum.SUCCESS.getType());
        commandResultDTO.setUserName(user.getNickname());
        commandResultDTO.setUserImg(user.getHeadImg());
        commandResultDTO.setScore(scoreDto.getScore());
        commandResultDTO.setStar(scoreDto.getStar());
        commandResultDTO.setUserScale(scoreDto.getUserScale());
        commandResultDTO.setMatchScale(scoreDto.getMatchScale());
        commandResultDTO.setUserObtainAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)subtractDTO.getActualAmount()));
        commandResultDTO.setNewUserAmount(null);
        commandResultDTO.setMaxLength(this.commandRedPacketProperties.getMaxLength());
        commandResultDTO.setLength(scoreDto.getLength());
        commandResultDTO.setCommandUrl(scoreDto.getCommandUrl());
        return commandResultDTO;
    }
}

