/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.localnews.activity.common.constant.ObtainStatesEnum;
import com.bxm.localnews.activity.common.constant.OnlineStatesEnum;
import com.bxm.localnews.activity.common.constant.RedPacketDisplayStatesEnum;
import com.bxm.localnews.activity.common.constant.RedPacketObtainStatesEnum;
import com.bxm.localnews.activity.common.constant.RedPacketOwnerEnum;
import com.bxm.localnews.activity.common.utils.AmountUtil;
import com.bxm.localnews.activity.common.utils.DateUtil;
import com.bxm.localnews.activity.domain.RedPacketContentMapper;
import com.bxm.localnews.activity.domain.RedPacketItemMapper;
import com.bxm.localnews.activity.domain.RedPacketMapper;
import com.bxm.localnews.activity.domain.RedPacketObtainHistoryMapper;
import com.bxm.localnews.activity.domain.RedPacketShareMapper;
import com.bxm.localnews.activity.dto.CommandResultDTO;
import com.bxm.localnews.activity.dto.MarkScoreDTO;
import com.bxm.localnews.activity.dto.MarkScorePublicDTO;
import com.bxm.localnews.activity.dto.PacketHistoryDTO;
import com.bxm.localnews.activity.dto.RedPacketContentDTO;
import com.bxm.localnews.activity.dto.RedPacketDTO;
import com.bxm.localnews.activity.dto.RedPacketGottenDTO;
import com.bxm.localnews.activity.dto.RedPacketItemDTO;
import com.bxm.localnews.activity.dto.RedPacketPublicDTO;
import com.bxm.localnews.activity.dto.RedPacketSentDTO;
import com.bxm.localnews.activity.dto.RedPacketShareDTO;
import com.bxm.localnews.activity.dto.RedPacketUpdateDTO;
import com.bxm.localnews.activity.dto.ScoreDto;
import com.bxm.localnews.activity.dto.UserObtainRpStatesDTO;
import com.bxm.localnews.activity.dto.WallRedPacketDTO;
import com.bxm.localnews.activity.param.ObtainHistoryParam;
import com.bxm.localnews.activity.param.RedPacketAddParam;
import com.bxm.localnews.activity.param.RedPacketUpdateParam;
import com.bxm.localnews.activity.param.WallRedPacketParam;
import com.bxm.localnews.activity.service.DingDingMsgService;
import com.bxm.localnews.activity.service.RedPacketFacadeService;
import com.bxm.localnews.activity.service.redpacket.command.CommandGradeService;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketObtainFailedHistoryService;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketObtainService;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketService;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketStateService;
import com.bxm.localnews.activity.vo.RedPacket;
import com.bxm.localnews.activity.vo.RedPacketObtainHistory;
import com.bxm.localnews.activity.vo.RedPacketShare;
import com.bxm.localnews.activity.vo.RedPacketTotalVo;
import com.bxm.localnews.activity.vo.RedPacketVo;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.payment.dto.OrderStatusDTO;
import com.bxm.localnews.payment.facde.service.PayService;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RedPacketServiceImpl
extends BaseService
implements RedPacketService,
RedPacketFacadeService {
    private static final Logger LOG = LoggerFactory.getLogger(RedPacketServiceImpl.class);
    private static final Map<String, String> HEADER_MAP = Maps.newHashMap();
    @Autowired
    private BizLogService bizLogService;
    @Autowired
    private CommandGradeService commandGradeService;
    @Autowired
    private RedPacketObtainService redPacketObtainService;
    @Autowired
    private RedPacketObtainFailedHistoryService obtainFailedHistoryService;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private LocationFacadeService locationFacadeService;
    @Autowired
    private RedPacketStateService redPacketStateService;
    @Autowired
    private RedPacketMapper redPacketMapper;
    @Autowired
    private RedPacketObtainHistoryMapper obtainHistoryMapper;
    @Autowired
    private RedPacketContentMapper redPacketContentMapper;
    @Autowired
    private RedPacketItemMapper redPacketItemMapper;
    @Autowired
    private RedPacketShareMapper shareMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private OKHttpService okHttpService;
    @Value(value="${dingding.robot.webhook}")
    private String webhook;
    @Autowired
    private PayService payService;
    @Autowired
    private DingDingMsgService dingMsgService;

    @Override
    public RedPacket selectOne(Long rpId) {
        return this.redPacketMapper.queryOne(rpId);
    }

    public Boolean getHasAvailableRedPacket(Long userId, String areaCode) {
        HashSet redPacketIds = this.redPacketMapper.queryByAreaCode(areaCode);
        if (CollectionUtils.isEmpty((Collection)redPacketIds)) {
            return Boolean.FALSE;
        }
        HashSet userGetRpIds = this.obtainHistoryMapper.queryRpIdsWhichUserGet(userId, (Set)redPacketIds);
        if (CollectionUtils.isEmpty((Collection)userGetRpIds)) {
            return Boolean.TRUE;
        }
        redPacketIds.removeAll(userGetRpIds);
        if (CollectionUtils.isEmpty((Collection)redPacketIds)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void updateRedpacketActiveStatus(Long rpId, String paymentNum, Integer platform) {
        this.logger.info("\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u72b6\u6001\u4e2a\u66f4\u65b0\uff1a\u8ba2\u5355\u7f16\u53f7[{}],\u7ea2\u5305id[{}]", (Object)paymentNum, (Object)rpId);
        RedPacket redPacket = this.selectOne(rpId);
        if (null == redPacket) {
            throw new BusinessException("\u7ea2\u5305\u4e0d\u5b58\u5728");
        }
        if (redPacket.getActiveStatus() != -1) {
            return;
        }
        this.updateActiveStatus(paymentNum, platform, redPacket);
    }

    private List<WallRedPacketDTO> getObtainedAll(String areaCode) {
        return this.redPacketMapper.getObtainedAll(areaCode).stream().map(this::convertWallRedPacketDTO).collect(Collectors.toList());
    }

    @Override
    public PageWarper<WallRedPacketDTO> getReadPacketWall(WallRedPacketParam wallRedPacketParam) {
        List<WallRedPacketDTO> obtainedAllPackets;
        List redPackets = this.redPacketMapper.queryWallByPageSize(wallRedPacketParam);
        PageWarper pageWarper = new PageWarper(redPackets);
        ArrayList wallRedPacketDTOS = Lists.newArrayList();
        if (redPackets.isEmpty()) {
            List<WallRedPacketDTO> obtainedAllPackets2 = this.getObtainedAll(wallRedPacketParam.getAreaCode());
            if (CollectionUtils.isEmpty(obtainedAllPackets2)) {
                pageWarper.setList((List)wallRedPacketDTOS);
                return pageWarper;
            }
            wallRedPacketDTOS.addAll(obtainedAllPackets2);
            pageWarper.setList((List)wallRedPacketDTOS);
            pageWarper.setSize(obtainedAllPackets2.size());
            pageWarper.setTotal((long)obtainedAllPackets2.size());
            pageWarper.setHasNextPage(Boolean.FALSE.booleanValue());
            return pageWarper;
        }
        wallRedPacketDTOS.addAll(redPackets.stream().map(this::convertWallRedPacketDTO).collect(Collectors.toList()));
        if (!pageWarper.isHasNextPage() && !CollectionUtils.isEmpty(obtainedAllPackets = this.getObtainedAll(wallRedPacketParam.getAreaCode()))) {
            wallRedPacketDTOS.addAll(obtainedAllPackets);
        }
        pageWarper.setList((List)wallRedPacketDTOS);
        return pageWarper;
    }

    @Override
    public WallRedPacketDTO getSingleWallReadPacket(Long userId, Long rpId) {
        WallRedPacketDTO wallRedPacketDTO = new WallRedPacketDTO();
        RedPacket redPacket = this.selectOne(rpId);
        if (null == redPacket) {
            throw new BusinessException("\u7ea2\u5305id[" + rpId + "]\u65e0\u6cd5\u67e5\u8be2\u5230\u7ea2\u5305");
        }
        wallRedPacketDTO.setId(redPacket.getId());
        wallRedPacketDTO.setUserImg(redPacket.getUserImg());
        wallRedPacketDTO.setUserName(redPacket.getUserName());
        wallRedPacketDTO.setAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)redPacket.getAmount()));
        wallRedPacketDTO.setContent(redPacket.getContent());
        if (redPacket.getObtainStatus().equals(0)) {
            wallRedPacketDTO.setStatus(Integer.valueOf(0));
            return wallRedPacketDTO;
        }
        Boolean isObtainedByUser = this.redPacketStateService.isObtainedByUser(rpId, userId);
        if (isObtainedByUser.booleanValue()) {
            wallRedPacketDTO.setStatus(Integer.valueOf(1));
            return wallRedPacketDTO;
        }
        wallRedPacketDTO.setStatus(Integer.valueOf(2));
        return wallRedPacketDTO;
    }

    private WallRedPacketDTO convertWallRedPacketDTO(RedPacketVo redPacket) {
        WallRedPacketDTO wallRedPacketDTO = new WallRedPacketDTO();
        wallRedPacketDTO.setId(redPacket.getId());
        wallRedPacketDTO.setContent(redPacket.getContent());
        wallRedPacketDTO.setUserImg(redPacket.getUserImg());
        wallRedPacketDTO.setUserName(redPacket.getUserName());
        wallRedPacketDTO.setStatus(Integer.valueOf(redPacket.getStatus() == null ? 0 : redPacket.getStatus()));
        wallRedPacketDTO.setAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)redPacket.getAmount()));
        return wallRedPacketDTO;
    }

    @Override
    public RedPacketDTO getReadPacketDetail(Long userId, Long rpId) {
        RedPacket redPacket = this.selectOne(rpId);
        if (null == redPacket) {
            throw new BusinessException("redpacket is not exists");
        }
        if (redPacket.getOnlineStatus().equals(OnlineStatesEnum.OFFLINE.getType())) {
            return new RedPacketDTO(OnlineStatesEnum.OFFLINE.getType());
        }
        ObtainStatesEnum obtainStatusEnum = this.redPacketStateService.rpObtainStatus(redPacket.getAmount(), redPacket.getSurplusAmount());
        UserObtainRpStatesDTO userObtainRpStatesDTO = this.redPacketStateService.userObtainRpStates(redPacket.getSurplusAmount(), userId, rpId);
        return this.convertRedPacketDTO(redPacket, obtainStatusEnum, userObtainRpStatesDTO);
    }

    @Override
    public RedPacketPublicDTO getPublicReadPacketDetail(Long userId, Long shareUserId, Long rpId) {
        RedPacket redPacket = this.selectOne(rpId);
        if (null == redPacket) {
            throw new BusinessException("redpacket is not exists");
        }
        if (redPacket.getOnlineStatus().equals(OnlineStatesEnum.OFFLINE.getType())) {
            return new RedPacketPublicDTO(OnlineStatesEnum.OFFLINE.getType());
        }
        ObtainStatesEnum obtainStatusEnum = this.redPacketStateService.rpObtainStatus(redPacket.getAmount(), redPacket.getSurplusAmount());
        UserObtainRpStatesDTO userObtainRpStatesDTO = this.redPacketStateService.userObtainRpStates(redPacket.getSurplusAmount(), userId, rpId);
        RedPacketObtainHistory obtainHistory = this.obtainHistoryMapper.queryByUserAndRp(shareUserId, rpId);
        return this.convertRedPacketPublicDTO(redPacket, obtainStatusEnum, userObtainRpStatesDTO, obtainHistory);
    }

    private RedPacketPublicDTO convertRedPacketPublicDTO(RedPacket redPacket, ObtainStatesEnum obtainStatusEnum, UserObtainRpStatesDTO userObtainRpStatesDTO, RedPacketObtainHistory obtainHistory) {
        RedPacketPublicDTO redPacketPublicDTO = new RedPacketPublicDTO();
        redPacketPublicDTO.setType(redPacket.getPacketType());
        redPacketPublicDTO.setOwnerUserName(redPacket.getUserName());
        redPacketPublicDTO.setOwnerUserImg(redPacket.getUserImg());
        redPacketPublicDTO.setContent(redPacket.getContent());
        redPacketPublicDTO.setContentImg(redPacket.getPromotionImg() == null ? Lists.newArrayList() : (List)JSONObject.parseObject((String)redPacket.getPromotionImg(), List.class));
        redPacketPublicDTO.setPromotionContent(redPacket.getPromotionContent());
        BigDecimal obtainAmount = redPacket.getAmount().subtract(redPacket.getSurplusAmount());
        redPacketPublicDTO.setAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)redPacket.getAmount()));
        redPacketPublicDTO.setObtainAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)obtainAmount));
        redPacketPublicDTO.setObtainStatus(obtainStatusEnum.getType());
        redPacketPublicDTO.setRpStatus(userObtainRpStatesDTO.getUserObtainRpStatesEnum().getType());
        redPacketPublicDTO.setUserObtainAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)userObtainRpStatesDTO.getUserObtainAmount()));
        if (obtainHistory != null) {
            redPacketPublicDTO.setShareUserName(obtainHistory.getUserName());
            redPacketPublicDTO.setShareUserImg(obtainHistory.getUserImg());
            redPacketPublicDTO.setShareAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)obtainHistory.getObtainAmount()));
            redPacketPublicDTO.setShareScore(String.valueOf(obtainHistory.getScore()));
        }
        return redPacketPublicDTO;
    }

    private RedPacketDTO convertRedPacketDTO(RedPacket redPacket, ObtainStatesEnum obtainStatusEnum, UserObtainRpStatesDTO userObtainRpStatesDTO) {
        RedPacketDTO redPacketDTO = new RedPacketDTO();
        redPacketDTO.setType(redPacket.getPacketType());
        redPacketDTO.setOwnerUserName(redPacket.getUserName());
        redPacketDTO.setOwnerUserImg(redPacket.getUserImg());
        redPacketDTO.setContent(redPacket.getContent());
        redPacketDTO.setContentImg(redPacket.getPromotionImg() == null ? Lists.newArrayList() : (List)JSONObject.parseObject((String)redPacket.getPromotionImg(), List.class));
        redPacketDTO.setPromotionContent(redPacket.getPromotionContent());
        BigDecimal obtainAmount = redPacket.getAmount().subtract(redPacket.getSurplusAmount());
        redPacketDTO.setAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)redPacket.getAmount()));
        redPacketDTO.setObtainAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)obtainAmount));
        redPacketDTO.setObtainStatus(obtainStatusEnum.getType());
        redPacketDTO.setRpStatus(userObtainRpStatesDTO.getUserObtainRpStatesEnum().getType());
        redPacketDTO.setUserObtainAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)userObtainRpStatesDTO.getUserObtainAmount()));
        return redPacketDTO;
    }

    @Override
    public RedPacketTotalVo getTotalRecordByUser(Integer owner, Long userId) {
        Map totalInfo = null;
        if (RedPacketOwnerEnum.SENT.getType() == owner.intValue()) {
            totalInfo = this.redPacketMapper.getTotalSentRedPacket(userId);
        }
        if (RedPacketOwnerEnum.GOTTEN.getType() == owner.intValue()) {
            totalInfo = this.obtainHistoryMapper.getTotalGottenRedPacket(userId);
        }
        if (null == totalInfo || totalInfo.size() == 0) {
            return new RedPacketTotalVo("0.00", Integer.valueOf(0));
        }
        return this.convertToRedPacketTotalVo(totalInfo);
    }

    private RedPacketTotalVo convertToRedPacketTotalVo(Map<String, Object> totalInfo) {
        RedPacketTotalVo redPacketTotalVo = new RedPacketTotalVo();
        Object num = totalInfo.get("total_num");
        Object amount = totalInfo.get("total_amount");
        redPacketTotalVo.setTotalNum(Integer.valueOf(null == num || !StringUtils.isNumeric((CharSequence)String.valueOf(num)) ? 0 : Integer.valueOf(String.valueOf(num))));
        redPacketTotalVo.setTotalAmount(null == amount ? "0.00" : NumberUtils.format((BigDecimal)new BigDecimal(String.valueOf(amount))));
        return redPacketTotalVo;
    }

    @Override
    public PageWarper<RedPacketSentDTO> listSentRecord(Long userId, Integer current, Integer pageSize) {
        PageHelper.startPage((int)(null == current ? 1 : current), (int)(null == pageSize ? 10 : pageSize));
        List redPackets = this.redPacketMapper.listRedPacketByUser(userId);
        PageWarper pageWarper = new PageWarper(redPackets);
        ArrayList list = Lists.newArrayList();
        if (null != redPackets && redPackets.size() != 0) {
            for (RedPacket redPacket : redPackets) {
                RedPacketSentDTO redPacketSentDTO = new RedPacketSentDTO();
                redPacketSentDTO.setAmount(NumberUtils.format((BigDecimal)redPacket.getAmount()));
                redPacketSentDTO.setContent(redPacket.getContent());
                redPacketSentDTO.setPublishTime(DateUtil.getDateLog((Date)redPacket.getCreateTime()));
                redPacketSentDTO.setRpId(redPacket.getId());
                Integer statue = this.getDisplayStatus(redPacket.getActiveStatus(), redPacket.getSurplusAmount());
                redPacketSentDTO.setStatus(statue);
                redPacketSentDTO.setStatusStr(null == statue ? "" : RedPacketDisplayStatesEnum.getValue((int)statue));
                redPacketSentDTO.setSurplusAmount(NumberUtils.format((BigDecimal)redPacket.getSurplusAmount()));
                redPacketSentDTO.setType(redPacket.getPacketType());
                list.add(redPacketSentDTO);
            }
        }
        pageWarper.setList((List)list);
        return pageWarper;
    }

    private Integer getDisplayStatus(Integer activeStatus, BigDecimal surplusAmount) {
        if (null != activeStatus && RedPacketDisplayStatesEnum.PASS_AUDIT.getCode() == activeStatus.intValue() && null != surplusAmount && 0.0f == surplusAmount.floatValue()) {
            return RedPacketDisplayStatesEnum.BROUGHT_OUT.getCode();
        }
        return activeStatus;
    }

    @Override
    public PageWarper<RedPacketGottenDTO> listGottenRecord(Long userId, Integer current, Integer pageSize) {
        if (null == userId) {
            return new PageWarper();
        }
        PageHelper.startPage((int)(null == current ? 1 : current), (int)(null == pageSize ? 10 : pageSize));
        List obtainHistories = this.obtainHistoryMapper.listRedPacketByUser(userId);
        PageWarper pageWarper = new PageWarper(obtainHistories);
        List list = obtainHistories.stream().map(this::convertToRedPacketGottenDTO).collect(Collectors.toList());
        pageWarper.setList(list);
        return pageWarper;
    }

    private RedPacketGottenDTO convertToRedPacketGottenDTO(RedPacketObtainHistory obtainHistory) {
        RedPacketGottenDTO gottenDTO = new RedPacketGottenDTO();
        gottenDTO.setAmount(NumberUtils.format((BigDecimal)obtainHistory.getObtainAmount()));
        gottenDTO.setObtainTime(DateUtil.getDateLog((Date)obtainHistory.getCreateTime()));
        gottenDTO.setRphId(obtainHistory.getRpId());
        gottenDTO.setScore(String.valueOf(obtainHistory.getScore()));
        gottenDTO.setUserName(obtainHistory.getOwnerUserName());
        return gottenDTO;
    }

    @Override
    public Boolean updateRedPacket(RedPacketUpdateParam redPacketUpdateParam, Integer platform) {
        RedPacket redPacket = this.selectOne(redPacketUpdateParam.getRpId());
        if (null == redPacket) {
            throw new BusinessException("redpacket is not exists");
        }
        this.convertRedPacket(redPacket, redPacketUpdateParam);
        Integer result = this.redPacketMapper.update(redPacket);
        if (result == 0) {
            return Boolean.FALSE;
        }
        if (redPacket.getActiveStatus() == 0) {
            this.dingMsgService.sendExamine(redPacketUpdateParam.getUserId());
        }
        return Boolean.TRUE;
    }

    @Override
    public Byte queryOrder(Long rpId, Long userId, String paymentNum, Integer platform) {
        this.logger.info("\u8ba2\u5355\u652f\u4ed8\u67e5\u8be2\uff1a\u8ba2\u5355\u7f16\u53f7[{}],\u7ea2\u5305id[{}]", (Object)paymentNum, (Object)rpId);
        RedPacket redPacket = this.selectOne(rpId);
        if (null == redPacket) {
            throw new BusinessException("\u7ea2\u5305\u4e0d\u5b58\u5728");
        }
        if (redPacket.getActiveStatus() != -1) {
            return (byte)3;
        }
        OrderStatusDTO orderStatusDTO = this.payService.queryOrder(paymentNum);
        if (null == orderStatusDTO || null == orderStatusDTO.getStatus()) {
            throw new BusinessException("\u652f\u4ed8\u8ba2\u5355:" + paymentNum + "\u67e5\u8be2\u5f02\u5e38");
        }
        if (orderStatusDTO.getStatus().intValue() != 3) {
            return orderStatusDTO.getStatus();
        }
        this.updateActiveStatus(paymentNum, platform, redPacket);
        return orderStatusDTO.getStatus();
    }

    private void updateActiveStatus(String paymentNum, Integer platform, RedPacket redPacket) {
        boolean isUnapprovalRedPacket = this.isUnapprovalRedPacket(redPacket);
        if (isUnapprovalRedPacket) {
            redPacket.setActiveStatus(Integer.valueOf(2));
            redPacket.setOnlineStatus(Integer.valueOf(1));
            this.logger.info("\u751f\u6210\u5df2\u5ba1\u6838\u7ea2\u5305\uff1a\u8ba2\u5355\u7f16\u53f7[{}],\u7ea2\u5305id[{}]", (Object)paymentNum, (Object)redPacket.getId());
        } else {
            redPacket.setActiveStatus(Integer.valueOf(0));
            redPacket.setOnlineStatus(Integer.valueOf(0));
            this.logger.info("\u751f\u6210\u5f85\u5ba1\u6838\u7ea2\u5305\uff1a\u8ba2\u5355\u7f16\u53f7[{}],\u7ea2\u5305id[{}]", (Object)paymentNum, (Object)redPacket.getId());
        }
        redPacket.setPaymentNum(paymentNum);
        Integer result = this.redPacketMapper.updatePayStatus(redPacket);
        if (result == 0) {
            throw new BusinessException("\u66f4\u65b0\u7ea2\u5305[" + redPacket.getId() + "]\u652f\u4ed8\u72b6\u6001\u5931\u8d25");
        }
        this.bizLogService.sendRedPacket(redPacket.getUserId(), redPacket.getAmount(), platform);
        if (redPacket.getActiveStatus() == 0) {
            this.dingMsgService.sendExamine(redPacket.getUserId());
        }
    }

    @Override
    public Boolean isActiveArea(Long rpId, String city, String district) {
        String areaCode = this.locationFacadeService.getLocationByName(district);
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            areaCode = this.locationFacadeService.getLocationByName(city);
        }
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return Boolean.FALSE;
        }
        RedPacket redPacket = this.selectOne(rpId);
        if (null == redPacket) {
            return Boolean.FALSE;
        }
        if (redPacket.getAreaCode().equals(areaCode)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean isPaySuccess(Long rpId) {
        RedPacket redPacket = this.selectOne(rpId);
        if (null == redPacket) {
            throw new BusinessException("\u7ea2\u5305\u4e0d\u5b58\u5728");
        }
        if (redPacket.getActiveStatus() == -1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Long insertRedPacket(RedPacketAddParam redPacketAddParam) {
        RedPacket redPacket = this.convertRedPacket(redPacketAddParam);
        Integer result = this.redPacketMapper.insert(redPacket);
        return 1 == result ? redPacket.getId() : 0L;
    }

    private void convertRedPacket(RedPacket redPacket, RedPacketUpdateParam redPacketUpdateParam) {
        if (null != redPacketUpdateParam.getTwisterId() && 0L != redPacketUpdateParam.getTwisterId() && CollectionUtils.isEmpty((Collection)redPacketUpdateParam.getPromotionImgs()) && StringUtils.isBlank((CharSequence)redPacketUpdateParam.getPromotionContent())) {
            redPacket.setTwisterId(redPacketUpdateParam.getTwisterId());
            redPacket.setActiveStatus(Integer.valueOf(2));
            redPacket.setOnlineStatus(Integer.valueOf(1));
        } else {
            redPacket.setTwisterId(Long.valueOf(0L));
            redPacket.setActiveStatus(Integer.valueOf(0));
            redPacket.setOnlineStatus(Integer.valueOf(0));
        }
        redPacket.setContent(redPacketUpdateParam.getContent());
        redPacket.setPromotionContent(redPacketUpdateParam.getPromotionContent());
        this.logger.info("\u7528\u6237\u4fee\u6539\u7ea2\u5305\u6570\u636e,promotionImgs:[{}]", (Object)redPacketUpdateParam.getPromotionImgs());
        redPacket.setPromotionImg(JSON.toJSONString((Object)redPacketUpdateParam.getPromotionImgs(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullListAsEmpty}));
    }

    private RedPacket convertRedPacket(RedPacketAddParam redPacketAddParam) {
        RedPacket redPacket = new RedPacket();
        redPacket.setId(this.sequenceCreater.nextLongId());
        redPacket.setUserId(redPacketAddParam.getUserId());
        redPacket.setUserImg(redPacketAddParam.getUserImg());
        redPacket.setUserName(redPacketAddParam.getUserName());
        redPacket.setAmount(new BigDecimal(redPacketAddParam.getAmount()));
        redPacket.setSurplusAmount(redPacket.getAmount());
        redPacket.setExpectNum(redPacketAddParam.getExperctNum());
        redPacket.setActualNum(Integer.valueOf(0));
        redPacket.setPacketType(redPacketAddParam.getType());
        redPacket.setTwisterId(Long.valueOf(null == redPacketAddParam.getTwisterId() ? 0L : redPacketAddParam.getTwisterId()));
        redPacket.setActiveStatus(Integer.valueOf(-1));
        redPacket.setOnlineStatus(Integer.valueOf(0));
        if (null != redPacketAddParam.getPromotionImgs()) {
            ArrayList compressList = Lists.newArrayList();
            redPacketAddParam.getPromotionImgs().forEach(img -> {
                if (img.contains("?")) {
                    compressList.add(img);
                } else {
                    compressList.add(img + "?x-oss-process=style/mcompress");
                }
            });
            redPacket.setPromotionImg(JSON.toJSONString((Object)compressList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullListAsEmpty}));
        }
        redPacket.setContent(redPacketAddParam.getContent());
        redPacket.setPromotionContent(redPacketAddParam.getPromotionContent());
        redPacket.setAreaCode(redPacketAddParam.getAreaCode());
        redPacket.setAreaName(redPacketAddParam.getAreaName());
        return redPacket;
    }

    @Override
    public RedPacketShareDTO getShareInfo(Long rpId, Long userId, Integer type, String nickname) {
        this.logger.info("[\u83b7\u53d6\u5206\u4eab\u4fe1\u606f] rpId:[{}],userId:[{}],type:[{}],nickname:[{}]", new Object[]{rpId, userId, type, nickname});
        if (null == type) {
            LOG.warn("[getShareInfo] type is null");
            return null;
        }
        List shares = this.shareMapper.listShare(type);
        if (null == shares || shares.size() == 0) {
            LOG.warn("[getShareInfo] share info is empty");
            return null;
        }
        Long num = 0L;
        if (1 == type) {
            num = this.redisStringAdapter.increment(RedisConfig.RED_PACKET_SHARE_UNINVOLVED);
        } else if (2 == type) {
            num = this.redisStringAdapter.increment(RedisConfig.RED_PACKET_SHARE_INVOLVED);
        }
        RedPacketShare redPacketShare = (RedPacketShare)shares.get(num.intValue() % shares.size());
        if (null == redPacketShare || StringUtils.isBlank((CharSequence)redPacketShare.getContent())) {
            LOG.warn("[getShareInfo] share info is null,type:{}", (Object)type);
            return null;
        }
        String content = redPacketShare.getContent();
        String obtainAmountStr = null;
        RedPacketObtainHistory obtainHistory = this.obtainHistoryMapper.queryByUserAndRp(userId, rpId);
        content = content.replace("{nickname}", nickname);
        if (obtainHistory != null) {
            obtainAmountStr = AmountUtil.halfUpScale2StringValue((BigDecimal)obtainHistory.getObtainAmount());
            content = content.replace("{score}", obtainHistory.getScore() + "");
            content = content.replace("{money}", obtainAmountStr);
        }
        RedPacketShareDTO result = new RedPacketShareDTO();
        result.setId(redPacketShare.getId());
        result.setShare(content);
        result.setImgUrl(redPacketShare.getImgUrl());
        result.setAmount(obtainAmountStr);
        return result;
    }

    @Override
    public List<RedPacketItemDTO> listRedPacketItem(Long userId) {
        return this.redPacketItemMapper.listItem();
    }

    @Override
    public List<RedPacketContentDTO> listRedPacketContent(Long userId) {
        return this.redPacketContentMapper.listContent();
    }

    @Override
    public RedPacketUpdateDTO getRedPacketById(Long rpId, Long userId) {
        RedPacket redPacket = this.redPacketMapper.selectRedPacketByIdAndUserId(rpId, userId);
        if (null == redPacket) {
            LOG.warn("can not get red packet by rpId:[{}], userId:[{}]", (Object)rpId, (Object)userId);
            return null;
        }
        return this.converToRedPacketUpdateDTO(redPacket);
    }

    private RedPacketUpdateDTO converToRedPacketUpdateDTO(RedPacket redPacket) {
        RedPacketUpdateDTO redPacketUpdateDTO = new RedPacketUpdateDTO();
        redPacketUpdateDTO.setRpId(redPacket.getId());
        redPacketUpdateDTO.setComment(redPacket.getComment());
        redPacketUpdateDTO.setContent(redPacket.getContent());
        redPacketUpdateDTO.setPromotionContent(redPacket.getPromotionContent());
        redPacketUpdateDTO.setTwisterId(redPacket.getTwisterId());
        redPacketUpdateDTO.setPromotionImgs((List)JSONObject.parseObject((String)redPacket.getPromotionImg(), List.class));
        return redPacketUpdateDTO;
    }

    @Override
    public PageWarper<PacketHistoryDTO> getObtainHistory(ObtainHistoryParam obtainHistoryParam) {
        List histories = this.obtainHistoryMapper.queryByPageSize(obtainHistoryParam);
        PageWarper pageWarper = new PageWarper(histories);
        List packetHistoryDTOS = histories.stream().map(this::covertPacketHistoryDTO).collect(Collectors.toList());
        pageWarper.setList(packetHistoryDTOS);
        return pageWarper;
    }

    @Override
    public List<PacketHistoryDTO> getRanking(Long rpId) {
        List histories = this.obtainHistoryMapper.queryScoreList(rpId);
        List<PacketHistoryDTO> packetHistoryDTOS = histories.stream().map(this::covertPacketHistoryDTO).collect(Collectors.toList());
        return packetHistoryDTOS;
    }

    @Override
    public CommandResultDTO markScore(MarkScoreDTO markScoreDTO, Integer platform) {
        RedPacket redPacket = this.redPacketMapper.queryOne(markScoreDTO.getRpId());
        if (null == redPacket) {
            throw new BusinessException("can not get red packet by id ,id:[" + markScoreDTO.getRpId() + "]");
        }
        RedPacketObtainStatesEnum rpObtainState = this.redPacketStateService.rpStatesCheck(redPacket, markScoreDTO.getUserId());
        if (rpObtainState != null) {
            return new CommandResultDTO(rpObtainState.getType());
        }
        ScoreDto scoreDto = this.commandGradeService.grade(redPacket.getContent(), markScoreDTO.getCommandUrl(), markScoreDTO.getCommandLength());
        User user = this.userIntegrationService.selectByPrimaryKey(markScoreDTO.getUserId());
        if (null == user) {
            throw new BusinessException("can not get user by id ,id:[" + markScoreDTO.getUserId() + "]");
        }
        this.logger.info("\u53e3\u4ee4\u8bc4\u5206\u6210\u529f\uff1a\u7528\u6237:[{}],\u5f97\u5206:[{}],\u5339\u914d\u5ea6:[{}],\u79f0\u8d5e\u8bed\u6bd4\u4f8b:[{}],\u8bed\u97f3\u65f6\u957f\uff1a[{}]", new Object[]{user.getNickname(), scoreDto.getScore(), scoreDto.getMatchScale(), scoreDto.getUserScale(), scoreDto.getLength()});
        if (scoreDto.getScore() > 40) {
            return this.redPacketObtainService.obtainRedPacket(redPacket.getId(), scoreDto, user, platform, 3);
        }
        this.obtainFailedHistoryService.addOne(user.getId(), redPacket.getId(), scoreDto.getCommandUrl(), scoreDto.getScore());
        return new CommandResultDTO(RedPacketObtainStatesEnum.LESS40.getType());
    }

    @Override
    public CommandResultDTO markScore(MarkScorePublicDTO markScorePublicDTO, Integer platform) {
        RedPacket redPacket = this.redPacketMapper.queryOne(markScorePublicDTO.getRpId());
        if (null == redPacket) {
            throw new BusinessException("can not get red packet by id ,id:[" + markScorePublicDTO.getRpId() + "]");
        }
        RedPacketObtainStatesEnum rpObtainState = this.redPacketStateService.rpStatesCheck(redPacket, markScorePublicDTO.getUserId());
        if (rpObtainState != null) {
            return new CommandResultDTO(rpObtainState.getType());
        }
        ScoreDto scoreDto = this.commandGradeService.grade(redPacket.getContent(), markScorePublicDTO.getMedieId());
        User user = this.userIntegrationService.selectByPrimaryKey(markScorePublicDTO.getUserId());
        if (null == user) {
            throw new BusinessException("can not get user by id ,id:[" + markScorePublicDTO.getUserId() + "]");
        }
        this.logger.info("\u7ad9\u5916\u53e3\u4ee4\u8bc4\u5206\u6210\u529f\uff1a\u7528\u6237:[{}],\u5f97\u5206:[{}],\u5339\u914d\u5ea6:[{}],\u79f0\u8d5e\u8bed\u6bd4\u4f8b:[{}],\u8bed\u97f3\u65f6\u957f\uff1a[{}]", new Object[]{user.getNickname(), scoreDto.getScore(), scoreDto.getMatchScale(), scoreDto.getUserScale(), scoreDto.getLength()});
        if (scoreDto.getScore() > 40) {
            return this.redPacketObtainService.publicObtainRedPacket(redPacket.getId(), redPacket.getPacketType(), markScorePublicDTO.getCity(), markScorePublicDTO.getDistrict(), scoreDto, user, platform, 3);
        }
        this.obtainFailedHistoryService.addOne(user.getId(), redPacket.getId(), scoreDto.getCommandUrl(), scoreDto.getScore());
        return new CommandResultDTO(RedPacketObtainStatesEnum.LESS40.getType());
    }

    private PacketHistoryDTO covertPacketHistoryDTO(RedPacketObtainHistory obtainHistory) {
        PacketHistoryDTO history = new PacketHistoryDTO();
        BeanUtils.copyProperties((Object)obtainHistory, (Object)history);
        history.setObtainTime(Long.valueOf(obtainHistory.getCreateTime().getTime()));
        history.setObtainAmount(AmountUtil.halfUpScale2StringValue((BigDecimal)obtainHistory.getObtainAmount()));
        return history;
    }

    private boolean isUnapprovalRedPacket(RedPacket redPacket) {
        List promotionImgList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)redPacket.getPromotionImg())) {
            promotionImgList = (List)JSON.parseObject((String)redPacket.getPromotionImg(), List.class);
        }
        return null != redPacket.getTwisterId() && 0L != redPacket.getTwisterId() && CollectionUtils.isEmpty(promotionImgList) && StringUtils.isBlank((CharSequence)redPacket.getPromotionContent());
    }
}

