/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.common.constant.ObtainStatesEnum;
import com.bxm.localnews.activity.common.constant.OnlineStatesEnum;
import com.bxm.localnews.activity.common.constant.RedPacketAmountStatesEnum;
import com.bxm.localnews.activity.common.constant.RedPacketObtainStatesEnum;
import com.bxm.localnews.activity.common.constant.UserObtainRpStatesEnum;
import com.bxm.localnews.activity.domain.RedPacketObtainHistoryMapper;
import com.bxm.localnews.activity.dto.UserObtainRpStatesDTO;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketStateService;
import com.bxm.localnews.activity.vo.RedPacket;
import com.bxm.localnews.activity.vo.RedPacketObtainHistory;
import com.bxm.localnews.common.exception.BusinessException;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedPacketStateServiceImpl
implements RedPacketStateService {
    @Autowired
    private RedPacketObtainHistoryMapper obtainHistoryMapper;

    @Override
    public RedPacketObtainStatesEnum rpStatesCheck(RedPacket redPacket, Long userId) {
        if (this.isObtainedByUser(redPacket.getId(), userId).booleanValue()) {
            return RedPacketObtainStatesEnum.OBTAINTED;
        }
        if (redPacket.getOnlineStatus().equals(OnlineStatesEnum.OFFLINE.getType())) {
            return RedPacketObtainStatesEnum.OFFLINE;
        }
        if (redPacket.getObtainStatus().equals(RedPacketAmountStatesEnum.UNOBTAINABLE.getType())) {
            return RedPacketObtainStatesEnum.EMPTY;
        }
        return null;
    }

    @Override
    public Boolean isObtainedByUser(Long rpId, Long userId) {
        Integer count = this.obtainHistoryMapper.countByUserAndRp(userId, rpId);
        if (count != 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public ObtainStatesEnum rpObtainStatus(BigDecimal amount, BigDecimal surplusAmount) {
        int result = surplusAmount.compareTo(BigDecimal.ZERO);
        if (result == 0) {
            return ObtainStatesEnum.OBTAINED;
        }
        result = amount.compareTo(surplusAmount);
        if (result == 0) {
            return ObtainStatesEnum.NOTOBTAIN;
        }
        return ObtainStatesEnum.PARTOBTAIN;
    }

    @Override
    public UserObtainRpStatesDTO userObtainRpStates(BigDecimal surplusAmount, Long userId, Long rpId) {
        RedPacketObtainHistory history = this.obtainHistoryMapper.queryByUserAndRp(userId, rpId);
        int result = surplusAmount.compareTo(BigDecimal.ZERO);
        if (null == history && result == 1) {
            return new UserObtainRpStatesDTO(UserObtainRpStatesEnum.UNEMPTY_NOTGET);
        }
        if (null == history && result == 0) {
            return new UserObtainRpStatesDTO(UserObtainRpStatesEnum.EMPTY_NOTGET);
        }
        if (null != history) {
            return new UserObtainRpStatesDTO(UserObtainRpStatesEnum.GOT, history.getObtainAmount());
        }
        throw new BusinessException("user obtain redpacket states error,userId[" + userId + "],rpId[" + rpId + "]");
    }
}

