/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.strategy;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.activity.command.TaskInvoke;
import com.bxm.localnews.activity.command.TransferPushMsgCommand;
import com.bxm.localnews.activity.command.TransferUserEventCommand;
import com.bxm.localnews.activity.common.constant.TaskStateEnum;
import com.bxm.localnews.activity.domain.DailyTaskMapper;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.strategy.TaskStrategy;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTaskStrategy
extends BaseService
implements TaskStrategy {
    protected static ThreadLocal<TaskInvoke> taskInvokeThreadLocal = ThreadLocal.withInitial(TaskInvoke::new);
    @Autowired
    protected UserAccountIntegrationService userAccountIntegrationService;
    @Autowired
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;
    @Autowired
    private DailyTaskMapper dailyTaskMapper;
    @Autowired
    protected SequenceCreater sequenceCreater;
    @Autowired
    private DistributedLock lock;
    private static final String LOCK_KEY = "LOCK_KEY";
    private static final String REQUEST_ID = "REQUEST_ID";

    @Override
    public NewsMissionRewardDto process(TaskContext taskContext) {
        this.logger.debug("\u8fdb\u5165\u62bd\u8c61\u7b56\u7565\uff0c\u8d77\u59cb\u65b9\u6cd5\uff0c\u7ebf\u7a0bid:[{}],threadLocal\u5730\u5740:[{}]", (Object)Thread.currentThread(), (Object)taskInvokeThreadLocal.toString());
        if (!this.beforeProcessing(taskContext)) {
            return this.convertTask(taskContext.getTaskEnum(), 0L, taskContext.getUserId());
        }
        NewsMissionRewardDto missionRewardDto = this.completeTask(taskContext);
        this.logger.debug("\u5b8c\u6210\u4efb\u52a1[{}],\u83b7\u5f97\u5956\u52b1[{}]", (Object)taskContext.getTaskEnum().name(), (Object)JSONObject.toJSONString((Object)missionRewardDto));
        this.afterProcessing();
        return missionRewardDto;
    }

    private boolean beforeProcessing(TaskContext taskContext) {
        DailyTask dailyTask = this.dailyTaskMapper.selectByTaskType(Byte.valueOf(taskContext.getTaskEnum().getType()));
        this.logger.debug("\u83b7\u5f97\u4efb\u52a1:[{}]", (Object)JSONObject.toJSONString((Object)dailyTask));
        if (dailyTask == null) {
            this.logger.error("[{}]\u4efb\u52a1\u4e0d\u5b58\u5728", (Object)taskContext.getTaskEnum());
            return false;
        }
        if (TaskStateEnum.ENABLE != TaskStateEnum.isAble((int)dailyTask.getState().byteValue())) {
            this.logger.warn("[{}]\u4efb\u52a1\u72b6\u6001\u4e3a'\u5173\u95ed'", (Object)taskContext.getTaskEnum());
            return false;
        }
        taskContext.setDailyTask(dailyTask);
        return true;
    }

    private NewsMissionRewardDto completeTask(TaskContext taskContext) {
        Message msg = this.preProcessing(taskContext);
        if (!msg.isSuccess()) {
            this.logger.warn("\u8be5\u4efb\u52a1[{}]\u5df2\u65e0\u6cd5\u5b8c\u6210,\u5177\u4f53\u539f\u56e0\uff1a[{}]", (Object)taskContext.getTaskEnum().getDesc(), (Object)msg.getLastMessage());
            return this.convertTask(taskContext.getTaskEnum(), 0L, taskContext.getUserId());
        }
        NewsMissionRewardDto missionRewardDto = this.processing(taskContext);
        this.postProcessing(taskContext);
        return missionRewardDto;
    }

    protected abstract Message preProcessing(TaskContext var1);

    protected abstract NewsMissionRewardDto processing(TaskContext var1);

    protected abstract void postProcessing(TaskContext var1);

    private void afterProcessing() {
        try {
            taskInvokeThreadLocal.get().execute();
            taskInvokeThreadLocal.remove();
            this.logger.debug("\u6e05\u9664\u5f53\u524d\u7ebf\u7a0b\u7684threadLocal:[{}]", (Object)(taskInvokeThreadLocal.get() == null ? 1 : 0));
        }
        catch (Throwable throwable) {
            taskInvokeThreadLocal.remove();
            this.logger.debug("\u6e05\u9664\u5f53\u524d\u7ebf\u7a0b\u7684threadLocal:[{}]", (Object)(taskInvokeThreadLocal.get() == null ? 1 : 0));
            throw throwable;
        }
    }

    protected NewsMissionRewardDto convertTask(TaskEnum task, Long reward, Long userId) {
        NewsMissionRewardDto result = new NewsMissionRewardDto();
        result.setTaskName(task.getDesc());
        result.setGoldNum(reward);
        result.setTotalGold(BigDecimal.valueOf(this.userAccountIntegrationService.getUserUsableGold(userId).intValue()));
        return result;
    }

    protected void afterCompleteToPushMsg(TaskContext taskContext) {
        TransferPushMsgCommand command = new TransferPushMsgCommand(taskContext, this.userAccountIntegrationService, this.pushMsgSupplyFeignService);
        taskInvokeThreadLocal.get().setCommand(command);
    }

    protected void afterCompleteToUserEvent(TaskContext taskContext) {
        TransferUserEventCommand command = new TransferUserEventCommand(taskContext, this.userAccountIntegrationService, this.pushMsgSupplyFeignService);
        taskInvokeThreadLocal.get().setCommand(command);
    }

    protected boolean lock(TaskContext t) {
        String lockKey = (String)t.getParam(LOCK_KEY);
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            lockKey = this.getLockKey(t);
        }
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            return true;
        }
        String requestId = this.sequenceCreater.nextLongId().toString();
        t.addParam(LOCK_KEY, (Object)lockKey);
        t.addParam(REQUEST_ID, (Object)requestId);
        return this.lock.lock(lockKey, requestId);
    }

    private String getLockKey(TaskContext param) {
        return RedisConfig.ACTIVITY_LOCK.copy().appendKey((Object)param.getTaskEnum().getType()).appendKey((Object)param.getUserId()).gen();
    }
}

