/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.strategy.dailyConcreteStrategy;

import com.bxm.localnews.activity.command.TaskInvoke;
import com.bxm.localnews.activity.command.TransferAddGoldCommand;
import com.bxm.localnews.activity.domain.BrowseRecordMapper;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.strategy.AbstractTaskStrategy;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public abstract class AbstractDailyTaskStrategy
extends AbstractTaskStrategy {
    protected RedisStringAdapter redisStringAdapter;
    protected RedisHashMapAdapter redisHashMapAdapter;
    private NewsProperties newsProperties;
    protected UserIntegrationService userIntegrationService;
    protected BrowseRecordMapper browseRecordMapper;

    @Autowired(required=false)
    public AbstractDailyTaskStrategy(RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, NewsProperties newsProperties, UserIntegrationService userIntegrationService, BrowseRecordMapper browseRecordMapper) {
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.newsProperties = newsProperties;
        this.userIntegrationService = userIntegrationService;
        this.browseRecordMapper = browseRecordMapper;
    }

    @Override
    protected Message preProcessing(TaskContext taskContext) {
        Message msg = this.judgeIsOverRewardSum(taskContext);
        if (!msg.isSuccess()) {
            return msg;
        }
        return this.customJudge(taskContext);
    }

    protected abstract Message customJudge(TaskContext var1);

    private Message judgeIsOverRewardSum(TaskContext taskContext) {
        KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy().setKey(taskContext.getUserId() + ":" + DateUtils.formatDate((Date)new Date()));
        int totalGoldDay = this.redisStringAdapter.getInt(userRewardSumKey);
        if (totalGoldDay >= this.newsProperties.getGoldPerDay()) {
            return Message.build((boolean)false, (String)"\u4eca\u65e5\u5df2\u83b7\u5f97\u7ea2\u82b1\u6570\u4e0a\u9650!");
        }
        taskContext.addParam("userRewardSumKey", (Object)userRewardSumKey);
        return Message.build((boolean)true);
    }

    protected Message judgeIsOverRewardCount(TaskContext taskContext) {
        KeyGenerator taskCompleteNumKey = this.getTaskCompleteNumKey(taskContext.getTaskEnum(), taskContext.getUserId());
        int completeNum = this.redisStringAdapter.getInt(taskCompleteNumKey);
        if (completeNum >= taskContext.getDailyTask().getNumber()) {
            return Message.build((boolean)false, (String)"\u4eca\u65e5\u4efb\u52a1\u5df2\u83b7\u5f97\u6700\u5927\u6b21\u6570\u9650\u5236!");
        }
        taskContext.addParam("taskCompleteNumKey", (Object)taskCompleteNumKey);
        taskContext.addParam("completeNum", (Object)completeNum);
        return Message.build((boolean)true);
    }

    protected NewsMissionRewardDto defaultProcess(TaskContext taskContext) {
        Long userId = taskContext.getUserId();
        DailyTask dailyTask = taskContext.getDailyTask();
        KeyGenerator taskCompleteNumKey = (KeyGenerator)taskContext.getParam("taskCompleteNumKey");
        KeyGenerator userRewardSumKey = (KeyGenerator)taskContext.getParam("userRewardSumKey");
        int completeNum = (Integer)taskContext.getParam("completeNum");
        this.redisStringAdapter.set(taskCompleteNumKey, (long)(++completeNum));
        this.redisStringAdapter.expire(taskCompleteNumKey, (long)DateUtils.getCurSeconds());
        if (completeNum == dailyTask.getNumber()) {
            this.completeDailyTask(userId, taskContext.getTaskEnum().getType());
            if (this.isSupportPushMessage()) {
                taskContext.setPushMsg(Boolean.valueOf(true));
            }
        }
        long reward = this.getTaskReward(taskContext);
        dailyTask.setReward(BigDecimal.valueOf(reward));
        this.redisStringAdapter.incrementWithDefault(userRewardSumKey, reward, Math.toIntExact(reward));
        this.redisStringAdapter.expire(userRewardSumKey, (long)DateUtils.getCurSeconds());
        taskContext.setAddGold(Boolean.valueOf(true));
        return this.convertTask(taskContext.getTaskEnum(), reward, userId);
    }

    @Override
    protected void postProcessing(TaskContext taskContext) {
        if (taskContext.getAddGold().booleanValue()) {
            this.afterCompleteToAddGold(taskContext);
        }
        if (taskContext.getPushMsg().booleanValue() || taskContext.getPersistenceMsg().booleanValue()) {
            this.afterCompleteToPushMsg(taskContext);
        }
    }

    private KeyGenerator getTaskCompleteNumKey(TaskEnum taskEnum, Long userId) {
        KeyGenerator taskCompleteNumKey = null;
        switch (taskEnum) {
            case TASK_NEWS_READ: {
                taskCompleteNumKey = RedisConfig.NEWS_READ.copy().setKey(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
                break;
            }
            case TASK_NEWS_SHARE: {
                taskCompleteNumKey = RedisConfig.TASK_SHARE_NEWS_NUM.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
                break;
            }
            case TASK_VIDEO_READ: {
                taskCompleteNumKey = RedisConfig.VIDEO_READ_NUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                break;
            }
            case TASK_FIRST_POST_INTIVATION: 
            case TASK_POST_INTIVATION: {
                taskCompleteNumKey = RedisConfig.POST_FORUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                break;
            }
            case TASK_COMMENT_NEWS: {
                taskCompleteNumKey = RedisConfig.NEWS_COMMENT.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                break;
            }
            case TASK_EVERYDAY_SHARE: {
                taskCompleteNumKey = RedisConfig.NEWS_SHARE.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                break;
            }
            case TASK_SIGN_SHARE: {
                taskCompleteNumKey = RedisConfig.SIGN_SHARE_NUM.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                break;
            }
            case TASK_WATCH_VIDEO: {
                taskCompleteNumKey = RedisConfig.WATCH_VIDEO.copy().appendKey((Object)(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())));
                break;
            }
            default: {
                this.logger.error("TASK-ERR--userId:" + userId + ",taskName:" + taskEnum.name());
            }
        }
        return taskCompleteNumKey;
    }

    private void completeDailyTask(Long userId, Byte taskId) {
        Assert.notNull((Object)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.logger.info(LogMarker.BIZ, "[{}]\u5b8c\u6210\u4e86\u4efb\u52a1[{}]", (Object)userId, (Object)taskId);
        KeyGenerator key = this.getDailyTaskCacheKey(userId);
        this.redisHashMapAdapter.put(key, taskId.toString(), (Object)1);
        this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private KeyGenerator getDailyTaskCacheKey(Long userId) {
        return RedisConfig.DAILY_TASK_COMPELE_STATUS.copy().setKey(DateUtils.formatDate((Date)new Date()) + userId);
    }

    private void afterCompleteToAddGold(TaskContext taskContext) {
        AccountGoldParam param = AccountGoldParam.buildAccountGoldParam((Long)taskContext.getUserId(), (Integer)taskContext.getDailyTask().getReward().intValue(), (Long)(taskContext.getRelationId() == null ? null : Long.valueOf(taskContext.getRelationId())), (String)taskContext.getTaskEnum().name(), (String)taskContext.getContent());
        TransferAddGoldCommand transferAddGoldCommand = TransferAddGoldCommand.buildTransferAddGoldCommand(param);
        ((TaskInvoke)((Object)taskInvokeThreadLocal.get())).setCommand(transferAddGoldCommand);
    }

    protected abstract boolean isSupportPushMessage();

    protected long getTaskReward(TaskContext taskContext) {
        return 0L;
    }
}

