/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.strategy.dailyConcreteStrategy;

import com.bxm.localnews.activity.domain.BrowseRecordMapper;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.strategy.dailyConcreteStrategy.AbstractDailyTaskStrategy;
import com.bxm.localnews.activity.vo.BrowseRecord;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class NewsBrowseTaskStrategy
extends AbstractDailyTaskStrategy {
    public NewsBrowseTaskStrategy(RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, NewsProperties newsProperties, UserIntegrationService userIntegrationService, BrowseRecordMapper browseRecordMapper) {
        super(redisStringAdapter, redisHashMapAdapter, newsProperties, userIntegrationService, browseRecordMapper);
    }

    @Override
    public boolean support(TaskEnum taskEnum) {
        return taskEnum.equals((Object)TaskEnum.TASK_FIRST_BROWSE);
    }

    @Override
    protected Message customJudge(TaskContext taskContext) {
        if (taskContext.getUserId().equals(Long.valueOf(taskContext.getRelationId()))) {
            return Message.build((boolean)false, (String)"\u81ea\u5df1\u9605\u8bfb\u81ea\u5df1\u5206\u4eab\u7684\u6587\u7ae0\u4e0d\u505a\u5956\u52b1\u5904\u7406!");
        }
        User user = this.userIntegrationService.selectByPrimaryKey(Long.valueOf(taskContext.getRelationId()));
        if (user == null) {
            return Message.build((boolean)false, (String)("\u6d4f\u89c8\u4eba[{" + taskContext.getRelationId() + "}]\u4e0d\u5b58\u5728!"));
        }
        taskContext.addParam("user", (Object)user);
        return Message.build((boolean)true);
    }

    @Override
    protected NewsMissionRewardDto processing(TaskContext taskContext) {
        String relationId = taskContext.getRelationId();
        Long userId = taskContext.getUserId();
        User user = (User)taskContext.getParamMap().get("user");
        String browseUserType = this.getBrowseUserType(user.getWeixin());
        int reward = this.getReward(user.getWeixin());
        DailyTask dailyTask = taskContext.getDailyTask();
        dailyTask.setReward(BigDecimal.valueOf(reward));
        byte isAward = 0;
        Date browseTime = DateUtils.parse((String)DateUtils.formatAtWill((Date)new Date(), (String)"yyyy-MM-dd"));
        BrowseRecord browseRecord = this.browseRecordMapper.selectBrowseRecord(Long.valueOf(relationId), browseTime, Byte.valueOf((byte)1));
        Long recordId = this.nextId();
        if (browseRecord == null) {
            this.logger.info("\u6d4f\u89c8\u4eba[{}]\u4eca\u5929\u8fd8\u672a\u6d4f\u89c8\u4efb\u4f55\u7528\u6237\u7684\u5206\u4eab\u5185\u5bb9----\u7ed9\u5206\u4eab\u4eba[{}]\u6dfb\u52a0\u91d1\u5e01[{}],\u5efa\u7acb\u5173\u7cfb\u7684id\uff1a[{}]", new Object[]{relationId, userId, reward, recordId});
            taskContext.setAddGold(Boolean.valueOf(true));
            isAward = 1;
        }
        BrowseRecord br = new BrowseRecord(recordId, userId, Long.valueOf(relationId), null, browseTime, browseUserType, Byte.valueOf(isAward), Integer.valueOf(reward));
        this.browseRecordMapper.insert(br);
        if (isAward == 0) {
            return this.convertTask(taskContext.getTaskEnum(), 0L, userId);
        }
        return this.convertTask(taskContext.getTaskEnum(), Long.valueOf(reward), userId);
    }

    private String getBrowseUserType(String weixin) {
        String browseUserType = "OLD_USER";
        if (StringUtils.isEmpty((CharSequence)weixin)) {
            browseUserType = "NEW_USER";
        }
        return browseUserType;
    }

    private int getReward(String weixin) {
        int reward = StringUtils.isEmpty((CharSequence)weixin) ? RandomUtils.nextInt((int)20, (int)50) : 3;
        return reward;
    }

    @Override
    protected boolean isSupportPushMessage() {
        return false;
    }
}

