/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.strategy.dailyConcreteStrategy;

import com.bxm.localnews.activity.domain.BrowseRecordMapper;
import com.bxm.localnews.activity.domain.SignRecordMapper;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.dto.SignCompleTaskDTO;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.strategy.dailyConcreteStrategy.AbstractDailyTaskStrategy;
import com.bxm.localnews.activity.vo.SignRecord;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsSignShareTaskStrategy
extends AbstractDailyTaskStrategy {
    private final SignRecordMapper signRecordMapper;

    @Autowired
    public NewsSignShareTaskStrategy(RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, NewsProperties newsProperties, UserIntegrationService userIntegrationService, BrowseRecordMapper browseRecordMapper, SignRecordMapper signRecordMapper) {
        super(redisStringAdapter, redisHashMapAdapter, newsProperties, userIntegrationService, browseRecordMapper);
        this.signRecordMapper = signRecordMapper;
    }

    @Override
    public boolean support(TaskEnum taskEnum) {
        return taskEnum.equals((Object)TaskEnum.TASK_SIGN_SHARE);
    }

    @Override
    protected Message customJudge(TaskContext taskContext) {
        Message msg = this.judgeIsOverRewardCount(taskContext);
        if (!msg.isSuccess()) {
            return msg;
        }
        SignRecord signRecord = this.signRecordMapper.getLastSignRecord(taskContext.getUserId());
        if (signRecord == null || !signRecord.getSignDate().equals(DateUtils.clearTimePart((Date)new Date()))) {
            return Message.build((boolean)false, (String)("\u8be5\u7528\u6237[{" + taskContext.getUserId() + "}]\u4eca\u65e5\u6ca1\u6709\u7b7e\u5230\uff0c\u65e0\u6cd5\u83b7\u5f97\u5956\u52b1!"));
        }
        long signReward = Math.toIntExact(signRecord.getSignReward());
        taskContext.addParam("signReward", (Object)signReward);
        return Message.build((boolean)true);
    }

    @Override
    protected boolean isSupportPushMessage() {
        return false;
    }

    @Override
    protected NewsMissionRewardDto processing(TaskContext taskContext) {
        NewsMissionRewardDto newsMissionRewardDto = this.defaultProcess(taskContext);
        return this.convertTask(taskContext, newsMissionRewardDto);
    }

    private NewsMissionRewardDto convertTask(TaskContext taskContext, NewsMissionRewardDto newsMissionRewardDto) {
        SignCompleTaskDTO result = new SignCompleTaskDTO();
        result.setTaskName(newsMissionRewardDto.getTaskName());
        result.setGoldNum(newsMissionRewardDto.getGoldNum());
        result.setTotalGold(newsMissionRewardDto.getTotalGold());
        if (newsMissionRewardDto.getGoldNum() >= 0L) {
            result.setRewardChooses(this.getRewardChoose(taskContext));
        }
        return result;
    }

    private List<SignCompleTaskDTO.RewardChoose> getRewardChoose(TaskContext taskContext) {
        int other2;
        int other1;
        int signReward = Math.toIntExact((Long)taskContext.getParam("signReward"));
        int reward = taskContext.getDailyTask().getReward().intValue();
        int min = reward / 2;
        if (!this.redisHashMapAdapter.exists(RedisConfig.IS_SIGN_SHARE.copy(), String.valueOf(taskContext.getUserId())).booleanValue()) {
            other1 = RandomUtils.nextInt((int)min, (int)reward);
            other2 = RandomUtils.nextInt((int)min, (int)other1);
            this.redisHashMapAdapter.put(RedisConfig.IS_SIGN_SHARE.copy(), String.valueOf(taskContext.getUserId()), (Object)DateUtils.formatDate((Date)new Date()));
        } else {
            other1 = RandomUtils.nextInt((int)min, (int)reward);
            other2 = RandomUtils.nextInt((int)min, (int)(signReward * 10));
        }
        SignCompleTaskDTO.RewardChoose rewardChoose1 = this.getRewardChoose(reward, signReward, true);
        SignCompleTaskDTO.RewardChoose rewardChoose2 = this.getRewardChoose(other1, signReward, false);
        SignCompleTaskDTO.RewardChoose rewardChoose3 = this.getRewardChoose(other2, signReward, false);
        ArrayList<SignCompleTaskDTO.RewardChoose> rewardChooseSet = new ArrayList<SignCompleTaskDTO.RewardChoose>();
        rewardChooseSet.add(rewardChoose1);
        rewardChooseSet.add(rewardChoose2);
        rewardChooseSet.add(rewardChoose3);
        return rewardChooseSet;
    }

    private SignCompleTaskDTO.RewardChoose getRewardChoose(int reward, int signReward, boolean isSelected) {
        BigDecimal signRewardBig;
        BigDecimal rewardBig = BigDecimal.valueOf(reward);
        BigDecimal bigDecimal = rewardBig.divide(signRewardBig = BigDecimal.valueOf(signReward), 1, RoundingMode.HALF_UP);
        float multiple = bigDecimal.compareTo(BigDecimal.TEN) >= 0 ? (float)bigDecimal.intValue() : bigDecimal.floatValue();
        return new SignCompleTaskDTO.RewardChoose(Integer.valueOf(reward), Float.valueOf(multiple), isSelected);
    }

    @Override
    protected long getTaskReward(TaskContext taskContext) {
        int min = taskContext.getDailyTask().getReward().intValue();
        int max = taskContext.getDailyTask().getRewardLimit().intValue();
        long signReward = (Long)taskContext.getParam("signReward");
        if (!this.redisHashMapAdapter.exists(RedisConfig.IS_SIGN_SHARE.copy(), String.valueOf(taskContext.getUserId())).booleanValue()) {
            if ((long)max >= signReward * 10L) {
                return signReward * 10L;
            }
            return max;
        }
        if ((long)max >= signReward * 10L) {
            return RandomUtils.nextInt((int)min, (int)Math.toIntExact(signReward * 10L));
        }
        return RandomUtils.nextInt((int)min, (int)max);
    }
}

