/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.task;

import com.bxm.localnews.activity.common.config.HelpInfoProperties;
import com.bxm.localnews.activity.config.BaConfig;
import com.bxm.localnews.activity.domain.HelpInfoMapper;
import com.bxm.localnews.activity.vo.HelpUserInfo;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.PushMsgIntegrationService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HelpRemindTask
extends AbstractTaskCallback<String> {
    private static final Logger log = LoggerFactory.getLogger(HelpRemindTask.class);
    @Resource
    private HelpInfoMapper helpInfoMapper;
    @Resource
    private ScheduleService scheduleService;
    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Resource
    private HelpInfoProperties helpInfoProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private BaConfig baConfig;
    @Resource
    private BaseUrlFacadeService baseUrlFacadeService;

    protected ReturnT<String> service(String param) {
        log.info("\u84dd\u5929\u6551\u63f4\u961f\u5b9a\u65f6\u63d0\u9192\u4efb\u52a1\u53c2\u6570\uff1a{}", (Object)param);
        if (StringUtils.isBlank((CharSequence)param)) {
            return ReturnT.FAIL;
        }
        List userIdList = this.helpInfoMapper.getHelpUserIdList();
        Date endTime = DateUtils.parse((String)param);
        if (new Date().after(endTime)) {
            this.pushMsgIntegrationService.pushHelpActivityEndMsg(this.helpInfoProperties.getPostDetail(), userIdList);
            this.scheduleService.remove(this.beanName());
            return ReturnT.SUCCESS;
        }
        if (this.redisStringAdapter.hasKey(RedisConfig.BLUE_SKY_HELP_COMPLETE.copy()).booleanValue()) {
            return ReturnT.SUCCESS;
        }
        if (CollectionUtils.isNotEmpty((Collection)userIdList)) {
            Integer dayNum = DateUtils.getDiffDays((Date)new Date(), (Date)endTime, (boolean)true) + 1;
            for (Long userId : userIdList) {
                HelpUserInfo helpUserInfo = this.helpInfoMapper.getHelpUserInfo(userId);
                String url = StringUtils.join((Object[])new Serializable[]{this.baseUrlFacadeService.getContentViewSceneBaseUrl(), this.baConfig.getBlueSkySharePage(), "?userId=", userId, "&areaCode=", helpUserInfo.getLocationCode(), "&areaName=", helpUserInfo.getLocationName()});
                this.pushMsgIntegrationService.pushHelpActivityNearlyEndMsg(dayNum, url, userId);
            }
        }
        return ReturnT.SUCCESS;
    }
}

