/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.task;

import com.bxm.localnews.activity.common.constant.RankEnum;
import com.bxm.localnews.activity.rank.RankSelfService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncRankTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(SyncRankTask.class);
    @Autowired
    private RankSelfService rankSelfService;
    @Autowired
    RedisHashMapAdapter redisHashMapAdapter;

    protected ReturnT<String> service(String s) {
        KeyGenerator forumKey = RedisConfig.RANK_LIST.copy().appendKey((Object)RankEnum.FORUM.name().toLowerCase());
        this.redisHashMapAdapter.keys(forumKey).forEach(areaCode -> this.rankSelfService.loadForumRankFromDb((String)areaCode));
        KeyGenerator interactKey = RedisConfig.RANK_LIST.copy().appendKey((Object)RankEnum.INTERACT.name().toLowerCase());
        this.redisHashMapAdapter.keys(interactKey).forEach(areaCode -> this.rankSelfService.loadInteractRankFromDb((String)areaCode));
        KeyGenerator inviteKey = RedisConfig.RANK_LIST.copy().appendKey((Object)RankEnum.INVITE.name().toLowerCase());
        this.redisHashMapAdapter.keys(inviteKey).forEach(areaCode -> this.rankSelfService.loadInviteRankFromDb((String)areaCode));
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "syncRankTask";
    }

    public String cron() {
        return "0 0 /2 * * ? ";
    }

    public String description() {
        return "\u540c\u6b65\u699c\u5355\u6570\u636e";
    }
}

