/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.vote.impl;

import com.bxm.localnews.activity.domain.VoteChoiceCountMapper;
import com.bxm.localnews.activity.domain.VoteChoiceRecordMapper;
import com.bxm.localnews.activity.domain.VoteMapper;
import com.bxm.localnews.activity.domain.VoteOptionsMapper;
import com.bxm.localnews.activity.dto.VoteDetailDTO;
import com.bxm.localnews.activity.dto.VoteOptionDTO;
import com.bxm.localnews.activity.param.VoteParam;
import com.bxm.localnews.activity.param.VotePinParam;
import com.bxm.localnews.activity.vo.VoteBean;
import com.bxm.localnews.activity.vo.VoteChoiceCountBean;
import com.bxm.localnews.activity.vo.VoteOptionsBean;
import com.bxm.localnews.activity.vote.VoteService;
import com.bxm.localnews.activity.vote.strategy.IVoteStrategy;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoteServiceImpl
extends BaseService
implements VoteService {
    private final VoteMapper voteMapper;
    private final VoteOptionsMapper voteOptionsMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final VoteChoiceRecordMapper voteChoiceRecordMapper;
    private final VoteChoiceCountMapper voteChoiceCountMapper;
    private Map<String, IVoteStrategy> voteStrategyMap;
    private static final long EXPIRE_SECOND = 86400L;
    private static final long TEMP_EXPIRE_SECOND = 3600L;

    @Autowired
    public VoteServiceImpl(VoteMapper voteMapper, VoteOptionsMapper voteOptionsMapper, RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, VoteChoiceRecordMapper voteChoiceRecordMapper, VoteChoiceCountMapper voteChoiceCountMapper) {
        this.voteMapper = voteMapper;
        this.voteOptionsMapper = voteOptionsMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.voteChoiceRecordMapper = voteChoiceRecordMapper;
        this.voteChoiceCountMapper = voteChoiceCountMapper;
    }

    private IVoteStrategy getVoteStrategy(String strategy) {
        if (null == this.voteStrategyMap) {
            Collection voteStrategies = SpringContextHolder.getBeans(IVoteStrategy.class);
            this.voteStrategyMap = Maps.newHashMap();
            voteStrategies.forEach(item -> this.voteStrategyMap.put(item.name(), (IVoteStrategy)item));
        }
        return this.voteStrategyMap.get(strategy);
    }

    @Override
    public VoteDetailDTO addTime(VotePinParam param) {
        Message message;
        VoteDetailDTO detail = this.loadCacheDetail(param.getVoteId());
        if (!detail.getExpired().booleanValue() && !(message = this.getVoteStrategy(detail.getVoteStrategy()).addTime(detail, param)).isSuccess()) {
            this.logger.info(message.getLastMessage());
        }
        return this.syncAndGet(param);
    }

    @Override
    public VoteDetailDTO execVote(VoteParam param) {
        VoteDetailDTO detail = this.loadCacheDetail(param.getVoteId());
        if (!detail.getExpired().booleanValue()) {
            Message message = this.getVoteStrategy(detail.getVoteStrategy()).vote(detail, param);
            if (!message.isSuccess()) {
                this.logger.info(message.getLastMessage());
            }
        } else {
            this.logger.error("\u6295\u7968\u6d3b\u52a8\u5df2\u8fc7\u671f\uff0c\u4ecd\u53d7\u5230\u6295\u7968\u8bf7\u6c42\uff1a[{}]", (Object)param);
        }
        VotePinParam pinParam = new VotePinParam();
        pinParam.setVoteId(param.getVoteId());
        pinParam.setRelationId(param.getRelationId());
        pinParam.setUserId(param.getUserId());
        return this.syncAndGet(pinParam);
    }

    private VoteDetailDTO loadCacheDetail(Long voteId) {
        KeyGenerator key = RedisConfig.VOTE_INFO_KEY.copy().appendKey((Object)voteId);
        VoteDetailDTO detail = (VoteDetailDTO)this.redisStringAdapter.get(key, VoteDetailDTO.class);
        if (detail == null) {
            VoteBean vote = this.voteMapper.selectByPrimaryKey(voteId);
            detail = this.convert(vote);
            List sourceOptions = this.voteOptionsMapper.getByVoteId(voteId);
            if (null != sourceOptions) {
                detail.setOptions(sourceOptions.stream().map(this::convert).collect(Collectors.toList()));
            }
            this.redisStringAdapter.set(key, (Object)detail, 86400L);
        } else if (!detail.getExpired().booleanValue() && DateUtils.before((Date)detail.getEndTime(), (Date)new Date())) {
            detail.setExpired(Boolean.valueOf(true));
            this.redisStringAdapter.set(key, (Object)detail, 86400L);
        }
        return detail;
    }

    private VoteDetailDTO convert(VoteBean vote) {
        boolean expired = DateUtils.before((Date)vote.getEndTime(), (Date)new Date());
        String title = vote.getTitle();
        if ("CHECKBOX".equals(vote.getOptionType())) {
            title = title + "\uff08\u591a\u9009\uff09";
        }
        return VoteDetailDTO.builder().voteId(vote.getId()).optionType(vote.getOptionType()).layoutType(vote.getLayoutType()).name(title).voteStrategy(vote.getVoteStrategy()).endTime(vote.getEndTime()).max(vote.getMaxPoll()).expired(Boolean.valueOf(expired)).build();
    }

    private VoteOptionDTO convert(VoteOptionsBean option) {
        return VoteOptionDTO.builder().text(option.getText()).imgUrl(option.getImgUrl()).optionId(option.getId()).build();
    }

    @Override
    public VoteDetailDTO syncAndGet(VotePinParam param) {
        VoteDetailDTO detail = this.loadCacheDetail(param.getVoteId());
        this.fill(detail, param);
        this.getVoteStrategy(detail.getVoteStrategy()).deal(detail, param);
        return detail;
    }

    private String[] loadLastChoice(VotePinParam param) {
        String userId = param.getUserId().toString();
        KeyGenerator key = RedisConfig.LAST_VOTE_KEY.copy().appendKey((Object)param.getVoteId()).appendKey((Object)userId);
        String options = (String)this.redisStringAdapter.get(key, String.class);
        if (null == options) {
            List choiceOptionIds = this.voteChoiceRecordMapper.lastChoice(param);
            Object[] optionArray = new String[choiceOptionIds.size()];
            int index = 0;
            for (Long optionId : choiceOptionIds) {
                optionArray[index++] = optionId.toString();
            }
            if (choiceOptionIds.size() == 0) {
                this.redisStringAdapter.set(key, (Object)"", 3600L);
            } else {
                this.redisStringAdapter.set(key, (Object)StringUtils.join((Object[])optionArray, (String)","), 86400L);
            }
            return optionArray;
        }
        if ("".equals(options)) {
            return new String[0];
        }
        return StringUtils.split((String)options, (String)",");
    }

    private Map<String, Long> loadChoiceTotal(VotePinParam param, VoteDetailDTO detail) {
        KeyGenerator key = RedisConfig.VOTE_OPTIONS_KEY.copy().appendKey((Object)param.getVoteId());
        Map voteOptionMap = this.redisHashMapAdapter.entries(key, Long.class);
        if (voteOptionMap == null || voteOptionMap.size() == 0) {
            voteOptionMap = Maps.newHashMap();
            List choiceCountList = this.voteChoiceCountMapper.selectByParam(param);
            if (choiceCountList.size() == 0) {
                for (VoteOptionDTO option : detail.getOptions()) {
                    voteOptionMap.put(option.getOptionId().toString(), 0L);
                }
            } else {
                for (VoteChoiceCountBean choiceCount : choiceCountList) {
                    voteOptionMap.put(choiceCount.getOptionId().toString(), Long.valueOf(choiceCount.getTotal().intValue()));
                }
            }
            this.redisHashMapAdapter.putAll(key, voteOptionMap);
            this.redisHashMapAdapter.expire(key, 86400L);
        }
        return voteOptionMap;
    }

    private void fill(VoteDetailDTO detail, VotePinParam param) {
        Map<String, Long> voteOptionMap = this.loadChoiceTotal(param, detail);
        Object[] optionArray = this.loadLastChoice(param);
        long sum = voteOptionMap.values().stream().mapToLong(l -> l).sum();
        for (VoteOptionDTO option : detail.getOptions()) {
            String optionIdStr = option.getOptionId().toString();
            Long cacheData = voteOptionMap.get(optionIdStr);
            long total = null == cacheData ? 0L : cacheData;
            option.setTotal(Long.valueOf(total));
            option.setChecked(Boolean.valueOf(ArrayUtils.contains((Object[])optionArray, (Object)optionIdStr)));
            if (total == 0L || sum == 0L) {
                option.setPercent(Long.valueOf(0L));
                continue;
            }
            double percent = (double)total / (double)sum * 100.0;
            if (percent < 1.0) {
                option.setPercent(Long.valueOf(1L));
                continue;
            }
            option.setPercent(Long.valueOf(Math.round(percent)));
        }
    }
}

