/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.vote.strategy.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.activity.domain.VoteChoiceCountMapper;
import com.bxm.localnews.activity.domain.VoteChoiceRecordMapper;
import com.bxm.localnews.activity.dto.VoteDetailDTO;
import com.bxm.localnews.activity.param.VoteParam;
import com.bxm.localnews.activity.param.VotePinParam;
import com.bxm.localnews.activity.vo.VoteChoiceCountBean;
import com.bxm.localnews.activity.vo.VoteChoiceRecordBean;
import com.bxm.localnews.activity.vote.strategy.IVoteStrategy;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractVoteStrategy
implements IVoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractVoteStrategy.class);
    static final String VOTE_TOTAL = "vt";
    static final String TIMES = "t";
    @Autowired
    protected RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    protected RedisStringAdapter redisStringAdapter;
    @Autowired
    private SequenceCreater sequenceCreater;

    abstract KeyGenerator buildKey(Long var1, Long var2);

    abstract void expired(KeyGenerator var1, Date var2);

    @Override
    public Message addTime(VoteDetailDTO detail, VotePinParam param) {
        KeyGenerator key = this.buildKey(param.getUserId(), param.getVoteId());
        Map userVoteMap = this.redisHashMapAdapter.entries(key, Long.class);
        Long voteTotal = (Long)userVoteMap.get(VOTE_TOTAL);
        Long times = (Long)userVoteMap.get(TIMES);
        long max = detail.getMax() + 1;
        if (null != voteTotal && voteTotal >= max) {
            log.info("\u65b0\u589e\u6295\u7968\u6b21\u6570\uff0c\u4f46\u5df2\u8fbe\u5230\u603b\u6570\u4e0a\u9650\uff0c\u4e1a\u52a1\u903b\u8f91\u6709\u95ee\u9898\uff0c\u9700\u8981\u6392\u67e5\u3002\u53c2\u6570\uff1a[{}]", (Object)param);
            return Message.build((boolean)false, (String)"\u5df2\u8fbe\u5230\u6295\u7968\u603b\u6570\u4e0a\u9650");
        }
        if (null != times && times >= max) {
            return Message.build((boolean)false, (String)"\u4eca\u65e5\u53ef\u83b7\u5f97\u7684\u6295\u7968\u6570\u91cf\u8fbe\u5230\u4e0a\u9650");
        }
        this.redisHashMapAdapter.increment(key, TIMES, 1);
        this.expired(key, detail.getEndTime());
        return Message.build();
    }

    @Override
    public Message vote(VoteDetailDTO detail, VoteParam param) {
        KeyGenerator key = this.buildKey(param.getUserId(), param.getVoteId());
        Map userVoteMap = this.redisHashMapAdapter.entries(key, Long.class);
        Long times = (Long)userVoteMap.get(TIMES);
        if (null != times && times == 0L) {
            log.info("\u7528\u6237\u5df2\u65e0\u6295\u7968\u6b21\u6570\uff0c\u6295\u7968\u52a8\u4f5c\u4ecd\u88ab\u8c03\u7528\u3002\u53c2\u6570\uff1a[{}]", (Object)param);
            return Message.build((boolean)false, (String)"\u7528\u6237\u6ca1\u6709\u6295\u7968\u6b21\u6570");
        }
        if (times == null) {
            this.redisHashMapAdapter.put(key, TIMES, (Object)0);
        } else {
            this.redisHashMapAdapter.increment(key, TIMES, -1);
        }
        this.redisHashMapAdapter.increment(key, VOTE_TOTAL, 1);
        this.expired(key, detail.getEndTime());
        this.saveVote(param);
        return Message.build();
    }

    private void saveVote(VoteParam param) {
        String[] optionIdArray = StringUtils.split((String)param.getOptionIds(), (String)",");
        KeyGenerator lastVoteKey = RedisConfig.LAST_VOTE_KEY.copy().appendKey((Object)param.getVoteId()).appendKey((Object)param.getUserId());
        this.redisStringAdapter.set(lastVoteKey, (Object)param.getOptionIds());
        KeyGenerator voteOptionsKey = RedisConfig.VOTE_OPTIONS_KEY.copy().appendKey((Object)param.getVoteId());
        ArrayList choiceCountList = Lists.newArrayList();
        ArrayList choiceRecordList = Lists.newArrayList();
        for (String optionId : optionIdArray) {
            this.redisHashMapAdapter.increment(voteOptionsKey, optionId, 1);
            choiceCountList.add(VoteChoiceCountBean.builder().voteId(param.getVoteId()).relationId(param.getRelationId()).optionId(Long.valueOf(optionId)).build());
            choiceRecordList.add(VoteChoiceRecordBean.builder().createTime(new Date()).id(this.sequenceCreater.nextLongId()).optionId(Long.valueOf(optionId)).relationId(param.getRelationId()).userId(param.getUserId()).voteId(param.getVoteId()).build());
        }
        MybatisBatchBuilder.create(VoteChoiceCountMapper.class, (Collection)choiceCountList).run(VoteChoiceCountMapper::updateCount);
        MybatisBatchBuilder.create(VoteChoiceRecordMapper.class, (Collection)choiceRecordList).run(VoteChoiceRecordMapper::insert);
    }

    void setExpired(VoteDetailDTO detail) {
        detail.setStatus(ButtonStatus.DISABLE.name());
        detail.setStatusLabel("\u6295\u7968\u6d3b\u52a8\u5df2\u7ed3\u675f");
        detail.setSubTitle(null);
        detail.setAction(Action.SHARE.name());
    }

    void setVote(VoteDetailDTO detail) {
        detail.setStatus(ButtonStatus.ENABLE.name());
        detail.setStatusLabel("\u6295\u7968");
        detail.setSubTitle(null);
        detail.setAction(Action.VOTE.name());
        detail.getOptions().forEach(item -> item.setChecked(Boolean.valueOf(false)));
    }

    protected static enum ButtonStatus {
        ENABLE,
        DISABLE;

    }

    protected static enum Action {
        VOTE,
        SHARE;

    }
}

