/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.vote.strategy.impl;

import com.bxm.localnews.activity.dto.VoteDetailDTO;
import com.bxm.localnews.activity.param.VotePinParam;
import com.bxm.localnews.activity.vote.strategy.impl.AbstractVoteStrategy;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DayVoteStrategy
extends AbstractVoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(DayVoteStrategy.class);

    @Override
    KeyGenerator buildKey(Long userId, Long voteId) {
        String subKey = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
        return RedisConfig.USER_VOTE_KEY.copy().appendKey((Object)voteId).appendKey((Object)userId).appendKey((Object)subKey);
    }

    @Override
    void expired(KeyGenerator key, Date endTime) {
        this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds() + RandomUtils.nextLong((long)1000L, (long)100000L));
    }

    @Override
    public void deal(VoteDetailDTO detail, VotePinParam param) {
        KeyGenerator key = this.buildKey(param.getUserId(), param.getVoteId());
        Map userVoteMap = this.redisHashMapAdapter.entries(key, Long.class);
        Long voteTotal = (Long)userVoteMap.get("vt");
        voteTotal = null == voteTotal ? 0L : voteTotal;
        Long times = (Long)userVoteMap.get("t");
        long max = detail.getMax() + 1;
        if (detail.getExpired().booleanValue()) {
            this.setExpired(detail);
        } else if (null == times || times > 0L) {
            this.setVote(detail);
        } else if (max > voteTotal) {
            long haveTimes = max - voteTotal;
            detail.setStatus(AbstractVoteStrategy.ButtonStatus.ENABLE.name());
            detail.setStatusLabel("\u4f60\u5df2\u6295\u7968\uff0c\u70b9\u51fb\u5206\u4eab\u53ef\u518d\u6295\u4e00\u6b21\u54e6");
            detail.setSubTitle("\u4eca\u65e5\u8fd8\u53ef\u518d\u6295" + haveTimes + "\u6b21");
            detail.setAction(AbstractVoteStrategy.Action.SHARE.name());
        } else if (voteTotal >= max) {
            detail.setStatus(AbstractVoteStrategy.ButtonStatus.DISABLE.name());
            detail.setStatusLabel("\u4f60\u5df2\u6295\u7968");
            detail.setSubTitle("\u4eca\u65e5\u6295\u7968\u6b21\u6570\u5df2\u7528\u5b8c\uff0c\u660e\u65e5\u53ef\u7ee7\u7eed\u6295\u54e6");
            detail.setAction(AbstractVoteStrategy.Action.SHARE.name());
        }
    }

    @Override
    public String name() {
        return "DAY";
    }
}

