package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.dto.WithdrawFlowDTO;
import com.bxm.localnews.admin.dto.WithdrawUserInfo;
import com.bxm.localnews.admin.param.WithdrawParam;
import com.bxm.localnews.admin.service.activity.WithdrawService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/3/4 19:20
 * @desc
 */
@Api(tags = "1-33 [管理]提现管理", description = "提现的相关操作")
@RestController
@RequestMapping("api/admin/withdraw")
public class WithdrawController {

    @Autowired
    private WithdrawService withdrawService;

    @ApiOperation(value = "1-33-1 获取用户提现列表", notes = "根据输入参数获取对应的提现数据")
    @GetMapping("/list")
    public Json<PageWarper<WithdrawFlowDTO>> getWithdrawalList(WithdrawParam withdrawParam) {
        return ResultUtil.genSuccessResult(withdrawService.getWithdrawList(withdrawParam));
    }

    @ApiOperation(value = "1-32-2 获取用户提现详情", notes = "")
    @GetMapping("/detail")
    public Json<WithdrawUserInfo> getWithdraw(Long id) {
        return ResultUtil.genSuccessResult(this.withdrawService.getWithdrawUserInfo(id));
    }

    @ApiOperation(value = "1-32-3 用户提现直接通过")
    @ApiImplicitParam(name = "id", value = "提现ID", required = true)
    @PostMapping("/pass")
    public Json userPassWithdrawal(long id) {
        this.withdrawService.userPassWithdrawal(id);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "1-32-4 用户提现延迟审核")
    @ApiImplicitParam(name = "id", value = "提现ID", required = true)
    @PostMapping("/delay")
    public Json userCheckWithdrawal(long id) {
        this.withdrawService.userCheckWithdrawal(id);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "1-32-5 获取提现用户相关信息")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @GetMapping("/user")
    public Json withdrawalUserInfo(long userId) {
        return ResultUtil.genSuccessMsg();
    }
}
