package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.ToolsDTO;
import com.bxm.localnews.admin.param.ToolsParam;
import com.bxm.localnews.admin.service.base.AdminToolsService;
import com.bxm.localnews.admin.vo.Tools;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhaoyadong 2018/10/22 20:50
 * @desc
 */
@Api(tags = "1-10 [管理]工具管理", description = "工具管理的相关操作")
@RestController
@RequestMapping("api/admin/tools")
public class AdminToolsController {

    private AdminToolsService adminToolsService;

    @Autowired
    public AdminToolsController(AdminToolsService adminToolsService) {
        this.adminToolsService = adminToolsService;
    }

    @ApiOperation(value = "1-10-1 获取工具列表", notes = "根据输入参数获取对应的工具数据")
    @GetMapping("/list")
    public Json<PageWarper<ToolsDTO>> getToolsList(ToolsParam toolsParam) {
        return ResultUtil.genSuccessResult(this.adminToolsService.getToolsList(toolsParam));
    }

    @ApiOperation(value = "1-10-2 获取工具详情", notes = "")
    @GetMapping("/detail")
    public Json<ToolsDTO> getToolsById(Long id) {
        return ResultUtil.genSuccessResult(this.adminToolsService.getToolsById(id));
    }

    @ApiOperation(value = "1-10-3 工具批量上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id字符串，以”,“分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("batchUpdateStatus")
    public Json updateToolsStatusByIds(String ids, Byte status) {
        if (StringUtils.isBlank(ids)) {
            return ResultUtil.genFailedResult("工具id列表为空");
        }
        String[] id = ids.split(",");
        if (this.adminToolsService.updateToolsStatusById(id, status) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-10-4 工具上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("updateStatus")
    public Json updateToolsStatusById(Long id, Byte status) {
        if (this.adminToolsService.updateToolsStatusById(id, status) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-10-5 新增或编辑工具", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCodes", value = "地区编码字符串,以“,”分隔")
    })
    @PostMapping("saveOrUpdateTools")
    public Json addAdvertDetail(Tools tools, @RequestParam(required = false) String areaCodes) {
        if (this.adminToolsService.addToolsDetail(tools, areaCodes) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-10-6 删除工具", notes = "")
    @PostMapping("deleteTools")
    public Json deleteTools(Long id) {
        if (this.adminToolsService.deleteTools(id) > 0) {
            return ResultUtil.genSuccessMsg("删除成功");
        }
        return ResultUtil.genFailedResult("删除失败");
    }
}
