package com.bxm.localnews.admin.controller.forum;

import com.bxm.localnews.admin.param.ForumParam;
import com.bxm.localnews.admin.service.forum.ForumService;
import com.bxm.localnews.admin.vo.Forum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "1-40 [管理]版块管理", description = "版块管理")
@RestController
@RequestMapping("api/admin/forum")
public class ForumController extends BaseController {

    @Resource
    private ForumService forumService;

    @ApiOperation(value = "1-40-1 获取版块列表")
    @GetMapping("list")
    public Json<PageWarper<Forum>> getList(ForumParam param) {
        return ResultUtil.genSuccessResult(forumService.getList(param));
    }

    @ApiOperation(value = "1-40-2 获取版块详情")
    @GetMapping("detail")
    public Json<Forum> getForumById(Long id) {
        return ResultUtil.genSuccessResult(forumService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-40-3 版块上下架")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态：0下架 1上架", required = true)
    })
    @PostMapping("updateStatus")
    public Json updateStatusById(Long id, Byte status) {
        return ResultUtil.genSuccessResult(forumService.updateStatus(id, status));
    }

    @ApiOperation(value = "1-40-4 新增或编辑版块")
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdate(@RequestBody Forum forum) {
        return ResultUtil.genSuccessResult(forumService.saveOrUpdate(forum));
    }

    @ApiOperation(value = "1-40-5 修改版块权重")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "order", value = "权重", required = true)
    })
    @PostMapping("updateOrder")
    public Json updateOrderById(Long id, Integer order) {
        return ResultUtil.genSuccessResult(forumService.updateOrder(id, order));
    }

    @ApiOperation(value = "1-40-6 获取简单版块列表")
    @GetMapping("getSimpleList")
    public Json<List<Forum>> getSimpleList() {
        return ResultUtil.genSuccessResult(forumService.getSimpleList());
    }

}

