package com.bxm.localnews.admin.controller.news;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminOpinionInfoDTO;
import com.bxm.localnews.admin.param.AdminOpinionInfoParam;
import com.bxm.localnews.admin.service.news.AdminOpinionService;
import com.bxm.localnews.admin.vo.AdminUser;
import com.bxm.localnews.admin.vo.Feedback;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;

@Api(tags = "1-09 [管理]用户意见反馈", description = "用户反馈的意见回复与查询")
@Controller
@RequestMapping("api/admin/opinion")
public class AdminOpinionController extends CommonController {

    private final static Logger logger = LoggerFactory.getLogger(AdminOpinionController.class);

    @Resource
    private AdminOpinionService adminOpinionService;

    @ApiOperation(value = "1-9-1 意见反馈列表", notes = "获取列表")
    @RequestMapping(value = "queryOpinionList", method = RequestMethod.GET)
    @ResponseBody
    public Json<PageWarper<AdminOpinionInfoDTO>> queryOpinionList(AdminOpinionInfoParam param) {

        return ResultUtil.genSuccessResult(this.adminOpinionService.queryOpinions(param));
    }

    @ApiOperation(value = "1-9-2 更新反馈内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id"),
            @ApiImplicitParam(name = "feedback", value = "反馈内容")
    })
    @RequestMapping(value = "updateOpinionInfo", method = RequestMethod.GET)
    @ResponseBody
    public Json updateOpinionInfo(@RequestParam(value = "id", required = false) String id,
                                  @RequestParam(value = "feedback", required = false) String feedback) {
        if (StringUtils.isEmpty(String.valueOf(id))) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数错误");
        }
        try {
            AdminUser adminUser = this.getLoginUser();
            Feedback opinionInfo = new Feedback();
            opinionInfo.setId(Long.parseLong(id));
            opinionInfo.setReplyContent(feedback);
            opinionInfo.setReplyUserId((adminUser.getId()));
            opinionInfo.setStatus(1);
            this.adminOpinionService.updateByPrimaryKeySelective(opinionInfo);
            return ResultUtil.genSuccessMsg("处理成功");
        } catch (Exception e) {
            logger.error("updateOpinionInfoError", e);
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "处理失败");
        }
    }

}
