package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.dto.EditorResult;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.oss.service.AliyunOSSService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author zhaoyadong 2018/10/25 16:02
 * @desc
 */
@Api(tags = "1-19 [管理]文件上传管理", description = "文件管理的相关操作")
@RestController
@RequestMapping("api/admin/file")
public class FileController {

    private AliyunOSSService aliyunOSSService;

    @Autowired
    public FileController(AliyunOSSService aliyunOSSService) {
        this.aliyunOSSService = aliyunOSSService;
    }

    @ApiOperation(value = "1-19-1 文件上传", notes = "")
    @PostMapping("/upload")
    public Json<String> uploadFile(@RequestParam(value = "file") MultipartFile multipartFile) {
        return ResultUtil.genSuccessResult(aliyunOSSService.upload(multipartFile) + "?x-oss-process=style/mcompress");
    }

    @ApiOperation(value = "1-19-2 编辑器文件上传", notes = "")
    @PostMapping("/editor/upload")
    public EditorResult editorUploadFile(@RequestParam(value = "files") MultipartFile... multipartFile) {
        return new EditorResult(0, aliyunOSSService.upload(multipartFile));
    }
}
