package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.param.PointMallParam;
import com.bxm.localnews.admin.service.activity.PointMallService;
import com.bxm.localnews.admin.vo.PointMall;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/2/15 14:36
 * @desc
 */
@Api(tags = "1-31 [管理]积分商城配置管理", description = "积分商城配置管理的相关操作")
@RestController
@RequestMapping("api/admin/point/mall")
public class PointMallController {

    @Autowired
    private PointMallService pointMallService;

    @ApiOperation(value = "1-31-1 获取积分商城列表", notes = "根据输入参数获取对应的积分商城数据")
    @GetMapping("/list")
    public Json<PageWarper<PointMall>> getPointMallList(PointMallParam pointMallParam) {
        return ResultUtil.genSuccessResult(this.pointMallService.queryPointMalls(pointMallParam));
    }

    @ApiOperation(value = "1-31-2 获取积分商城详情", notes = "")
    @GetMapping("/detail")
    public Json<PointMall> getPointMall(Long id) {
        return ResultUtil.genSuccessResult(this.pointMallService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-31-3 积分商城上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("updateStatus")
    public Json updatePointMallStatusById(Long id, Byte status) {
        if (this.pointMallService.updatePointMallStatus(id, status) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-31-4 新增或编辑积分商城", notes = "")
    @PostMapping("saveOrUpdatePointMall")
    public Json saveOrUpdatePointMall(PointMall pointMall) {
        if (this.pointMallService.addPointMall(pointMall) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-31-5 根据ID移除商品信息")
    @ApiImplicitParam(name = "id", value = "商品ID", required = true)
    @PostMapping("deletePointMall")
    public Json remove(long id) {
        return Json.build(pointMallService.remove(id));
    }
}
