package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.ChannelDTO;
import com.bxm.localnews.admin.dto.ChannelStatisDTO;
import com.bxm.localnews.admin.param.ChannelParam;
import com.bxm.localnews.admin.service.base.AdminChannelService;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Api(tags = "1-04 [管理]渠道信息管理", description = "渠道信息相关操作")
@RestController
@RequestMapping("api/admin/channel")
public class AdminChannelController {

    @Resource
    private AdminChannelService adminChannelService;

    @ApiOperation(value = "1-4-1 渠道列表", notes = "")
    @GetMapping(value = "channelList")
    public Json<PageWarper<ChannelDTO>> channelList(ChannelParam channelParam) {

        return ResultUtil.genSuccessResult(this.adminChannelService.queryChannelDTOs(channelParam));
    }

    @ApiOperation(value = "1-4-2 新增和编辑功能功能", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "code", value = "code", required = true),
            @ApiImplicitParam(name = "name", value = "名称", required = true),
            @ApiImplicitParam(name = "phone", value = "手机", required = true),
            @ApiImplicitParam(name = "linker", value = "linker", required = true)
    })
    @PostMapping(value = "saveOrUpdate")
    @ResponseBody
    public Json saveOrUpdate(@RequestParam(value = "id", required = false) Long id,
                             @RequestParam(value = "code") String code,
                             @RequestParam(value = "name") String name,
                             @RequestParam(value = "phone") String phone,
                             @RequestParam(value = "linker") String linker) {
        Channel channel = new Channel(code, name, linker, phone, new Date());
        if (id == null) {
            int count = this.adminChannelService.countByCode(code);
            if (count > 0) {
                return ResultUtil.genFailedResult("渠道编码已存在");
            }
            return this.adminChannelService.insertSelective(channel);
        } else {
            Channel c = this.adminChannelService.selectById(id);
            if (!code.equals(c.getCode()) && this.adminChannelService.countByCode(code) > 0) {
                return ResultUtil.genFailedResult("渠道编码已存在");
            }
            channel.setId(id);
            return this.adminChannelService.updateBySelective(channel);
        }
    }

    @ApiOperation(value = "1-4-3 启用和禁用功能")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "channelId", value = "id"),
            @ApiImplicitParam(name = "state", value = "状态")
    })
    @PostMapping(value = "changState")
    @ResponseBody
    public Json changState(@RequestParam("channelId") Long channelId,
                           @RequestParam("state") String state) {
        return this.adminChannelService.changeState(channelId, state);
    }

    @ApiOperation(value = "1-04-4 渠道信息统计", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "current", value = "页码", required = true),
            @ApiImplicitParam(name = "pageSize", value = "数目", required = true)
    })
    @GetMapping(value = "channelStatis")
    @ResponseBody
    public Json<PageWarper<ChannelStatisDTO>> channelStatis(ChannelParam param) {

        return ResultUtil.genSuccessResult(this.adminChannelService.channelStatis(param));
    }

    @ApiOperation(value = "1-04-5 获取所有渠道信息", notes = "")
    @GetMapping(value = "allChannel")
    @ResponseBody
    public Json<List<Channel>> allChannel() {
        return ResultUtil.genSuccessResult(this.adminChannelService.selectAll());
    }

}
