package com.bxm.localnews.admin.controller.forum;

import com.bxm.localnews.admin.param.ForumPostParam;
import com.bxm.localnews.admin.service.forum.ForumPostService;
import com.bxm.localnews.admin.vo.ForumPost;
import com.bxm.localnews.admin.vo.ForumPostApproveHistory;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "1-42 [管理]帖子管理", description = "帖子管理")
@RestController
@RequestMapping("api/admin/forumPost")
public class ForumPostController extends BaseController {

    @Resource
    private ForumPostService forumPostService;

    @ApiOperation(value = "1-42-1 获取帖子审核列表")
    @GetMapping("/listApprove")
    public Json<PageWarper<ForumPost>> getApprovePostList(ForumPostParam param) {
        return ResultUtil.genSuccessResult(forumPostService.getApproveList(param));
    }

    @ApiOperation(value = "1-42-2 获取帖子详情")
    @GetMapping("/detail")
    public Json<ForumPost> getForumPostById(Long id) {
        return ResultUtil.genSuccessResult(forumPostService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-42-3 批量帖子审核")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "帖子id列表，逗号分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态：0拒绝 1通过", required = true),
            @ApiImplicitParam(name = "comment", value = "审核意见", required = false)
    })
    @PostMapping("approve")
    public Json approve(String ids, Byte status, String comment) {
        return ResultUtil.genSuccessResult(forumPostService.approve(ids, status, comment));
    }

    @ApiOperation(value = "1-42-4 新增或编辑帖子")
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdate(@RequestBody ForumPost forumPost) {
        return ResultUtil.genSuccessResult(forumPostService.saveOrUpdate(forumPost));
    }

    @ApiOperation(value = "1-42-5 批量删除或恢复帖子")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "帖子id列表，逗号分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态：1正常 4删除", required = true)
    })
    @PostMapping("deleteOrRecover")
    public Json deleteOrRecover(String ids, Byte status) {
        return ResultUtil.genSuccessResult(forumPostService.deleteOrRecover(ids, status));
    }

    @ApiOperation(value = "1-42-6 获取新增帖子id")
    @GetMapping("/getCreateId")
    public Json<Long> getCreateId() {
        return ResultUtil.genSuccessResult(forumPostService.getCreateId());
    }

    @ApiOperation(value = "1-42-7 获取帖子审核历史列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
            @ApiImplicitParam(name = "action", value = "审批动作：0拒绝，1通过", required = false)
    })
    @GetMapping("/listApproveHistory")
    public Json<List<ForumPostApproveHistory>> getApproveHistoryList(Long id, Integer action) {
        return ResultUtil.genSuccessResult(forumPostService.getApproveHistoryList(id, action));
    }

}

