package com.bxm.localnews.admin.controller.forum;

import com.bxm.localnews.admin.param.TopicParam;
import com.bxm.localnews.admin.service.forum.TopicService;
import com.bxm.localnews.admin.vo.Topic;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "1-41 [管理]话题管理", description = "话题管理")
@RestController
@RequestMapping("api/admin/topic")
public class TopicController extends BaseController {

    @Resource
    private TopicService topicService;

    @ApiOperation(value = "1-41-1 获取话题列表")
    @GetMapping("list")
    public Json<PageWarper<Topic>> getList(TopicParam param) {
        return ResultUtil.genSuccessResult(topicService.getList(param));
    }

    @ApiOperation(value = "1-41-2 获取话题详情")
    @GetMapping("detail")
    public Json<Topic> getTopicById(Long id) {
        return ResultUtil.genSuccessResult(topicService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-41-3 话题上下架删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态：0下架 1上架 2删除", required = true)
    })
    @PostMapping("updateStatus")
    public Json updateStatusById(Long id, Byte status) {
        return ResultUtil.genSuccessResult(topicService.updateStatus(id, status));
    }

    @ApiOperation(value = "1-41-4 新增或编辑话题")
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdate(@RequestBody Topic topic) {
        return ResultUtil.genSuccessResult(topicService.saveOrUpdate(topic));
    }

    @ApiOperation(value = "1-40-5 修改话题权重")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "order", value = "权重", required = true)
    })
    @PostMapping("updateOrder")
    public Json updateOrderById(Long id, Integer order) {
        return ResultUtil.genSuccessResult(topicService.updateOrder(id, order));
    }

    @ApiOperation(value = "1-40-6 获取简单话题列表")
    @GetMapping("getSimpleList")
    public Json<List<Topic>> getSimpleList() {
        return ResultUtil.genSuccessResult(topicService.getSimpleList());
    }
}

