package com.bxm.localnews.admin.controller.news;

import com.bxm.localnews.admin.service.news.NewsService;
import com.bxm.localnews.admin.service.news.VideoService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "1-22 新闻（视频）黑名单管理", description = "新闻（视频）黑名单管理的相关操作")
@RestController
@RequestMapping("api/admin")
public class AdminBlackListController extends BaseController {

    private NewsService newsService;

    private VideoService videoService;

    @Autowired
    public AdminBlackListController(NewsService newsService, VideoService videoService) {
        this.newsService = newsService;
        this.videoService = videoService;
    }

//    @PostMapping(value = "/news/list")
//    @ApiOperation(value = "1-22-01 根据关键字获取新闻分页列表", notes = "根据关键字获取新闻列表")
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "title", value = "标题"),
//            @ApiImplicitParam(name = "status", value = "状态 2:已下架 其他为正常"),
//            @ApiImplicitParam(name = "pageNum", value = "分页当前页", required = true),
//            @ApiImplicitParam(name = "pageSize", value = "分页大小", required = true)
//    })
//    public Json<PageWarper<News>> pageNewsList(@RequestParam(value = "title", required = false) String title,
//                                               @RequestParam(value = "status", required = false) Integer status,
//                                               @RequestParam("pageNum") Integer pageNum,
//                                               @RequestParam("pageSize") Integer pageSize) {
//        NewsBlackParam param = new NewsBlackParam();
//        param.setPageNum(pageNum);
//        param.setPageSize(pageSize);
//        param.setTitle(StringUtils.isBlank(title) ? null : title);
//        param.setStatus(status == null ? 1 : status);
//        PageWarper<News> pageInfo = newsService.selectByTitleAndStatus(param);
//        return ResultUtil.genSuccessResult(pageInfo);
//    }


    @PostMapping(value = "/black/news/add")
    @ApiOperation(value = "1-22-03  新增新闻黑名单", notes = "新增新闻黑名单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
            @ApiImplicitParam(name = "remark", value = "备注")
    })
    public Json addNewsBlack(Long id, String remark) {
        newsService.addNewsBlack(id, remark);
        return ResultUtil.genSuccessResult();
    }

    @PostMapping(value = "/black/news/delete")
    @ApiOperation(value = "1-22-07  新增新闻黑名单", notes = "删除新闻黑名单(新闻上架)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
    })
    public Json delNewsBlack(Long id) {
        newsService.delNewsBlack(id);
        return ResultUtil.genSuccessResult();
    }

    @PostMapping(value = "/black/video/add")
    @ApiOperation(value = "1-22-06 新增视频黑名单", notes = "新增视频黑名单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
            @ApiImplicitParam(name = "remark", value = "备注")
    })
    public Json addVideoBlack(Long id, String remark) {
        videoService.addVideoBlack(id, remark);
        return ResultUtil.genSuccessResult();
    }
}
