package com.bxm.localnews.admin.controller.news;

import com.bxm.localnews.admin.param.NewsReplyOriginalParam;
import com.bxm.localnews.admin.param.NewsReplyParam;
import com.bxm.localnews.admin.service.news.AdminNewsReplyService;
import com.bxm.localnews.admin.vo.NewsReply;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-35 [管理]新闻管理中评论管理", description = "新闻评论管理，包括新闻评论的模拟生成，添加，删除")
@RestController
@RequestMapping("api/admin/news/reply")
public class AdminNewsReplyController {

    @Autowired
    private AdminNewsReplyService adminNewsReplyService;

    @ApiOperation("1-35-1 模拟评论生成")
    @PostMapping("/virtual")
    public Json generate(@RequestBody NewsReplyOriginalParam newsReplyOriginalParam) {
        if (newsReplyOriginalParam.getNewsId() != null) {
            this.adminNewsReplyService.doGenerateReply(newsReplyOriginalParam);
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult("请输入新闻编号");
        }
    }

    @ApiOperation("1-35-2 新闻下评论分页")
    @GetMapping("/list")
    public Json<PageWarper<NewsReply>> queryPage(NewsReplyParam newsReplyParam) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.listNewsReply(newsReplyParam));
    }

    @ApiOperation("1-35-3 评论删除")
    @PostMapping("/del")
    public Json del(@RequestParam Long replyId,@RequestParam Long newsId) {
        if (newsId != null) {
            this.adminNewsReplyService.delReply(replyId,newsId);
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult("请输入新闻编号");
        }
    }

}

