package com.bxm.localnews.admin.controller.recommand;

import com.bxm.localnews.admin.dto.MixRecommandDTO;
import com.bxm.localnews.admin.param.MixPoolParam;
import com.bxm.localnews.admin.param.MixRecommandParam;
import com.bxm.localnews.admin.param.MixRecommendTopParam;
import com.bxm.localnews.admin.service.recommend.MixRecommendPoolService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
@Slf4j
@Api(tags = "1-44[管理]推荐池管理", description = "推荐池相关操作")
@RequestMapping("/api/mixRecommand/*")
public class MixRecommendPoolController {

    @Autowired
    private MixRecommendPoolService mixRecommendPoolService;

    @PostMapping("/list")
    @ApiOperation(value = "1-44-01获得推荐库列表" )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "投放地区", required = false),
            @ApiImplicitParam(name = "origin", value = "类型 1：社区帖子2：本地新闻 3：全国新闻", required = false),
            @ApiImplicitParam(name = "title", value = "标题", required = false),
            @ApiImplicitParam(name = "pageSize", value = "每页显示数量 默认值为10", required = false),
            @ApiImplicitParam(name = "pageNum", value = "当前页", required = false)
    })
    public Json< PageWarper<MixRecommandDTO>> getPagenationList(MixRecommandParam mixRecommandParam){
        PageWarper<MixRecommandDTO> pages = mixRecommendPoolService.getPagenationList(mixRecommandParam);
        return ResultUtil.genSuccessResult(pages);
    }

    @GetMapping("/cancelRecommendById")
    @ApiOperation(value = "1-44-02 取消推荐")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
            @ApiImplicitParam(name = "origin", value = "类型 1：社区帖子2：本地新闻 3：全国新闻", required = true)
    })
    public Json cancelRecommendById(MixPoolParam mixPoolParam){
        int result = mixRecommendPoolService.cancelRecommendById(mixPoolParam);
        return ResultUtil.genSuccessMsg("取消推荐成功!");
    }


    @PostMapping("/updateMixRecommandWeight")
    @ApiOperation(value = "1-44-03 修改推荐池权重")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
            @ApiImplicitParam(name = "origin", value = "类型 1：社区帖子2：本地新闻 3：全国新闻", required = true),
            @ApiImplicitParam(name = "weight", value = "权重", required = true)
    })
    public Json updateMixRecommandWeight(MixPoolParam mixPoolParam,Integer weight){
        int result = mixRecommendPoolService.updateMixRecommandWeight(mixPoolParam,weight);
        return ResultUtil.genSuccessMsg("取消推荐成功!");
    }


    @PostMapping("/addTop")
    @ApiOperation(value = "1-44-04 推荐池置顶")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻id,多个新闻id用,分隔", required = true),
            @ApiImplicitParam(name = "newsEffectiveTime", value = "新闻生效时间", required = true),
            @ApiImplicitParam(name = "newsExpireTime", value = "新闻置顶失效时间", required = true),
            @ApiImplicitParam(name = "postId", value = "新闻id,多个新闻id用,分隔", required = true),
            @ApiImplicitParam(name = "postEffectiveTime", value = "新闻生效时间", required = true),
            @ApiImplicitParam(name = "postExpireTime", value = "新闻置顶失效时间", required = true)
    })
    public Json addTop(MixRecommendTopParam mixPoolParam){
        mixRecommendPoolService.addTop(mixPoolParam);
        return ResultUtil.genSuccessMsg("推荐池置顶成功!");
    }





}
