package com.bxm.localnews.admin.controller.security;

import com.bxm.localnews.admin.dto.UserInfoDTO;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.service.base.AdminChannelService;
import com.bxm.localnews.admin.service.security.AdminUserBaseInfoService;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Api(tags = "1-17 [管理]用户管理", description = "用户相关操作")
@RestController
@RequestMapping("api/admin/user")
public class AdminUserManageController {

    @Resource
    private AdminChannelService adminChannelService;

    @Resource
    private AdminUserBaseInfoService adminUserBaseInfoService;

    @ApiOperation(value = "1-17-1 根据条件获取用户信息列表", notes = "")
    @RequestMapping(value = "queryUserInfoList", method = RequestMethod.GET)
    @ResponseBody
    public Json<PageWarper<UserInfoDTO>> queryUserInfoList(UserInfoParam userInfoParam) {
        if (!StringUtils.isEmpty(userInfoParam.getStartTime())) {
            String startTime = userInfoParam.getStartTime() + " 00:00:00";
            userInfoParam.setStartTime(startTime);
        }

        if (!StringUtils.isEmpty(userInfoParam.getEndTime())) {
            String endTime = userInfoParam.getEndTime() + " 23:59:59";
            userInfoParam.setEndTime(endTime);
        }

        return ResultUtil.genSuccessResult(this.adminUserBaseInfoService.queryUserInfoDTO(userInfoParam));
    }

    @ApiOperation(value = "1-17-2 查看用户基本信息", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户id")
    @RequestMapping(value = "queryUserBaseInfoByUserId", method = RequestMethod.GET)
    @ResponseBody
    public Json<User> queryUserInfoByUserId(@RequestParam(value = "userId", required = false) String userId) {

        if (StringUtils.isEmpty(userId)) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数错误");
        }

        User userBaseInfo = this.adminUserBaseInfoService.selectByUserId(Long.parseLong(userId));
        if (userBaseInfo == null) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "用户不存在");
        }

        return ResultUtil.genSuccessResult(userBaseInfo);
    }

    @ApiOperation(value = "1-17-3 设置和取消用户黑名单", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "state", value = "状态")
    })
    @RequestMapping(value = "updateUserBlack", method = RequestMethod.GET)
    @ResponseBody
    public Json updateUserBlack(@RequestParam(value = "userId", required = false) String userId,
                                @RequestParam(value = "state", required = false) String state) {
        if (StringUtils.isEmpty(String.valueOf(userId)) || StringUtils.isEmpty(state)) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数错误");
        }
        Map<String, Object> map = Maps.newHashMap();
        map.put("userId", userId);
        map.put("state", state);

        boolean flag = this.adminUserBaseInfoService.updateUserBlack(map);
        if (flag) {
            return ResultUtil.genSuccessMsg("操作成功");
        } else {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "操作失败");
        }
    }

    @ApiOperation(value = "1-17-4 获取渠道列表", notes = "")
    @RequestMapping(value = "getChannelList", method = RequestMethod.GET)
    @ResponseBody
    public Json<List<Channel>> getChannelList() {
        List<Channel> channelList = this.adminChannelService.selectRegistChannelList();
        return ResultUtil.genSuccessResult(channelList);
    }

    @ApiOperation(value = "1-17-5 删除用户", notes = "")
    @RequestMapping(value = "delete", method = RequestMethod.DELETE)
    public Json deleteUser() {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "1-17-6 获取虚拟用户列表")
    @RequestMapping(value = "getVirtualUserList", method = RequestMethod.GET)
    public Json<List<UserInfoDTO>> getVirtualUserList() {
        return ResultUtil.genSuccessResult(this.adminUserBaseInfoService.getVirtualUserList());
    }
}
