/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.activity;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.dto.RedPacketDTO;
import com.bxm.localnews.admin.param.RedPacketParam;
import com.bxm.localnews.admin.service.activity.RedPacketService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-45 [\u7ba1\u7406]\u53e3\u4ee4\u7ea2\u5305\u76f8\u5173\u63a5\u53e3"}, description="\u7ea2\u5305\u76f8\u5173\u63a5\u53e3")
@RestController
@RequestMapping(value={"api/admin/packet"})
public class RedPacketController {
    private static final Logger LOG = LoggerFactory.getLogger(RedPacketController.class);
    private RedPacketService redPacketService;

    @Autowired
    public RedPacketController(RedPacketService redPacketService) {
        this.redPacketService = redPacketService;
    }

    @ApiOperation(value="1-45-01 \u83b7\u53d6\u7ea2\u5305\u5217\u8868", notes="\u83b7\u53d6\u7ea2\u5305\u5217\u8868")
    @PostMapping(value={"/list"})
    public Json<PageWarper<RedPacketDTO>> getRedPacketList(@RequestBody RedPacketParam redPacketParam) {
        return ResultUtil.genSuccessResult((Object)this.redPacketService.queryList(redPacketParam));
    }

    @ApiOperation(value="1-45-02 \u5ba1\u6838\u7ea2\u5305", notes="\u5ba1\u6838\u7ea2\u5305")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7ea2\u5305id", required=true), @ApiImplicitParam(name="approvalStatus", value="\u5ba1\u6838\u72b6\u6001,1\uff1a\u62d2\u7edd\uff0c2\uff1a\u901a\u8fc7", required=true), @ApiImplicitParam(name="approvalContent", value="\u5ba1\u6838\u5185\u5bb9", required=true)})
    @PostMapping(value={"/approval"})
    public Json approvalRedPacket(Long id, Integer approvalStatus, String approvalContent) {
        if (!this.redPacketService.approvalRedPacket(id, approvalStatus, approvalContent)) {
            LOG.error("\u5ba1\u6838\u7ea2\u5305\u5931\u8d25,\u7ea2\u5305id:{],\u5ba1\u6838\u72b6\u6001:{}", (Object)id, (Object)approvalStatus);
            return ResultUtil.genFailedResult((String)"\u5ba1\u6838\u7ea2\u5305\u5931\u8d25");
        }
        return ResultUtil.genSuccessResult((Object)"\u5ba1\u6838\u7ea2\u5305\u6210\u529f");
    }

    @ApiOperation(value="1-45-03 \u4fee\u6539\u4e0a\u4e0b\u7ebf\u72b6\u6001", notes="\u4fee\u6539\u4e0a\u4e0b\u7ebf\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7ea2\u5305id", required=true), @ApiImplicitParam(name="onlineStatus", value="\u4e0a\u4e0b\u7ebf\u72b6\u6001", required=true)})
    @PostMapping(value={"/status/update"})
    public Json updateOnlineStatus(Long id, Integer onlineStatus) {
        if (!this.redPacketService.updateOnlineStatus(id, onlineStatus)) {
            LOG.error("\u4fee\u6539\u7ea2\u5305\u4e0a\u4e0b\u7ebf\u5931\u8d25,\u7ea2\u5305id:{],\u4e0a\u4e0b\u7ebf\u72b6\u6001:{}", (Object)id, (Object)onlineStatus);
            return ResultUtil.genFailedResult((String)"\u4fee\u6539\u7ea2\u5305\u4e0a\u4e0b\u7ebf\u5931\u8d25");
        }
        return ResultUtil.genSuccessResult((Object)"\u4fee\u6539\u4e0a\u4e0b\u7ebf\u72b6\u6001\u6210\u529f");
    }

    @ApiOperation(value="1-45-04 \u83b7\u53d6\u7ea2\u5305\u8be6\u60c5", notes="\u83b7\u53d6\u7ea2\u5305\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u7ea2\u5305id", required=true)
    @PostMapping(value={"/detail"})
    public Json<RedPacketDTO> getDetail(Long id) {
        RedPacketDTO redPacketDTO = this.redPacketService.getRedPacketDetail(id);
        if (null == redPacketDTO) {
            return ResultUtil.genFailedResult((String)"\u83b7\u53d6\u8be6\u60c5\u4e3a\u7a7a");
        }
        return ResultUtil.genSuccessResult((Object)redPacketDTO);
    }

    @ApiOperation(value="1-45-05 \u7f16\u8f91\u7ea2\u5305", notes="\u7f16\u8f91\u7ea2\u5305")
    @PostMapping(value={"/edit"})
    public Json editRedPacket(@RequestBody RedPacketParam redPacketParam) {
        if (!this.redPacketService.editRedPacket(redPacketParam)) {
            LOG.error("\u7f16\u8f91\u7ea2\u5305\u5931\u8d25,\u7f16\u8f91\u7684\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)redPacketParam));
            return ResultUtil.genFailedResult((String)"\u7f16\u8f91\u7ea2\u5305\u5931\u8d25");
        }
        return ResultUtil.genSuccessResult((Object)"\u7f16\u8f91\u7ea2\u5305\u6210\u529f");
    }
}

