/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.AreaDivisionDTO;
import com.bxm.localnews.admin.dto.AreaInfoDTO;
import com.bxm.localnews.admin.dto.LocationDTO;
import com.bxm.localnews.admin.dto.LocationInfoDTO;
import com.bxm.localnews.admin.param.AreaInfoParam;
import com.bxm.localnews.admin.param.AreaInfoQueryParam;
import com.bxm.localnews.admin.param.LocationParam;
import com.bxm.localnews.admin.service.base.AreaDivisionService;
import com.bxm.localnews.admin.service.base.AreaInfoService;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.vo.AreaInfo;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-03 [\u7ba1\u7406]\u5730\u533a\u7ba1\u7406"}, description="\u5730\u533a\u7ba1\u7406\u7684\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/area"})
public class AdminAreaController
extends BaseController {
    private LocationService locationService;
    private AreaDivisionService areaDivisionService;
    private AreaInfoService areaInfoService;

    @Autowired
    public AdminAreaController(LocationService locationService, AreaDivisionService areaDivisionService, AreaInfoService areaInfoService) {
        this.locationService = locationService;
        this.areaDivisionService = areaDivisionService;
        this.areaInfoService = areaInfoService;
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="1-03-01 \u83b7\u53d6\u6240\u6709\u53ef\u5f00\u901a\u548c\u5df2\u5f00\u901a\u57ce\u5e02")
    public Json<List<LocationDTO>> listLocation(@Valid LocationParam locationParam) {
        return ResultUtil.genSuccessResult((Object)this.locationService.listLocation(locationParam));
    }

    @PostMapping(value={"/{code}/hot"})
    @ApiOperation(value="1-03-02 \u8bbe\u7f6e\u4e3a\u70ed\u95e8\u57ce\u5e02", notes="\u628a\u57ce\u5e02\u8bbe\u4e3a\u70ed\u95e8\u57ce\u5e02\uff0c\u4f7f\u4e4b\u5728\u5ba2\u6237\u7aef\u4ee5\u5217\u8868\u5f62\u5f0f\u5c55\u73b0")
    public Json saveHotLocation(@PathVariable String code) {
        this.locationService.saveHotLocation(code);
        return ResultUtil.genSuccessResult();
    }

    @PostMapping(value={"/{code}/opened"})
    @ApiOperation(value="1-03-03 \u8bbe\u7f6e\u4e3a\u5df2\u5f00\u901a\u57ce\u5e02", notes="\u628a\u57ce\u5e02\u8bbe\u4e3a\u5df2\u5f00\u901a\u57ce\u5e02\uff0c\u4f7f\u4e4b\u5728\u5ba2\u6237\u7aef\u4ee5\u5217\u8868\u5f62\u5f0f\u5c55\u73b0")
    public Json saveOpenedLocation(@PathVariable String code) {
        this.locationService.saveOpenedLocation(code);
        return ResultUtil.genSuccessResult();
    }

    @GetMapping(value={"/{code}/list"})
    @ApiOperation(value="1-03-04 \u83b7\u53d6\u7701\u4e0b\u6240\u6709\u5df2\u5f00\u901a\u57ce\u5e02", notes="\u5728\u5730\u5740\u8054\u52a8\u9009\u62e9\u65f6\uff0c\u5728\u4e0b\u65b9\u663e\u793a\u8be5\u57ce\u5e02\u4e0b\u7684\u5df2\u5f00\u901a\u5730\u533a")
    public Json<List<LocationDTO>> listLocation(@PathVariable String code) {
        return ResultUtil.genSuccessResult((Object)this.locationService.listOpenedLocationByAreaWithTwoLevels(code, Byte.valueOf((byte)1)));
    }

    @GetMapping(value={"/province/{code}/list"})
    @ApiOperation(value="1-03-05 \u4ec5\u83b7\u53d6\u7701\u4efd\u6240\u6709\u5df2\u5f00\u901a\u6216\u53ef\u5f00\u901a\u57ce\u5e02", notes="\u5728\u5730\u5740\u8054\u52a8\u9009\u62e9\u65f6\uff0c\u5728\u4e0b\u65b9\u663e\u793a\u8be5\u57ce\u5e02\u4e0b\u7684\u5df2\u5f00\u901a\u6216\u53ef\u5f00\u901a\u5730\u533a")
    public Json<List<LocationDTO>> listProvinceLocation(@PathVariable String code) {
        return ResultUtil.genSuccessResult((Object)this.locationService.listOpenedLocationByAreaWithTwoLevels(code, null));
    }

    @GetMapping(value={"/info/list"})
    @ApiOperation(value="1-03-06 \u540e\u53f0\u533a\u57df\u7ba1\u7406-\u83b7\u53d6\u6240\u6709\u5730\u57df\u4fe1\u606f", notes="\u5305\u542b\u8986\u76d6\u7387\u548c\u4f20\u64ad\u7387")
    public Json<PageWarper<AreaInfo>> listAreaInfo(AreaInfoQueryParam areaInfoParam) {
        return ResultUtil.genSuccessResult((Object)this.areaInfoService.queryPages(areaInfoParam));
    }

    @PostMapping(value={"/info/add"})
    @ApiOperation(value="1-03-07 \u540e\u53f0\u533a\u57df\u7ba1\u7406-\u65b0\u589e\u5730\u57df\u4fe1\u606f")
    public Json saveAreaInfo(@RequestBody AreaInfoParam areaInfoParam) {
        return Json.build((Message)this.areaInfoService.saveAreaInfo(areaInfoParam));
    }

    @PostMapping(value={"/info/modify"})
    @ApiOperation(value="1-03-08 \u540e\u53f0\u533a\u57df\u7ba1\u7406-\u6839\u636ecode\u4fee\u6539\u5730\u57df\u4fe1\u606f")
    public Json modifyAreaInfo(@RequestBody AreaInfoParam areaInfoParam) {
        int flag = this.areaInfoService.updateAreaInfo(areaInfoParam);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @PostMapping(value={"/info/del/{code}"})
    @ApiOperation(value="1-03-09 \u540e\u53f0\u533a\u57df\u7ba1\u7406-\u6839\u636ecode\u5220\u9664\u5730\u57df\u4fe1\u606f")
    @ApiImplicitParam(name="code", value="\u5730\u533a\u7f16\u7801", required=true)
    public Json delAreaInfo(@PathVariable String code) {
        int flag = this.areaInfoService.delAreaInfo(code);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @GetMapping(value={"/division/{parentCode}"})
    @ApiOperation(value="1-03-10 \u6839\u636e\u4e0a\u7ea7\u7f16\u7801\u83b7\u53d6\u7701\u5e02\u533a\u53bf\u8857\u9053", notes="\u5982\u679cparentCode\u4e3a0,\u5219\u8fd4\u56de\u6700\u4e0a\u5c42\u7684\u7701\u4efd\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="parentCode", value="\u7236\u7ea7\u7f16\u53f7")})
    public Json<List<AreaDivisionDTO>> listAreaDivision(@PathVariable String parentCode) {
        return ResultUtil.genSuccessResult((Object)this.areaDivisionService.listAreaDivisionDTO(parentCode));
    }

    @GetMapping(value={"/info/detail/{code}"})
    @ApiOperation(value="1-03-11 \u540e\u53f0\u533a\u57df\u7ba1\u7406-\u6839\u636ecode\u5f97\u5230\u5730\u57df\u7684\u8be6\u7ec6\u4fe1\u606f")
    @ApiImplicitParam(name="code", value="\u5730\u533a\u7f16\u7801", required=true)
    public Json<AreaInfoDTO> getAreaDetail(@PathVariable String code) {
        return ResultUtil.genSuccessResult((Object)this.areaInfoService.getAreaInfo(code));
    }

    @GetMapping(value={"/city/{code}/list"})
    @ApiOperation(value="1-03-12 \u6839\u636e\u5e02\u7ea7\u4fe1\u606f\u83b7\u53d6\u5e02\u4e0b\u7684\u6240\u6709\u5df2\u5f00\u901a\u533a\u57df")
    @ApiImplicitParam(name="code", value="\u5730\u533a\u7f16\u7801", required=true)
    public Json<List<LocationDTO>> listCityLocation(@PathVariable String code) {
        List locationDTOList = this.locationService.listOpenedLocationByArea(code, Byte.valueOf((byte)1));
        return ResultUtil.genSuccessResult((Object)locationDTOList);
    }

    @PostMapping(value={"/communityContent/modify"})
    @ApiOperation(value="1-03-13 \u66f4\u65b0\u793e\u533a\u5185\u5bb9\u914d\u7f6e")
    public Json modifyCommunityContent(@RequestBody AreaInfoParam areaInfoParam) {
        try {
            int flag = this.areaInfoService.updateCommunityContent(areaInfoParam);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u793e\u533a\u5185\u5bb9\u5f02\u5e38", (Throwable)e);
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/customerService/modify"})
    @ApiOperation(value="1-03-14 \u66f4\u65b0\u5ba2\u670d\u5c0f\u52a9\u624b")
    public Json modifyCustomerService(@RequestBody AreaInfoParam areaInfoParam) {
        try {
            int flag = this.areaInfoService.updateCustomerService(areaInfoParam);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5ba2\u670d\u5c0f\u52a9\u624b\u5f02\u5e38", (Throwable)e);
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5ba2\u670d\u5c0f\u52a9\u624b\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/indexPublish/modify"})
    @ApiOperation(value="1-03-15 \u66f4\u65b0\u9996\u9875\u53d1\u5e16\u5165\u53e3")
    public Json modifyIndexPublish(@RequestBody AreaInfoParam areaInfoParam) {
        try {
            int flag = this.areaInfoService.updateIndexPublish(areaInfoParam);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u9996\u9875\u53d1\u5e16\u5165\u53e3\u5f02\u5e38", (Throwable)e);
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u9996\u9875\u53d1\u5e16\u5165\u53e3\u5f02\u5e38");
        }
    }

    @GetMapping(value={"/location/detail/{code}"})
    @ApiOperation(value="1-03-16 \u83b7\u53d6\u8be6\u60c5-\u9996\u9875\u53d1\u5e16\u5165\u53e3,\u5ba2\u670d\u5c0f\u52a9\u624b\uff0c\u793e\u533a\u5185\u5bb9\u914d\u7f6e")
    @ApiImplicitParam(name="code", value="\u5730\u533a\u7f16\u7801", required=true)
    public Json<LocationInfoDTO> getLocationDetail(@PathVariable String code) {
        try {
            LocationInfoDTO locationInfoDTO = this.areaInfoService.getLocationInfo(code);
            if (null == locationInfoDTO) {
                return ResultUtil.genFailedResult((String)"\u83b7\u53d6\u8be6\u60c5\u5931\u8d25");
            }
            return ResultUtil.genSuccessResult((Object)this.areaInfoService.getLocationInfo(code));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return ResultUtil.genFailedResult((String)"\u83b7\u53d6\u8be6\u60c5\u5f02\u5e38");
        }
    }

    @GetMapping(value={"/location/detail/hotCity"})
    @ApiOperation(value="1-03-17 \u83b7\u5f97\u70ed\u95e8\u57ce\u5e02")
    public Json<List<LocationDTO>> getHotCity() {
        List hotCitys = this.areaInfoService.getHotCity();
        return ResultUtil.genSuccessResult((Object)hotCitys);
    }
}

