/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.news;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminPushMessageDTO;
import com.bxm.localnews.admin.dto.PushMessageStatistical;
import com.bxm.localnews.admin.param.PushMessageParam;
import com.bxm.localnews.admin.service.activity.AdminPushMessageService;
import com.bxm.localnews.admin.vo.AdminPushMessage;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-27 \u6d88\u606f\u63a8\u9001\u76f8\u5173\u63a5\u53e3"}, description="")
@RestController
@RequestMapping(value={"/api/admin/push/message"})
public class AdminPushMessageController
extends CommonController {
    private AdminPushMessageService adminPushMessageService;

    @Autowired
    public AdminPushMessageController(AdminPushMessageService adminPushMessageService) {
        this.adminPushMessageService = adminPushMessageService;
    }

    @ApiOperation(value="1-27-1 \u83b7\u53d6\u6d88\u606f\u8bb0\u5f55\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u6d88\u606f\u6570\u636e")
    @GetMapping(value={"/list"})
    public Json<PageWarper<AdminPushMessageDTO>> getPushMessageList(PushMessageParam pushMessageParam) {
        return ResultUtil.genSuccessResult((Object)this.adminPushMessageService.queryPushMessageList(pushMessageParam));
    }

    @ApiOperation(value="1-27-2 \u63a8\u9001\u6d88\u606f\u6279\u91cf\u4fee\u6539\u72b6\u6001", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5b57\u7b26\u4e32\uff0c\u4ee5\u201d,\u201c\u5206\u9694", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"/batchUpdatePushMessage"})
    public Json updatePushMessageStatusByIds(String ids, Byte status) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String[] id = idsNew.split(",");
        if (id.length > 0) {
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
        }
        return ResultUtil.genFailedResult((String)"\u8bf7\u9009\u62e9\u65b0\u95fb");
    }

    @ApiOperation(value="1-27-3 \u83b7\u53d6\u63a8\u9001\u6d88\u606f\u8be6\u60c5", notes="")
    @ApiImplicitParam(name="id", value="\u6d3b\u52a8id", required=true)
    @GetMapping(value={"/getPushMessageDetail"})
    public Json<AdminPushMessage> getActivityDetail(Long id) {
        return ResultUtil.genSuccessResult((Object)this.adminPushMessageService.getDetail(id));
    }

    @ApiOperation(value="1-27-4 \u6d88\u606f\u4fee\u6539\u72b6\u6001(\u53d6\u6d88\u63a8\u9001)", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"/updatePushMessage"})
    public Json updatePushMessageStatusById(Long id, Byte status) {
        return ResultUtil.genSuccessResult((Object)this.adminPushMessageService.updateStatusPushMessage(id, status).getLashMessaage());
    }

    @ApiOperation(value="1-27-5 \u65b0\u589e\u6216\u7f16\u8f91\u6d88\u606f", notes="")
    @PostMapping(value={"/saveOrUpdatePushMessage"})
    public Json addPushMessageDetail(AdminPushMessage adminPushMessage) {
        Message message;
        if (adminPushMessage.getId() == null) {
            adminPushMessage.setCreateUserId(this.getLoginUser().getId());
        }
        if (!(message = this.adminPushMessageService.saveOrUpdatePushMessage(adminPushMessage)).isSuccess()) {
            return ResultUtil.genFailedResult((String)message.getLashMessaage());
        }
        return ResultUtil.genSuccessMsg((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="1-27-6 \u5bf9\u5e94\u6d88\u606f\u7684\u7edf\u8ba1\u4fe1\u606f", notes="")
    @ApiImplicitParam(name="messageId", value="\u6d88\u606fid", required=true)
    @GetMapping(value={"/statistics"})
    public Json<List<PushMessageStatistical>> statisticsMessage(Long messageId) {
        return ResultUtil.genSuccessResult((Object)this.adminPushMessageService.getStatistical(messageId));
    }

    @ApiOperation(value="1-27-7 \u6d88\u606f\u63a8\u9001\u6d4b\u8bd5", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6d88\u606fid", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    @PostMapping(value={"/test"})
    public Json testPushMessage(Long id, Long userId) {
        return ResultUtil.genSuccessResult((Object)this.adminPushMessageService.testPushMessage(id, userId));
    }

    @ApiOperation(value="1-27-8 \u6d88\u606f\u63a8\u9001", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true)})
    @PostMapping(value={"/immediate"})
    public Json immediatelyPushMessage(Long id) {
        return ResultUtil.genSuccessResult((Object)this.adminPushMessageService.immediatelyPushMessage(id));
    }

    @ApiOperation(value="1-27-9 \u6d88\u606f\u6279\u91cf\u7528\u6237\u63a8\u9001\u6d4b\u8bd5", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6d88\u606fid", required=true), @ApiImplicitParam(name="userIds", value="\u7528\u6237id\u7ec4, \u4ee5','\u5206\u9694", required=true)})
    @PostMapping(value={"/batch/test"})
    public Json batchTestPushMessage(Long id, String userIds) {
        return ResultUtil.genSuccessResult((Object)this.adminPushMessageService.testPushMessage(id, userIds));
    }
}

