/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.news;

import com.bxm.localnews.admin.param.NewsKindParam;
import com.bxm.localnews.admin.service.news.NewsKindService;
import com.bxm.localnews.admin.vo.NewsKind;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-30 [\u7ba1\u7406]\u65b0\u95fb\u9891\u9053\u7ba1\u7406"}, description="\u65b0\u95fb\u9891\u9053\u7ba1\u7406\u7684\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/kind"})
public class NewsKindController {
    @Autowired
    private NewsKindService newsKindService;

    @ApiOperation(value="1-30-1 \u83b7\u53d6\u65b0\u95fb\u9891\u9053\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u65b0\u95fb\u9891\u9053\u6570\u636e")
    @GetMapping(value={"/list"})
    public Json<PageWarper<NewsKind>> getNewsKindList(NewsKindParam newsKindParam) {
        return ResultUtil.genSuccessResult((Object)this.newsKindService.queryNewsKinds(newsKindParam));
    }

    @ApiOperation(value="1-30-2 \u83b7\u53d6\u65b0\u95fb\u9891\u9053\u8be6\u60c5", notes="")
    @GetMapping(value={"/detail"})
    public Json<NewsKind> getNewsKindById(Long id) {
        return ResultUtil.genSuccessResult((Object)this.newsKindService.selectByPrimaryKey(id));
    }

    @ApiOperation(value="1-30-3 \u65b0\u95fb\u9891\u9053\u4e0a\u4e0b\u67b6", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"updateStatus"})
    public Json updateNewsKindStatusById(Long id, Byte status) {
        if (this.newsKindService.updateNewsKindStatus(id, status) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-30-4 \u65b0\u589e\u6216\u7f16\u8f91\u65b0\u95fb\u9891\u9053", notes="")
    @PostMapping(value={"saveOrUpdateKinds"})
    public Json addNewsKindDetail(NewsKind newsKind) {
        if (this.newsKindService.addNewsKind(newsKind) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }
}

