package com.bxm.localnews.admin.controller;

import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags = "1-21 公共服务接口")
@Controller
public class AppController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppController.class);

    @ApiOperation("1-21-01 心跳检测，用于负载均衡")
    @RequestMapping("/app/heartbeat")
    @ResponseBody
    public String heartbeat() {
        //心跳检测使用
        return "ok";
    }

    @ApiOperation("1-21-02 测试请求超时")
    @RequestMapping("/app/test/timeout/{second}")
    @ResponseBody
    public String testTimeout(@PathVariable Long second) {
        try {
            Thread.sleep(second * 1000L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        return "response succed,sleep second:" + second;
    }
}
